/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public class ProcessorInfo
extends TypeStruct {
    byte[] socketDesign;
    byte[] processorType;
    byte[] processorFamily;
    byte[] processorManufact;
    byte[] pidEax;
    byte[] pidEdx;
    byte[] processorVer;
    byte[] voltage;
    byte[] externalClock;
    byte[] maxSpeed;
    byte[] currentSpeed;
    byte[] status;
    byte[] processorUpgrade;
    byte[] l1Cache;
    byte[] l2Cache;
    byte[] l3Cache;
    byte[] serialNumber;
    byte[] assetTag;
    byte[] partNumber;
    byte[] coreCount;
    byte[] coreEnabled;
    byte[] threadCount;
    byte[] processorCharacter;
    byte[] processorFamily2;
    byte[] coreCount2;
    byte[] coreEnabled2;
    byte[] threadCount2;

    public ProcessorInfo(byte[] dataByte) {
        super(dataByte);
        this.socketDesign = this.getTypeLength(this.BYTE);
        this.processorType = this.getTypeLength(this.BYTE);
        this.processorFamily = this.getTypeLength(this.BYTE);
        this.processorManufact = this.getTypeLength(this.BYTE);
        this.pidEax = this.getTypeLength(this.DWORD);
        this.pidEdx = this.getTypeLength(this.DWORD);
        this.processorVer = this.getTypeLength(this.BYTE);
        this.voltage = this.getTypeLength(this.BYTE);
        this.externalClock = this.getTypeLength(this.WORD);
        this.maxSpeed = this.getTypeLength(this.WORD);
        this.currentSpeed = this.getTypeLength(this.WORD);
        this.status = this.getTypeLength(this.BYTE);
        this.processorUpgrade = this.getTypeLength(this.BYTE);
        this.l1Cache = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.l1Cache);
        this.l2Cache = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.l2Cache);
        this.l3Cache = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.l3Cache);
        this.serialNumber = this.getTypeLength(this.BYTE);
        this.assetTag = this.getTypeLength(this.BYTE);
        this.partNumber = this.getTypeLength(this.BYTE);
        this.coreCount = this.getTypeLength(this.BYTE);
        this.coreEnabled = this.getTypeLength(this.BYTE);
        this.threadCount = this.getTypeLength(this.BYTE);
        this.processorCharacter = this.getTypeLength(this.WORD);
        this.processorFamily2 = this.getTypeLength(this.WORD);
        this.coreCount2 = this.getTypeLength(this.WORD);
        this.coreEnabled2 = this.getTypeLength(this.WORD);
        this.threadCount2 = this.getTypeLength(this.WORD);
        this.strFieldCount = 8;
    }

    int getSocketDesign() {
        return this.socketDesign[0];
    }

    String getProcessorType() {
        switch (this.processorType[0]) {
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "Central Processor";
            }
            case 4: {
                return "Math Processor";
            }
            case 5: {
                return "DSP Processor";
            }
            case 6: {
                return "Video Processor";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.processorType[0]) + ")";
    }

    String getProcessorFamily(byte processorFamily) {
        switch (processorFamily) {
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "8086";
            }
            case 4: {
                return "80286";
            }
            case 5: {
                return "Intel386 processor";
            }
            case 6: {
                return "Intel486 processor";
            }
            case 7: {
                return "8087";
            }
            case 8: {
                return "80287";
            }
            case 9: {
                return "80387";
            }
            case 10: {
                return "80487";
            }
            case 11: {
                return "Intel Pentium processor";
            }
            case 12: {
                return "Pentium Pro processor";
            }
            case 13: {
                return "Pentium II processor ";
            }
            case 14: {
                return "Pentium processor with MMX technology";
            }
            case 15: {
                return "Intel Celeron processor";
            }
            case 16: {
                return "Pentium II Xeon processor";
            }
            case 17: {
                return "Pentium III processor";
            }
            case 18: {
                return "M1 Family";
            }
            case 19: {
                return "M2 Family";
            }
            case 20: {
                return "Intel Celeron M processor";
            }
            case 21: {
                return "Intel Pentium 4 HT processor";
            }
            case 24: {
                return "AMD Duron Processor Family";
            }
            case 25: {
                return "K5 Family";
            }
            case 26: {
                return "K6 Family";
            }
            case 27: {
                return "K6-2";
            }
            case 28: {
                return "K6-3";
            }
            case 29: {
                return "AMD Athlon Processor Family";
            }
            case 30: {
                return "AMD29000 Family";
            }
            case 31: {
                return "K6-2+";
            }
            case 32: {
                return "Power PC Family";
            }
            case 33: {
                return "Power PC 601";
            }
            case 34: {
                return "Power PC 603";
            }
            case 35: {
                return "Power PC 603+";
            }
            case 36: {
                return "Power PC 604";
            }
            case 37: {
                return "Power PC 620";
            }
            case 38: {
                return "Power PC x704";
            }
            case 39: {
                return "Power PC 750";
            }
            case 40: {
                return "Intel Core Duo processor";
            }
            case 41: {
                return "Intel Core Duo mobile processor";
            }
            case 42: {
                return "Intel Core Solo mobile processor";
            }
            case 43: {
                return "Intel Atom processor";
            }
            case 44: {
                return "Intel Core M processor";
            }
            case 48: {
                return "Alpha Family";
            }
            case 49: {
                return "Alpha 21064";
            }
            case 50: {
                return "Alpha 21066";
            }
            case 51: {
                return "Alpha 21164";
            }
            case 52: {
                return "Alpha 21164PC";
            }
            case 53: {
                return "Alpha 21164a";
            }
            case 54: {
                return "Alpha 21264";
            }
            case 55: {
                return "Alpha 21364";
            }
            case 56: {
                return "AMD Turion II Ultra Dual-Core M Processor Family";
            }
            case 57: {
                return "AMD Turion II Dual-Core Mobile M Processor Family";
            }
            case 58: {
                return "AMD Athlon II Dual-Core M Processor Family";
            }
            case 59: {
                return "AMD Opteron 6100 Series Processor";
            }
            case 60: {
                return "AMD Opteron 4100 Series Processor";
            }
            case 61: {
                return "AMD Opteron 6200 Series Processor";
            }
            case 62: {
                return "AMD Opteron 4200 Series Processor";
            }
            case 63: {
                return "AMD FX Series Processor";
            }
            case 64: {
                return "MIPS Family";
            }
            case 65: {
                return "MIPS R4000";
            }
            case 66: {
                return "MIPS R4200";
            }
            case 67: {
                return "MIPS R4400";
            }
            case 68: {
                return "MIPS R4600";
            }
            case 69: {
                return "MIPS R10000";
            }
            case 70: {
                return "AMD C-Series Processor";
            }
            case 71: {
                return "AMD E-Series Processor";
            }
            case 72: {
                return "AMD A-Series Processor";
            }
            case 73: {
                return "AMD G-Series Processor";
            }
            case 74: {
                return "AMD Z-Series Processor";
            }
            case 75: {
                return "AMD R-Series Processor";
            }
            case 76: {
                return "AMD Opteron 4300 Series Processor";
            }
            case 77: {
                return "AMD Opteron 6300 Series Processor";
            }
            case 78: {
                return "AMD Opteron 3300 Series Processor";
            }
            case 79: {
                return "AMD FirePro Series Processor";
            }
            case 80: {
                return "SPARC Family";
            }
            case 81: {
                return "SuperSPARC";
            }
            case 82: {
                return "microSPARC II";
            }
            case 83: {
                return "microSPARC IIep";
            }
            case 84: {
                return "UltraSPARC";
            }
            case 85: {
                return "UltraSPARC II";
            }
            case 86: {
                return "UltraSPARC Iii";
            }
            case 87: {
                return "UltraSPARC III";
            }
            case 88: {
                return "UltraSPARC IIIi";
            }
            case 96: {
                return "68040 Family";
            }
            case 97: {
                return "68xxx";
            }
            case 98: {
                return "68000";
            }
            case 99: {
                return "68010";
            }
            case 100: {
                return "68020";
            }
            case 101: {
                return "68030";
            }
            case 102: {
                return "AMD Athlon(TM) X4 Quad-Core Processor Family";
            }
            case 103: {
                return "AMD Opteron(TM) X1000 Series Processor";
            }
            case 104: {
                return "AMD Opteron(TM) X2000 Series APU";
            }
            case 112: {
                return "Hobbit Family";
            }
            case 120: {
                return "Crusoe TM5000 Family";
            }
            case 121: {
                return "Crusoe TM3000 Family";
            }
            case 122: {
                return "Crusoe TM8000 Family";
            }
            case -128: {
                return "Weitek";
            }
            case -126: {
                return "Itanium processor";
            }
            case -125: {
                return "AMD Athlon 64 Processor Family";
            }
            case -124: {
                return "AMD Opteron Processor Family";
            }
            case -123: {
                return "AMD Sempron Processor Family";
            }
            case -122: {
                return "AMD Turion 64 Mobile Technology";
            }
            case -121: {
                return "Dual-Core AMD Opteron Processor Family";
            }
            case -120: {
                return "AMD Athlon 64 X2 Dual-Core Processor Family";
            }
            case -119: {
                return "AMD Turion 64 X2 Mobile Technology";
            }
            case -118: {
                return "Quad-Core AMD Opteron Processor Family";
            }
            case -117: {
                return "Third-Generation AMD Opteron Processor Family";
            }
            case -116: {
                return "AMD Phenom FX Quad-Core Processor Family";
            }
            case -115: {
                return "AMD Phenom X4 Quad-Core Processor Family";
            }
            case -114: {
                return "AMD Phenom X2 Dual-Core Processor Family";
            }
            case -113: {
                return "AMD Athlon X2 Dual-Core Processor Family";
            }
            case -112: {
                return "PA-RISC Family";
            }
            case -111: {
                return "PA-RISC 8500";
            }
            case -110: {
                return "PA-RISC 8000";
            }
            case -109: {
                return "PA-RISC 7300LC";
            }
            case -108: {
                return "PA-RISC 7200";
            }
            case -107: {
                return "PA-RISC 7100LC";
            }
            case -106: {
                return "PA-RISC 7100";
            }
            case -96: {
                return "V30 Family";
            }
            case -95: {
                return "Quad-Core Intel Xeon processor 3200 Series";
            }
            case -94: {
                return "Dual-Core Intel Xeon processor 3000 Series";
            }
            case -93: {
                return "Quad-Core Intel Xeon processor 5300 Series";
            }
            case -92: {
                return "Dual-Core Intel Xeon processor 5100 Series";
            }
            case -91: {
                return "Dual-Core Intel Xeon processor 5000 Series";
            }
            case -90: {
                return "Dual-Core Intel Xeon processor LV";
            }
            case -89: {
                return "Dual-Core Intel Xeon processor ULV";
            }
            case -88: {
                return "Dual-Core Intel Xeon processor 7100 Series";
            }
            case -87: {
                return "Quad-Core Intel Xeon processor 5400 Series";
            }
            case -86: {
                return "Quad-Core Intel Xeon processor";
            }
            case -85: {
                return "Dual-Core Intel Xeon processor 5200 Series";
            }
            case -84: {
                return "Dual-Core Intel Xeon processor 7200 Series";
            }
            case -83: {
                return "Quad-Core Intel Xeon processor 7300 Series";
            }
            case -82: {
                return "Quad-Core Intel Xeon processor 7400 Series";
            }
            case -81: {
                return "Multi-Core Intel Xeon processor 7400 Series";
            }
            case -80: {
                return "Pentium III Xeon processor";
            }
            case -79: {
                return "Pentium III with Intel SpeedStep Technology";
            }
            case -78: {
                return "Pentium 4 Processor";
            }
            case -77: {
                return "Intel Xeon processor";
            }
            case -76: {
                return "AS400 Family";
            }
            case -75: {
                return "Intel Xeon processor MP";
            }
            case -74: {
                return "AMD Athlon XP Processor Family";
            }
            case -73: {
                return "AMD Athlon MP Processor Family";
            }
            case -72: {
                return "Intel Itanium 2 processor";
            }
            case -71: {
                return "Intel Pentium M processor";
            }
            case -70: {
                return "Intel Celeron D processor";
            }
            case -69: {
                return "Intel Pentium D processor";
            }
            case -68: {
                return "Intel Pentium Processor Extreme Edition";
            }
            case -67: {
                return "Intel Core Solo Processor";
            }
            case -66: {
                return "Reserved";
            }
            case -65: {
                return "Intel Core 2 Duo Processor";
            }
            case -64: {
                return "Intel Core 2 Solo processor";
            }
            case -63: {
                return "Intel Core 2 Extreme processor";
            }
            case -62: {
                return "Intel Core 2 Quad processor";
            }
            case -61: {
                return "Intel Core 2 Extreme mobile processor";
            }
            case -60: {
                return "Intel Core 2 Duo mobile processor";
            }
            case -59: {
                return "Intel Core 2 Solo mobile processor";
            }
            case -58: {
                return "Intel Core i7 processor";
            }
            case -57: {
                return "Dual-Core Intel Celeron processor";
            }
            case -56: {
                return "IBM390 Family";
            }
            case -55: {
                return "G4";
            }
            case -54: {
                return "G5";
            }
            case -53: {
                return "ESA/390 G6";
            }
            case -52: {
                return "z/Architecture base";
            }
            case -51: {
                return "Intel Core i5 processor";
            }
            case -50: {
                return "Intel Core i3 processor";
            }
            case -46: {
                return "VIA C7-M Processor Family";
            }
            case -45: {
                return "VIA C7-D Processor Family";
            }
            case -44: {
                return "VIA C7 Processor Family";
            }
            case -43: {
                return "VIA Eden Processor Family";
            }
            case -42: {
                return "Multi-Core Intel Xeon processor";
            }
            case -41: {
                return "Dual-Core Intel Xeon processor 3xxx Series";
            }
            case -40: {
                return "Quad-Core Intel Xeon processor 3xxx Series";
            }
            case -39: {
                return "VIA Nano Processor Family";
            }
            case -38: {
                return "Dual-Core Intel Xeon processor 5xxx Series";
            }
            case -37: {
                return "Quad-Core Intel Xeon processor 5xxx Series";
            }
            case -35: {
                return "Dual-Core Intel Xeon processor 7xxx Series";
            }
            case -34: {
                return "Quad-Core Intel Xeon processor 7xxx Serie";
            }
            case -33: {
                return "Multi-Core Intel Xeon processor 7xxx Series";
            }
            case -32: {
                return "Multi-Core Intel Xeon processor 3400 Series";
            }
            case -28: {
                return "AMD Opteron 3000 Series Processor";
            }
            case -27: {
                return "AMD Sempron II Processor";
            }
            case -26: {
                return "Embedded AMD Opteron Quad-Core Processor Family";
            }
            case -25: {
                return "AMD Phenom Triple-Core Processor Family";
            }
            case -24: {
                return "AMD Turion Ultra Dual-Core Mobile Processor Family";
            }
            case -23: {
                return "AMD Turion Dual-Core Mobile Processor Family";
            }
            case -22: {
                return "AMD Athlon Dual-Core Processor Family";
            }
            case -21: {
                return "AMD Sempron SI Processor Family";
            }
            case -20: {
                return "AMD Phenom II Processor Family";
            }
            case -19: {
                return "AMD Athlon II Processor Family";
            }
            case -18: {
                return "Six-Core AMD Opteron Processor Family";
            }
            case -17: {
                return "AMD Sempron M Processor Family";
            }
            case -6: {
                return "i860";
            }
            case -5: {
                return "i960";
            }
            case -2: {
                return "Indicator to obtain the processor family from the Processor Family 2 field";
            }
            case -1: {
                return "Reserved";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(processorFamily) + ")";
    }

    int getProcessorManufact() {
        return this.processorManufact[0];
    }

    String getProcessorId() {
        String eax = ByteUtility.bytesToHex(this.pidEax);
        String edx = ByteUtility.bytesToHex(this.pidEdx);
        return eax + edx.trim();
    }

    int getVersion() {
        return this.processorVer[0];
    }

    String getVoltage() {
        int bit;
        BitSet bitSet = BitSet.valueOf(this.voltage);
        int bitCount = 0;
        for (bit = 0; bit <= 7; ++bit) {
            if (!bitSet.get(bit)) continue;
            ++bitCount;
        }
        if (bitCount == 0) {
            return "None (0x" + ByteUtility.byteToHex(this.voltage[0]) + ")";
        }
        for (bit = 3; bit <= 6; ++bit) {
            if (!bitSet.get(bit)) continue;
            return "Unknown (0x" + ByteUtility.byteToHex(this.voltage[0]) + ")";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Supported: ");
        if (bitSet.get(0)) {
            sb.append("5V ");
        }
        if (bitSet.get(1)) {
            sb.append("3.3V ");
        }
        if (bitSet.get(2)) {
            sb.append("2.9V ");
        }
        if (!bitSet.get(7)) {
            sb.append("(legacy mode)");
        }
        return sb.toString();
    }

    int getExternalClock() {
        return ByteUtility.twoBytesToIntLSB(this.externalClock);
    }

    int getMaxSpeed() {
        return ByteUtility.twoBytesToIntLSB(this.maxSpeed);
    }

    int getCurrentSpeed() {
        return ByteUtility.twoBytesToIntLSB(this.currentSpeed);
    }

    String getStatus() {
        BitSet bitSet = BitSet.valueOf(this.status);
        BitSet bitStatus = BitSet.valueOf(new byte[]{7});
        if (bitSet.get(7)) {
            return " Unknown (0x" + ByteUtility.byteToHex(this.status[0]) + ")";
        }
        for (int bit = 3; bit <= 5; ++bit) {
            if (!bitSet.get(bit)) continue;
            return " Unknown (0x" + ByteUtility.byteToHex(this.status[0]) + ")";
        }
        StringBuilder sb = new StringBuilder();
        if (bitSet.get(6)) {
            sb.append(" Populated \n");
        } else {
            sb.append(" Unpopulated \n");
        }
        bitSet.and(bitStatus);
        switch (ProcessorInfo.bitsToInt(bitSet)) {
            case 0: {
                sb.append(" Unknown \n");
                break;
            }
            case 1: {
                sb.append(" CPU Enabled \n");
                break;
            }
            case 2: {
                sb.append(" CPU Disabled by User through BIOS Setup \n");
                break;
            }
            case 3: {
                sb.append(" CPU Disabled By BIOS (POST Error) \n");
                break;
            }
            case 4: {
                sb.append(" CPU is Idle, waiting to be enabled \n");
                break;
            }
            case 7: {
                sb.append(" Status: Other \n");
                break;
            }
            default: {
                sb.append(" None \n");
            }
        }
        return sb.toString();
    }

    String getProcessorUpgrade() {
        switch (this.processorUpgrade[0]) {
            case 1: {
                return "Other";
            }
            case 2: {
                return "Unknown";
            }
            case 3: {
                return "Daughter Board";
            }
            case 4: {
                return "ZIF Socket";
            }
            case 5: {
                return "Replaceable Piggy Back";
            }
            case 6: {
                return "None";
            }
            case 7: {
                return "LIF Socket";
            }
            case 8: {
                return "Slot 1";
            }
            case 9: {
                return "Slot 2";
            }
            case 10: {
                return "370-pin socket";
            }
            case 11: {
                return "Slot A";
            }
            case 12: {
                return "Slot M";
            }
            case 13: {
                return "Socket 423";
            }
            case 14: {
                return "Socket A (Socket 462)";
            }
            case 15: {
                return "Socket 478";
            }
            case 16: {
                return "Socket 754";
            }
            case 17: {
                return "Socket 940";
            }
            case 18: {
                return "Socket 939";
            }
            case 19: {
                return "Socket mPGA604";
            }
            case 20: {
                return "Socket LGA771";
            }
            case 21: {
                return "Socket LGA775";
            }
            case 22: {
                return "Socket S1";
            }
            case 23: {
                return "Socket AM2";
            }
            case 24: {
                return "Socket F (1207)";
            }
            case 25: {
                return "Socket LGA1366";
            }
            case 26: {
                return "Socket G34";
            }
            case 27: {
                return "Socket AM3";
            }
            case 28: {
                return "Socket C32";
            }
            case 29: {
                return "Socket LGA1156";
            }
            case 30: {
                return "Socket LGA1567";
            }
            case 31: {
                return "Socket PGA988A";
            }
            case 32: {
                return "Socket BGA1288";
            }
            case 33: {
                return "Socket rPGA988B";
            }
            case 34: {
                return "Socket BGA1023";
            }
            case 35: {
                return "Socket BGA1224";
            }
            case 36: {
                return "Socket LGA1155";
            }
            case 37: {
                return "Socket LGA1356";
            }
            case 38: {
                return "Socket LGA2011";
            }
            case 39: {
                return "Socket FS1";
            }
            case 40: {
                return "Socket FS2";
            }
            case 41: {
                return "Socket FM1";
            }
            case 42: {
                return "Socket FM2";
            }
            case 43: {
                return "Socket LGA2011-3";
            }
            case 44: {
                return "Socket LGA1356-3";
            }
            case 45: {
                return "Socket LGA1150";
            }
            case 46: {
                return "Socket BGA1168";
            }
            case 47: {
                return "Socket BGA1234";
            }
            case 48: {
                return "Socket BGA1364";
            }
        }
        return null;
    }

    String getL1Cache() {
        String l1cache = ByteUtility.bytesToHexNoSpace(this.l1Cache);
        if ("FFFF".equals(l1cache)) {
            return "No L1 Cache or not provided";
        }
        return "0x" + l1cache;
    }

    String getL2Cache() {
        String l2cache = ByteUtility.bytesToHexNoSpace(this.l2Cache);
        if ("FFFF".equals(l2cache)) {
            return "No L2 Cache or not provided";
        }
        return "0x" + l2cache;
    }

    String getL3Cache() {
        String l3cache = ByteUtility.bytesToHexNoSpace(this.l3Cache);
        if ("FFFF".equals(l3cache)) {
            return "No L3 Cache or not provided";
        }
        return "0x" + l3cache;
    }

    int getSerialNumber() {
        return this.serialNumber[0];
    }

    int getAssetTag() {
        return this.assetTag[0];
    }

    int getPartNumber() {
        return this.partNumber[0];
    }

    int getCoreCount() {
        return this.coreCount[0] & 0xFF;
    }

    int getCoreEnabled() {
        return this.coreEnabled[0] & 0xFF;
    }

    int getThreadCount() {
        return this.threadCount[0] & 0xFF;
    }

    String getProcessorCharacter() {
        StringBuilder sb = new StringBuilder();
        BitSet bitSet = BitSet.valueOf(this.processorCharacter);
        int zeroCount = 0;
        for (int i = 0; i <= 7; ++i) {
            if (!bitSet.get(i)) continue;
            ++zeroCount;
        }
        if (zeroCount == 0) {
            return " Unknown \n";
        }
        if (bitSet.get(1)) {
            return " Unknown \n";
        }
        if (bitSet.get(2)) {
            sb.append(" 64-bit Capable \n");
        }
        if (bitSet.get(3)) {
            sb.append(" Multi-Core \n");
        }
        if (bitSet.get(4)) {
            sb.append(" Hardware Thread \n");
        }
        if (bitSet.get(5)) {
            sb.append(" Execute Protection \n");
        }
        if (bitSet.get(6)) {
            sb.append(" Enhanced Virtualization \n");
        }
        if (bitSet.get(7)) {
            sb.append(" Power/Performance Control \n");
        }
        return sb.toString();
    }

    String getProcessorFamily2() {
        if (this.processorFamily2[1] == 0) {
            return this.getProcessorFamily(this.processorFamily2[0]);
        }
        int processorFamily = ByteUtility.twoBytesToIntLSB(this.processorFamily2);
        switch (processorFamily) {
            case 260: {
                return "SH-3";
            }
            case 261: {
                return "SH-4";
            }
            case 280: {
                return "ARM";
            }
            case 281: {
                return "StrongARM";
            }
            case 300: {
                return "6x86";
            }
            case 301: {
                return "MediaGX";
            }
            case 302: {
                return "MII";
            }
            case 320: {
                return "WinChip";
            }
            case 350: {
                return "DSP";
            }
            case 500: {
                return "Video Processor";
            }
        }
        return "Reserved (" + processorFamily + ")";
    }

    int getCoreCount2() {
        return ByteUtility.twoBytesToIntLSB(this.coreCount2);
    }

    int getCoreEnabled2() {
        return ByteUtility.twoBytesToIntLSB(this.coreEnabled2);
    }

    int getThreadCount2() {
        return ByteUtility.twoBytesToIntLSB(this.threadCount2);
    }

    public String getProcessorSocketDesign() {
        return this.strField[this.getSocketDesign()] != null ? this.strField[this.getSocketDesign()] : "N/A";
    }

    public String getProcessorVersion() {
        return this.strField[this.getVersion()] != null ? this.strField[this.getVersion()] : "N/A";
    }

    public int getProcessorCoreCount() {
        return this.coreCount[0] & 0xFF;
    }

    public float getProcessorMaxSpeed() {
        return (float)this.getMaxSpeed() / 1000.0f;
    }

    @Override
    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %42s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format("\n", new Object[0]));
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "-------------------------", "----------------------------------------"));
        return header.toString();
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %42s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "Processor Information"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "Socket Design", this.strField[this.getSocketDesign()] != null ? this.strField[this.getSocketDesign()] : "N/A"));
        fStr.append(String.format(format, "Processor Type", this.getProcessorType()));
        fStr.append(String.format(format, "Processor Family", this.getProcessorFamily(this.processorFamily[0])));
        fStr.append(String.format(format, "Processor Manufacturer", this.strField[this.getProcessorManufact()] != null ? this.strField[this.getProcessorManufact()] : "N/A"));
        fStr.append(String.format(format, "Processor Id", this.getProcessorId()));
        fStr.append(String.format(format, "Processor Version", this.strField[this.getVersion()] != null ? this.strField[this.getVersion()] : "N/A"));
        fStr.append(String.format(format, "Voltage", this.getVoltage()));
        fStr.append(String.format(format, "External Clock", this.getExternalClock() != 0 ? this.getExternalClock() + " Mhz" : "Unknown"));
        fStr.append(String.format(format, "Max Speed", this.getMaxSpeed() != 0 ? this.getMaxSpeed() + " Mhz" : "Unknown"));
        fStr.append(String.format(format, "Current Speed", this.getCurrentSpeed() != 0 ? this.getCurrentSpeed() + " Mhz" : "Unknown"));
        fStr.append(String.format(format, "Processor Upgrade", this.getProcessorUpgrade()));
        fStr.append(String.format(format, "L1 Cache Handle", this.getL1Cache()));
        fStr.append(String.format(format, "L2 Cache Handle", this.getL2Cache()));
        fStr.append(String.format(format, "L3 Cache Handle", this.getL3Cache()));
        fStr.append(String.format(format, "Serial Number", this.strField[this.getSerialNumber()] != null ? this.strField[this.getSerialNumber()] : "N/A"));
        fStr.append(String.format(format, "Asset Tag", this.strField[this.getAssetTag()] != null ? this.strField[this.getAssetTag()] : "N/A"));
        fStr.append(String.format(format, "Part Number", this.strField[this.getPartNumber()] != null ? this.strField[this.getPartNumber()] : "N/A"));
        fStr.append(String.format(format, "Core Count", this.getCoreCount() != 0 ? Integer.valueOf(this.getCoreCount()) : "Unknown"));
        fStr.append(String.format(format, "Core Enabled", this.getCoreEnabled() != 0 ? Integer.valueOf(this.getCoreEnabled()) : "Unknown"));
        fStr.append(String.format(format, "Thread Count", this.getThreadCount() != 0 ? Integer.valueOf(this.getThreadCount()) : "Unknown"));
        fStr.append(String.format(format, "Processor Family 2", this.getProcessorFamily2()));
        fStr.append(String.format(format, "Core Count 2", this.getCoreCount2() != 0 ? this.getCoreCount2() + " (0x" + ProcessorInfo.intTo4Hex(this.getCoreCount2()) + ")" : "Unknown"));
        fStr.append(String.format(format, "Core Enabled 2", this.getCoreEnabled2() != 0 ? this.getCoreEnabled2() + " (0x" + ProcessorInfo.intTo4Hex(this.getCoreEnabled2()) + ")" : "Unknown"));
        fStr.append(String.format(format, "Thread Count 2", this.getThreadCount2() != 0 ? this.getThreadCount2() + " (0x" + ProcessorInfo.intTo4Hex(this.getThreadCount2()) + ")" : "Unknown"));
        if (this.debug) {
            fStr.append(String.format("-------------------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(" Status: \n", new Object[0]));
            fStr.append(String.format("-------------------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(this.getStatus(), new Object[0]));
            fStr.append(String.format("-------------------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(" Processor Characteristics: \n", new Object[0]));
            fStr.append(String.format("-------------------------------------------------------------------------- \n", new Object[0]));
            fStr.append(String.format(this.getProcessorCharacter(), new Object[0]));
            fStr.append(String.format("\n", new Object[0]));
        }
        return fStr.toString();
    }
}

