/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NicInfo
extends TypeStruct {
    byte[] classCode;
    byte[] slotNumber;
    byte[] vendorId;
    byte[] deviceId;
    byte[] subVendorId;
    byte[] subDeviceId;
    byte[] maxSpeed;
    byte[] currentSpeed;
    byte[] portIndex;
    byte[] macAddress;
    byte[] fwVersion;

    public NicInfo(byte[] dataByte) {
        super(dataByte);
        this.classCode = this.getTypeLength(this.BYTE);
        this.slotNumber = this.getTypeLength(this.WORD);
        this.vendorId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.vendorId);
        this.deviceId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.deviceId);
        this.subVendorId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.subVendorId);
        this.subDeviceId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse((byte[])this.subDeviceId);
        this.maxSpeed = this.getTypeLength(this.DWORD);
        this.currentSpeed = this.getTypeLength(this.DWORD);
        this.portIndex = this.getTypeLength(this.WORD);
        this.macAddress = this.getTypeLength(32);
        this.fwVersion = this.getTypeLength(this.BYTE);
        this.strFieldCount = 3;
    }

    byte getClassCode() {
        return this.classCode[0];
    }

    int getSlotNumber() {
        return ByteUtility.twoBytesToIntLSB(this.slotNumber);
    }

    String getVendorId() {
        return ByteUtility.bytesToHexNoSpace(this.vendorId);
    }

    String getDeviceId() {
        return ByteUtility.bytesToHexNoSpace(this.deviceId);
    }

    String getSubVendorId() {
        return ByteUtility.bytesToHexNoSpace(this.subVendorId);
    }

    String getSubDeviceId() {
        return ByteUtility.bytesToHexNoSpace(this.subDeviceId);
    }

    int getMaxSpeed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.maxSpeed);
    }

    int getCurrentSpeed() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.currentSpeed);
    }

    int getPortIndex() {
        return ByteUtility.twoBytesToIntLSB(this.portIndex);
    }

    String getMacAddress() {
        return ByteUtility.bytesToHex(this.macAddress).replaceAll(" ", ":");
    }

    int getFWVersion() {
        return this.fwVersion[0];
    }

    @Override
    public String toFormatedHeader() {
        String formatTemplate = " %-30s | %30s \n";
        StringBuffer header = new StringBuffer();
        header.append(String.format("\n", new Object[0]));
        header.append(String.format(formatTemplate, "Item", "Value"));
        header.append(String.format(formatTemplate, "-------------------------", "-------------------------"));
        return header.toString();
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "NIC Information"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "PCI Class Code", "0x" + ByteUtility.byteToHex(this.getClassCode())));
        fStr.append(String.format(format, "Slot Number", this.getSlotNumber()));
        fStr.append(String.format(format, "Vendor ID", "0x" + this.getVendorId()));
        fStr.append(String.format(format, "Device ID", "0x" + this.getDeviceId()));
        fStr.append(String.format(format, "SubVendor ID", "0x" + this.getSubVendorId()));
        fStr.append(String.format(format, "SubDevice ID", "0x" + this.getSubDeviceId()));
        fStr.append(String.format(format, "Maximum Speed", this.getMaxSpeed() + " MB"));
        fStr.append(String.format(format, "Current Speed", this.getCurrentSpeed() + " MB"));
        fStr.append(String.format(format, "Port Index", this.getPortIndex()));
        fStr.append(String.format(format, "MAC Address", StringUtils.isNotBlank((CharSequence)this.getMacAddress()) ? this.getMacAddress().substring(0, 17) : "N/A"));
        fStr.append(String.format(format, "Firmware Version", StringUtils.isNotBlank((CharSequence)this.strField[this.getFWVersion()]) ? this.strField[this.getFWVersion()] : "N/A"));
        fStr.append(String.format("\n", new Object[0]));
        return fStr.toString();
    }
}

