/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.lic;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SDRRecordC0h_NMOEMSDR;
import com.supermicro.ipmi.lic.SWKeyException;
import com.supermicro.ipmi.lic.SWKeyExpiredException;
import com.supermicro.swproductkey.AESTool;
import com.supermicro.swproductkey.IPMICmdErrorCompletionCodeException;
import com.supermicro.swproductkey.InvalidMacAddressFormatException;
import com.supermicro.swproductkey.InvalidProductKeyFormatException;
import com.supermicro.swproductkey.InvalidProductKeyListFormatException;
import com.supermicro.swproductkey.InvalidSWFRUIndexException;
import com.supermicro.swproductkey.NoSWFRUSupportException;
import com.supermicro.swproductkey.ProductKey;
import com.supermicro.swproductkey.ProductKeyActivation;
import com.supermicro.swproductkey.ProductKeyListInstance;
import com.supermicro.swproductkey.SWIDEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class License {
    public static boolean isGrantleyPlatform(String ip, String id, String password) throws IOException, IPMIException {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(id);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            return false;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return false;
        }
        SDRRecordC0h_NMOEMSDR nmOEMSDR = new IPMISDRCommand(rmcp).getNMSDR();
        if (nmOEMSDR == null || !nmOEMSDR.isNMOEMSDR()) {
            return false;
        }
        IPMINM20Command ipmiNM20Command = null;
        if (nmOEMSDR.isIPMB()) {
            IPMB ipmb = new IPMB(rmcp);
            ipmb.setAddress(nmOEMSDR.getSlaveAddress());
            ipmb.setChannel(nmOEMSDR.getChannel());
            ipmb.setIpmbType(0);
            ipmiNM20Command = new IPMINM20Command(ipmb);
        } else {
            ipmiNM20Command = new IPMINM20Command(rmcp);
        }
        return ipmiNM20Command.getDeviceID().raw[9] >= 5;
    }

    public static boolean isSWFRUSupported(String ip, String id, String password) {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
        boolean result = false;
        try {
            result = ProductKeyActivation.isSWFRUSupported((String)ip, (String)id, (String)password);
        }
        catch (NoSWFRUSupportException noSWFRUSupportException) {
            // empty catch block
        }
        return result;
    }

    public static List<ProductKey> getSWProductKeyList(String ip, String id, String password) throws IPMICmdErrorCompletionCodeException, InvalidSWFRUIndexException, InvalidKeyException, Base64DecodingException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidProductKeyFormatException, InvalidMacAddressFormatException, NoSWFRUSupportException {
        ArrayList<ProductKey> productKeyList = new ArrayList<ProductKey>();
        ProductKeyActivation pkActivation = new ProductKeyActivation(ip, id, password);
        if (pkActivation.getNumOfProductKey() > 0) {
            for (int i = 1; i < 255; ++i) {
                byte aSWID = pkActivation.getProductKeySWID(i);
                if (aSWID == -1 || aSWID == 0) continue;
                String tmpStr = Base64.encode(pkActivation.getEncryptedProductKey(i));
                ProductKey pk = ProductKey.parseByteArray((byte[])AESTool.getBase64DecodeAndDecrypted((int)ProductKey.getNumOfUnencryptBlock(), (String)pkActivation.getMacAddress(), (String)tmpStr));
                productKeyList.add(pk);
            }
        }
        return productKeyList;
    }

    public static void activate(String ip, String id, String password, String key) throws IPMICmdErrorCompletionCodeException, Base64DecodingException, InvalidSWFRUIndexException, NoSWFRUSupportException, BadPaddingException {
        ProductKeyActivation pkActivation = new ProductKeyActivation(ip, id, password);
        pkActivation.activateProductKey(Base64.decode(key));
    }

    public static ProductKeyListInstance[] getProductKeyListFromFile(String keyFile) throws IOException, InvalidProductKeyListFormatException {
        String aLine;
        ArrayList<String> lines = new ArrayList<String>();
        FileReader fileReader = new FileReader(new File(keyFile));
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        while ((aLine = bufferedReader.readLine()) != null) {
            lines.add(aLine);
        }
        fileReader.close();
        ArrayList<ProductKeyListInstance> keyInstanceList = new ArrayList<ProductKeyListInstance>();
        for (String line : lines) {
            if (line.trim().length() == 0 || line.trim().indexOf("#") == 0) continue;
            keyInstanceList.add(ProductKeyListInstance.parseAProductKeyListInstance((String)line));
        }
        return keyInstanceList.toArray(new ProductKeyListInstance[0]);
    }

    public static void activateKeys(String file) throws IOException, InvalidProductKeyListFormatException, IPMICmdErrorCompletionCodeException, InvalidSWFRUIndexException, NoSWFRUSupportException, BadPaddingException {
        ProductKeyListInstance[] productKeyList = License.getProductKeyListFromFile(file);
        if (productKeyList == null || productKeyList.length < 1) {
            return;
        }
        for (ProductKeyListInstance ptoductKey : productKeyList) {
            String ip = ptoductKey.getIpAddress();
            String id = ptoductKey.getId();
            String pw = ptoductKey.getPw();
            if (id == null || pw == null || !ProductKeyActivation.isIpmiLoginable((String)ip, (String)id, (String)pw)) continue;
            ProductKeyActivation pkActivation = new ProductKeyActivation(ip, id, pw);
            pkActivation.activateProductKey(ptoductKey.getKey());
        }
    }

    public static boolean check_SFT_DCMS_SINGLE_ProductKey(String ip, String id, String password) throws InvalidKeyException, Base64DecodingException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IPMICmdErrorCompletionCodeException, InvalidSWFRUIndexException, InvalidProductKeyFormatException, InvalidMacAddressFormatException, SWKeyException, NoSWFRUSupportException {
        List<ProductKey> productKeyList = License.getSWProductKeyList(ip, id, password);
        if (productKeyList == null || productKeyList.size() < 1) {
            return false;
        }
        ProductKeyActivation pkActivation = new ProductKeyActivation(ip, id, password);
        for (int i = 0; i < productKeyList.size(); ++i) {
            ProductKey pk = productKeyList.get(i);
            if (pk.getSWID() != SWIDEnum.SWID_ALL.getID()) continue;
            if (!pkActivation.isProductKeyExpired(pk)) {
                return true;
            }
            throw new SWKeyExpiredException();
        }
        return false;
    }

    public static boolean check_SFT_SUM_LIC_ProductKey(String ip, String id, String password) throws InvalidKeyException, Base64DecodingException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IPMICmdErrorCompletionCodeException, InvalidSWFRUIndexException, InvalidProductKeyFormatException, InvalidMacAddressFormatException, SWKeyException, NoSWFRUSupportException {
        List<ProductKey> productKeyList = License.getSWProductKeyList(ip, id, password);
        if (productKeyList == null || productKeyList.size() < 1) {
            return false;
        }
        ProductKeyActivation pkActivation = new ProductKeyActivation(ip, id, password);
        for (int i = 0; i < productKeyList.size(); ++i) {
            ProductKey pk = productKeyList.get(i);
            if (pk.getSWID() == SWIDEnum.SWID_ALL.getID()) {
                if (!pkActivation.isProductKeyExpired(pk)) {
                    return true;
                }
                throw new SWKeyExpiredException();
            }
            if (pk.getSWID() != SWIDEnum.SWID_SUM.getID()) continue;
            if (!pkActivation.isProductKeyExpired(pk)) {
                return true;
            }
            throw new SWKeyExpiredException();
        }
        return false;
    }

    public static boolean confirmIsTwitterOEMProject(IPMIInterfaceConfig config) throws Exception {
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            return false;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return false;
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(rmcp);
        byte[] boardID = ipmiOEMCommand.getProductID();
        if (boardID == null) {
            return false;
        }
        if (boardID[0] != 101 || boardID[1] != 8) {
            return false;
        }
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(rmcp);
        FRUInfo fruInfo1 = ipmiFRUCommand.getFRUData((byte)1);
        String productName = new String(fruInfo1.fru.board.boardProductName);
        return productName.equals("X10DRD-LTP-TW008") || productName.equals("X10DRD-LTP-B-TW008");
    }

    public static void main(String[] args) throws Exception {
        List<ProductKey> pkKeys = License.getSWProductKeyList("10.133.176.61", "ADMIN", "ADMIN");
        for (int i = 0; i < pkKeys.size(); ++i) {
            ProductKey pk = pkKeys.get(i);
            System.out.println(pk.getSWName());
            System.out.println(pk.getExpirationDate());
            System.out.println(pk.getKeyCreationDate());
            System.out.println(new String(pk.getByteArray()));
            System.out.println(ByteUtility.bytesToHex(pk.getByteArray()));
        }
    }
}

