/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.kvm.authentication;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.kvm.authentication.KVMInterfaceMode;
import com.supermicro.ipmi.kvm.authentication.KVMUser;
import com.supermicro.ipmi.kvm.authentication.TLSConnection;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import com.supermicro.redfish.BasicAuthClient;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.ClientProtocolException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class KVMSessionConnection {
    private HttpURLConnection conn;
    private String bmcIP;
    private String username;
    private String password;
    private final String USER_AGENT = "Mozilla/5.0";
    private boolean checkBlowFish = false;
    private boolean isDebug = false;
    private boolean isWarning = true;
    private String html5CMM = null;
    private String httpPort = "80";
    private String httpsPort = "443";
    private String warningMessage = "";

    public KVMSessionConnection(String bmcIP, String username, String password) {
        this.bmcIP = bmcIP;
        this.username = username;
        this.password = password;
        ConfigAccessor ca = new ConfigAccessor(".", "ikvm.properties");
        if (ca.getProperty("http_port") == null) {
            ca.setProperty("http_port", "80");
            this.httpPort = "80";
        } else {
            this.httpPort = ca.getProperty("http_port");
        }
        if (ca.getProperty("https_port") == null) {
            ca.setProperty("https_port", "443");
            this.httpsPort = "443";
        } else {
            this.httpsPort = ca.getProperty("https_port");
        }
    }

    public KVMSessionConnection(String bmcIP, String username, String password, boolean checkBlowFish) {
        this.bmcIP = bmcIP;
        this.username = username;
        this.password = password;
        this.checkBlowFish = checkBlowFish;
    }

    @Deprecated
    public boolean isJavaPlugIn(String bmcIP, String username, String password) {
        boolean isIPv6 = StunnelUtility.isIPv6(bmcIP);
        String root = "https://" + bmcIP;
        if (isIPv6) {
            root = "https://[" + bmcIP + "]";
        }
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(bmcIP.trim());
        config.setUserName(username.trim());
        config.setPassword(password.trim());
        try {
            String manager = "/redfish/v1/Managers/1";
            BasicAuthClient bc = new BasicAuthClient(config);
            int managerResult = bc.send_https_get(root + manager);
            if (managerResult < 200 || managerResult > 210) {
                if (this.isDebug) {
                    System.out.println(managerResult);
                }
                System.out.println("Get Managers API fail");
                return true;
            }
            if (this.isDebug) {
                System.out.println("Send " + root + manager);
            }
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode oem = node.path("Oem");
            JsonNode supermicro = oem.path("Supermicro");
            JsonNode ikvm = supermicro.path("IKVM");
            JsonNode ikvmOdataId = ikvm.path("@odata.id");
            if (this.isDebug) {
                System.out.println(oem.toString());
            }
            if (ikvmOdataId.textValue() == null) {
                return true;
            }
            bc = new BasicAuthClient(config);
            if (this.isDebug) {
                System.out.println("Send " + root + ikvmOdataId.textValue());
            }
            int KVMResult = bc.send_https_get(root + ikvmOdataId.textValue());
            node = mapper.readTree(bc.getResponseString());
            if (KVMResult < 200 || KVMResult > 210) {
                JsonNode error;
                if (this.isDebug) {
                    System.out.println(KVMResult);
                }
                if ((error = node.path("error")) != null) {
                    String warningMessage = "";
                    String warningMessageArgs = "";
                    JsonNode messageExtendedInfo = error.path("@Message.ExtendedInfo");
                    if (messageExtendedInfo != null) {
                        if (messageExtendedInfo.isArray()) {
                            for (JsonNode l : messageExtendedInfo) {
                                JsonNode messageArgs;
                                JsonNode message = l.path("Message");
                                if (message != null) {
                                    warningMessage = message.toString();
                                }
                                if ((messageArgs = l.path("MessageArgs")) == null) continue;
                                warningMessageArgs = messageArgs.toString();
                            }
                            this.warningMessage = warningMessage + " " + warningMessageArgs;
                        } else {
                            JsonNode message = messageExtendedInfo.path("Message");
                            if (message != null) {
                                this.warningMessage = warningMessage;
                                if (this.isWarning) {
                                    System.out.println(message.toString());
                                }
                            }
                        }
                    }
                }
                return true;
            }
            JsonNode odataType = node.path("@odata.type");
            if (this.isDebug) {
                System.out.println(odataType);
            }
            if (odataType != null && odataType.textValue() != null && odataType.textValue().indexOf("v1_0_1") > -1) {
                JsonNode currentInterface = node.path("Current interface");
                if (this.isDebug) {
                    System.out.println(currentInterface);
                }
                if (currentInterface.textValue().indexOf("HTML 5") > -1) {
                    if (this.isWarning) {
                        System.out.println("KVM Current interface is HTML 5, switching to JAVA plug-in...");
                    }
                    String url = root + ikvmOdataId.textValue();
                    String body = "{\"Current interface\":\"JAVA plug-in\"}";
                    int result = 0;
                    try {
                        result = bc.send_https_patch(url, body);
                    }
                    catch (ClientProtocolException e) {
                        if (this.isWarning) {
                            System.out.println("This device does not support switching KVM interface via redfish.");
                        }
                        return false;
                    }
                    if (result >= 200 && result <= 210) {
                        return true;
                    }
                    if (this.isWarning) {
                        System.out.println("Switching to JAVA plug-in fail, please close HTML 5 KVM connection before running the command.");
                    }
                    return false;
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public KVMUser getLoginUser() throws Exception {
        return this.getLoginUser(false);
    }

    public KVMUser getLoginUser(boolean isSaveJnlp) throws Exception {
        return this.getLoginUser(isSaveJnlp, null);
    }

    public KVMUser getLoginUser(String jnlpPath) throws Exception {
        return this.getLoginUser(false, jnlpPath);
    }

    public KVMUser getLoginUser(boolean isSaveJnlp, String jnlpPath) throws Exception {
        boolean isIPv6 = StunnelUtility.isIPv6(this.bmcIP);
        String root = "https://" + this.bmcIP;
        if (isIPv6) {
            root = "https://[" + this.bmcIP + "]";
        }
        if (!"443".equalsIgnoreCase(this.httpsPort)) {
            root = root + ":" + this.httpsPort;
        }
        boolean isHttps = true;
        int retry = 0;
        while (true) {
            isHttps = root.contains("https");
            String url = root + "/cgi/login.cgi";
            String jnlpHTM = root + "/cgi/url_redirect.cgi?url_name=ikvm&url_type=jwsk";
            jnlpHTM = jnlpPath != null ? root + jnlpPath : root + "/cgi/url_redirect.cgi?url_name=ikvm&url_type=jwsk";
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            TLSConnection.build();
            String postParams = "name=" + this.username + "&pwd=" + this.password;
            this.sendPost(url, postParams, isHttps);
            try {
                this.switchKVMInterfaceViaCGI(root, isHttps, KVMInterfaceMode.JavaPlugIn);
            }
            catch (ConnectException ce) {
                if (this.isWarning) {
                    System.out.println(ce.getMessage());
                }
            }
            catch (Exception ce) {
                // empty catch block
            }
            String jnlp = "";
            try {
                jnlp = this.GetPageContent(jnlpHTM, isHttps);
                if (this.isDebug()) {
                    System.out.println(jnlp);
                }
                if (isSaveJnlp) {
                    PrintWriter writer = new PrintWriter(KVMSessionConnection.getTmpDir() + "launch" + this.bmcIP + ".jnlp", "UTF-8");
                    writer.write(jnlp);
                    writer.close();
                }
                return this.getLoginValue(jnlp);
            }
            catch (FileNotFoundException e) {
                System.out.println("The KVM interface should be JAVA plug-in for this operation");
                ++retry;
                root = "http://" + this.bmcIP;
                if (isIPv6) {
                    root = "http://[" + this.bmcIP + "]";
                }
                if ("80".equalsIgnoreCase(this.httpPort)) continue;
                root = root + ":" + this.httpPort;
                if (retry < 2) continue;
                return null;
            }
            break;
        }
    }

    private void sendPost(String url, String postParams, boolean isHttps) throws Exception {
        String inputLine;
        URL obj = new URL(url);
        this.conn = isHttps ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        this.conn.setRequestProperty("Connection", "keep-alive");
        this.conn.setRequestProperty("Referer", url);
        this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.conn.setRequestProperty("Content-Length", Integer.toString(postParams.length()));
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(this.conn.getOutputStream());
        wr.writeBytes(postParams);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
    }

    private String sendPost(String url, String postParams, boolean isHttps, String CSRF) throws Exception {
        String inputLine;
        if (this.isDebug) {
            System.out.println(url);
        }
        if (this.isDebug) {
            System.out.println(postParams + "\n");
        }
        URL obj = new URL(url);
        this.conn = isHttps ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        this.conn.setRequestProperty("Connection", "keep-alive");
        this.conn.setRequestProperty("Referer", url);
        this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.conn.setRequestProperty("Content-Length", Integer.toString(postParams.length()));
        this.conn.setRequestProperty("CSRF_TOKEN", CSRF);
        this.conn.setDoOutput(true);
        this.conn.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(this.conn.getOutputStream());
        wr.writeBytes(postParams);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    public boolean switchKVMInterface(int mode) {
        boolean isIPv6 = StunnelUtility.isIPv6(this.bmcIP);
        String root = "https://" + this.bmcIP;
        if (isIPv6) {
            root = "https://[" + this.bmcIP + "]";
        }
        if (!"443".equalsIgnoreCase(this.httpsPort)) {
            root = root + ":" + this.httpsPort;
        }
        boolean isHttps = true;
        String url = root + "/cgi/login.cgi";
        int retry = 0;
        do {
            isHttps = root.contains("https");
            url = root + "/cgi/login.cgi";
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            try {
                TLSConnection.build();
                String postParams = "name=" + this.username + "&pwd=" + this.password;
                this.sendPost(url, postParams, isHttps);
                if (this.isDebug) {
                    System.out.println("sendPost done");
                }
                try {
                    boolean isGetToken = this.switchKVMInterfaceViaCGI(root, isHttps, KVMInterfaceMode.getModeNameValue(mode));
                    if (this.isDebug) {
                        System.out.println("isGetToken " + isGetToken);
                    }
                    if (isGetToken) {
                        return true;
                    }
                }
                catch (ConnectException ce) {
                    if (this.isWarning) {
                        System.out.println(ce.getMessage());
                    }
                    return false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                root = "http://" + this.bmcIP;
                if (isIPv6) {
                    root = "http://[" + this.bmcIP + "]";
                }
                if ("80".equalsIgnoreCase(this.httpPort)) continue;
                root = root + ":" + this.httpPort;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } while (++retry < 2);
        return true;
    }

    boolean switchKVMInterfaceViaCGI(String root, boolean isHttps, KVMInterfaceMode kvmInterfaceMode) throws Exception {
        int endIndex;
        String ikvmStatusURL;
        boolean isGetToken = false;
        String redirectURL = root + "/cgi/url_redirect.cgi?url_name=topmenu";
        String page = this.GetPageContent(redirectURL, isHttps);
        String token = "";
        if (this.isDebug) {
            System.out.println("redirectURL " + redirectURL);
        }
        if (page.indexOf("SmcCsrfInsert") != -1 && (page = page.substring(page.indexOf("SmcCsrfInsert"))).indexOf("CSRF_TOKEN") != -1) {
            page = page.substring(page.indexOf("CSRF_TOKEN") + "CSRF_TOKEN".length() + 1);
            int startIndex = page.indexOf("\"") + 1;
            int endIndex2 = page.indexOf("\"", page.indexOf("\"") + 1);
            token = page.substring(startIndex, endIndex2);
        }
        if (this.isDebug) {
            System.out.println("token " + token);
        }
        if ("".equals(token.trim())) {
            throw new Exception("Can't get valid token");
        }
        isGetToken = true;
        String kvmInterface = "";
        String ikvmStatus = "";
        String postParams = "";
        try {
            int startIndex;
            ikvmStatusURL = root + "/cgi/xml_dispatcher.cgi";
            postParams = "op=GET_IKVM_STATUS.XML&r=(0,0)";
            ikvmStatus = this.sendPost(ikvmStatusURL, postParams, isHttps, token);
            if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                startIndex = ikvmStatus.indexOf("\"") + 1;
                endIndex = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                ikvmStatus = ikvmStatus.substring(startIndex, endIndex);
            }
            if ((kvmInterface = this.sendPost(ikvmStatusURL, postParams = "op=GET_IKVM_INTERFACE.XML&r=(0,0)", isHttps, token)).indexOf("ikvm_interface") > -1) {
                kvmInterface = kvmInterface.substring(kvmInterface.indexOf("ikvm_interface"));
                startIndex = kvmInterface.indexOf("\"") + 1;
                endIndex = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                kvmInterface = kvmInterface.substring(startIndex, endIndex);
            }
        }
        catch (Exception e) {
            try {
                int endIndex3;
                int startIndex;
                String ikvmStatusURL2 = root + "/cgi/ipmi.cgi";
                postParams = "op=GET_IKVM_STATUS.XML&r=(0,0)";
                ikvmStatus = this.sendPost(ikvmStatusURL2, postParams, isHttps, token);
                if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                    ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                    startIndex = ikvmStatus.indexOf("\"") + 1;
                    endIndex3 = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                    ikvmStatus = ikvmStatus.substring(startIndex, endIndex3);
                }
                if ((kvmInterface = this.sendPost(ikvmStatusURL2, postParams = "op=GET_IKVM_INTERFACE.XML&r=(0,0)", isHttps, token)).indexOf("ikvm_interface") > -1) {
                    kvmInterface = kvmInterface.substring(kvmInterface.indexOf("ikvm_interface"));
                    startIndex = kvmInterface.indexOf("\"") + 1;
                    endIndex3 = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                    kvmInterface = kvmInterface.substring(startIndex, endIndex3);
                }
            }
            catch (Exception ikvmStatusURL2) {
                // empty catch block
            }
        }
        if (!"".equals(kvmInterface) && !StringUtils.isNumeric((CharSequence)kvmInterface)) {
            try {
                ikvmStatusURL = root + "/cgi/ipmi.cgi";
                postParams = "GET_IKVM_STATUS.XML=(0,0)";
                kvmInterface = ikvmStatus = this.sendPost(ikvmStatusURL, postParams, isHttps, token);
                if (this.isDebug) {
                    System.out.println(ikvmStatus);
                }
                if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                    ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                    int startIndex = ikvmStatus.indexOf("\"") + 1;
                    endIndex = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                    ikvmStatus = ikvmStatus.substring(startIndex, endIndex);
                }
                if (kvmInterface.indexOf("IKVMINTERFACE") > -1) {
                    kvmInterface = kvmInterface.substring(kvmInterface.indexOf("IKVMINTERFACE"));
                    int startIndex = kvmInterface.indexOf("\"") + 1;
                    endIndex = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                    kvmInterface = kvmInterface.substring(startIndex, endIndex);
                }
            }
            catch (Exception ikvmStatusURL3) {
                // empty catch block
            }
        }
        if (this.isDebug) {
            System.out.println("ikvmStatus " + ikvmStatus);
            System.out.println("kvmInterface " + kvmInterface);
        }
        if (!"".equals(kvmInterface) && StringUtils.isNumeric((CharSequence)kvmInterface)) {
            if (!(kvmInterfaceMode.getValue() + "").equals(kvmInterface)) {
                String postRemoteConsoleUrl;
                String result;
                if (StringUtils.isNumeric((CharSequence)ikvmStatus) && Integer.parseInt(ikvmStatus) > 0) {
                    throw new ConnectException("Once a remote console session is connected, switching between JAVA and HTML5 is not allowed.");
                }
                if (this.isWarning) {
                    System.out.println("KVM Current interface is " + (Object)((Object)KVMInterfaceMode.getModeNameValue((kvmInterfaceMode.getValue() + 1) % 2)) + ", switching to " + (Object)((Object)kvmInterfaceMode) + "...");
                }
                if (!"ok".equals((result = this.sendPost(postRemoteConsoleUrl = root + "/cgi/op.cgi", postParams = "op=remote_console&ikvm_setting=" + kvmInterfaceMode.getValue(), isHttps, token)).trim())) {
                    throw new ConnectException("Switching to " + (Object)((Object)kvmInterfaceMode) + " fail, please close KVM session before running the command.");
                }
                if (this.isDebug) {
                    System.out.println(result);
                }
            }
        } else if (!isGetToken) {
            throw new Exception("No need to switch the KVM interface, you can ignore this warning message if you run the command for X10 platforms.");
        }
        return isGetToken;
    }

    public int getKVMInterface() {
        boolean isIPv6 = StunnelUtility.isIPv6(this.bmcIP);
        String root = "https://" + this.bmcIP;
        if (isIPv6) {
            root = "https://[" + this.bmcIP + "]";
        }
        if (!"443".equalsIgnoreCase(this.httpsPort)) {
            root = root + ":" + this.httpsPort;
        }
        boolean isHttps = true;
        String url = root + "/cgi/login.cgi";
        int retry = 0;
        do {
            isHttps = root.contains("https");
            url = root + "/cgi/login.cgi";
            CookieHandler.setDefault(new CookieManager(null, CookiePolicy.ACCEPT_ALL));
            try {
                TLSConnection.build();
                String postParams = "name=" + this.username + "&pwd=" + this.password;
                this.sendPost(url, postParams, isHttps);
                if (this.isDebug) {
                    System.out.println("sendPost done");
                }
                try {
                    int kvminterface = this.getKVMInterfaceViaCGI(root, isHttps);
                    if (kvminterface == 0 || kvminterface == 1) {
                        return kvminterface;
                    }
                }
                catch (ConnectException ce) {
                    return -1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                root = "http://" + this.bmcIP;
                if (isIPv6) {
                    root = "http://[" + this.bmcIP + "]";
                }
                if ("80".equalsIgnoreCase(this.httpPort)) continue;
                root = root + ":" + this.httpPort;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } while (++retry < 2);
        return -1;
    }

    int getKVMInterfaceViaCGI(String root, boolean isHttps) throws Exception {
        int endIndex;
        String ikvmStatusURL;
        int kvmInterfaceStatus = -1;
        String redirectURL = root + "/cgi/url_redirect.cgi?url_name=topmenu";
        String page = this.GetPageContent(redirectURL, isHttps);
        String token = "";
        if (this.isDebug) {
            System.out.println("redirectURL " + redirectURL);
        }
        if (page.indexOf("SmcCsrfInsert") != -1 && (page = page.substring(page.indexOf("SmcCsrfInsert"))).indexOf("CSRF_TOKEN") != -1) {
            page = page.substring(page.indexOf("CSRF_TOKEN") + "CSRF_TOKEN".length() + 1);
            int startIndex = page.indexOf("\"") + 1;
            int endIndex2 = page.indexOf("\"", page.indexOf("\"") + 1);
            token = page.substring(startIndex, endIndex2);
        }
        if (this.isDebug) {
            System.out.println("token " + token);
        }
        if ("".equals(token.trim())) {
            throw new Exception("Can't get valid token");
        }
        kvmInterfaceStatus = 99;
        String kvmInterface = "";
        String ikvmStatus = "";
        String postParams = "";
        try {
            int startIndex;
            ikvmStatusURL = root + "/cgi/xml_dispatcher.cgi";
            postParams = "op=GET_IKVM_STATUS.XML&r=(0,0)";
            ikvmStatus = this.sendPost(ikvmStatusURL, postParams, isHttps, token);
            if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                startIndex = ikvmStatus.indexOf("\"") + 1;
                endIndex = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                ikvmStatus = ikvmStatus.substring(startIndex, endIndex);
            }
            if ((kvmInterface = this.sendPost(ikvmStatusURL, postParams = "op=GET_IKVM_INTERFACE.XML&r=(0,0)", isHttps, token)).indexOf("ikvm_interface") > -1) {
                kvmInterface = kvmInterface.substring(kvmInterface.indexOf("ikvm_interface"));
                startIndex = kvmInterface.indexOf("\"") + 1;
                endIndex = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                kvmInterface = kvmInterface.substring(startIndex, endIndex);
            }
        }
        catch (Exception e) {
            try {
                int endIndex3;
                int startIndex;
                String ikvmStatusURL2 = root + "/cgi/ipmi.cgi";
                postParams = "op=GET_IKVM_STATUS.XML&r=(0,0)";
                ikvmStatus = this.sendPost(ikvmStatusURL2, postParams, isHttps, token);
                if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                    ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                    startIndex = ikvmStatus.indexOf("\"") + 1;
                    endIndex3 = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                    ikvmStatus = ikvmStatus.substring(startIndex, endIndex3);
                }
                if ((kvmInterface = this.sendPost(ikvmStatusURL2, postParams = "op=GET_IKVM_INTERFACE.XML&r=(0,0)", isHttps, token)).indexOf("ikvm_interface") > -1) {
                    kvmInterface = kvmInterface.substring(kvmInterface.indexOf("ikvm_interface"));
                    startIndex = kvmInterface.indexOf("\"") + 1;
                    endIndex3 = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                    kvmInterface = kvmInterface.substring(startIndex, endIndex3);
                }
            }
            catch (Exception ikvmStatusURL2) {
                // empty catch block
            }
        }
        if (!"".equals(kvmInterface) && !StringUtils.isNumeric((CharSequence)kvmInterface)) {
            try {
                ikvmStatusURL = root + "/cgi/ipmi.cgi";
                postParams = "GET_IKVM_STATUS.XML=(0,0)";
                kvmInterface = ikvmStatus = this.sendPost(ikvmStatusURL, postParams, isHttps, token);
                if (this.isDebug) {
                    System.out.println(ikvmStatus);
                }
                if (ikvmStatus.indexOf("WEBIKVMSTATUS") > -1) {
                    ikvmStatus = ikvmStatus.substring(ikvmStatus.indexOf("WEBIKVMSTATUS"));
                    int startIndex = ikvmStatus.indexOf("\"") + 1;
                    endIndex = ikvmStatus.indexOf("\"", ikvmStatus.indexOf("\"") + 1);
                    ikvmStatus = ikvmStatus.substring(startIndex, endIndex);
                }
                if (kvmInterface.indexOf("IKVMINTERFACE") > -1) {
                    kvmInterface = kvmInterface.substring(kvmInterface.indexOf("IKVMINTERFACE"));
                    int startIndex = kvmInterface.indexOf("\"") + 1;
                    endIndex = kvmInterface.indexOf("\"", kvmInterface.indexOf("\"") + 1);
                    kvmInterface = kvmInterface.substring(startIndex, endIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isDebug) {
            System.out.println("ikvmStatus " + ikvmStatus);
            System.out.println("kvmInterface " + kvmInterface);
        }
        if (!"".equals(kvmInterface) && StringUtils.isNumeric((CharSequence)kvmInterface)) {
            kvmInterfaceStatus = Integer.parseInt(kvmInterface);
        }
        return kvmInterfaceStatus;
    }

    private String GetPageContent(String url, boolean isHttps) throws Exception {
        String inputLine;
        TLSConnection.build();
        URL obj = new URL(url);
        this.conn = isHttps ? (HttpsURLConnection)obj.openConnection() : (HttpURLConnection)obj.openConnection();
        this.conn.setRequestMethod("GET");
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        this.conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        this.conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        this.conn.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        this.conn.getRequestProperties();
        int responseCode = this.conn.getResponseCode();
        if (this.isDebug()) {
            System.out.println("\nSending 'GET' request to URL : " + url);
            System.out.println("headers fields are :" + this.conn.getHeaderFields());
            System.out.println("Response Code : " + responseCode);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(this.conn.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
            String newLine = System.getProperty("line.separator");
            if (newLine == null) {
                response.append("\n");
                continue;
            }
            response.append(newLine);
        }
        in.close();
        Map<String, List<String>> map = this.conn.getHeaderFields();
        return response.toString();
    }

    private KVMUser getLoginValue(String html) throws UnsupportedEncodingException {
        Document doc = Jsoup.parse((String)html);
        doc.outputSettings().prettyPrint(false);
        Elements sessionElement = doc.getElementsByTag("argument");
        int index = -1;
        KVMUser kvmUser = new KVMUser();
        int isaIP = -1;
        for (Element inputElement : sessionElement) {
            if (index >= 0) {
                ++index;
            }
            if ((isaIP = StunnelUtility.isaIP(inputElement.text().trim())) >= 0) {
                if (isaIP == 1) {
                    if (KVMSessionConnection.StandardIPv6Converter(inputElement.text().trim()).equalsIgnoreCase(KVMSessionConnection.StandardIPv6Converter(this.bmcIP))) {
                        index = 0;
                    }
                } else if (inputElement.text().trim().equals(this.bmcIP)) {
                    index = 0;
                }
            }
            if (index == 1) {
                kvmUser.setUsername(inputElement.text());
            } else if (index == 2) {
                kvmUser.setPassword(inputElement.text());
            } else if (index == 10 && this.checkBlowFish && "1".equals(inputElement.text())) {
                kvmUser.setBlowFish(true);
            }
            if (inputElement.text().indexOf("BEGIN CERTIFICATE") <= -1) continue;
            String certificate = inputElement.html();
            if (certificate.indexOf("-----END CERTIFICATE-----") > 0) {
                int endCertificate = certificate.indexOf("-----END CERTIFICATE-----") + "-----END CERTIFICATE-----".length();
                certificate = certificate.substring(0, endCertificate);
            }
            kvmUser.setServerCertificate(certificate);
        }
        if ("".equals(kvmUser.getUsername()) && "".equals(kvmUser.getPassword())) {
            HashMap<Integer, String> tempMap = new HashMap<Integer, String>();
            index = 0;
            for (Element inputElement : sessionElement) {
                String tempElement = inputElement.text();
                tempMap.put(index, tempElement);
                if ("5900".equals(tempElement) && ((String)tempMap.get(index - 7)).contains("=") & index - 8 > 0) {
                    kvmUser.setPassword((String)tempMap.get(index - 7));
                    kvmUser.setUsername((String)tempMap.get(index - 8));
                }
                ++index;
            }
        }
        return kvmUser;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public void setWarning(boolean isWarning) {
        this.isWarning = isWarning;
    }

    public static String getTmpDir() {
        String tempDIR = System.getProperty("java.io.tmpdir");
        if (!File.separator.equals(tempDIR.substring(tempDIR.length() - 1, tempDIR.length()))) {
            tempDIR = tempDIR + File.separator;
        }
        return tempDIR;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public static String StandardIPv6Converter(String address) {
        int i;
        int j;
        int tempCompressLocation = address.indexOf("::");
        int componentNumberPrePart = 0;
        if (tempCompressLocation != -1) {
            String prePart = address.substring(0, tempCompressLocation);
            componentNumberPrePart = prePart.split(":").length;
            address = address.replace("::", ":");
        }
        String[] addressComponents = address.toString().split(":");
        for (int i2 = 0; i2 < addressComponents.length; ++i2) {
            StringBuilder uncompressedComponent = new StringBuilder("");
            for (j = 0; j < 4 - addressComponents[i2].length(); ++j) {
                uncompressedComponent.append("0");
            }
            uncompressedComponent.append(addressComponents[i2]);
            addressComponents[i2] = uncompressedComponent.toString();
        }
        LinkedList<String> uncompressedAddressComponents = new LinkedList<String>();
        for (i = 0; i < addressComponents.length; ++i) {
            if (i == componentNumberPrePart) {
                for (j = 0; j < 8 - addressComponents.length; ++j) {
                    uncompressedAddressComponents.add("0000");
                }
            }
            uncompressedAddressComponents.add(addressComponents[i]);
        }
        if (uncompressedAddressComponents.size() < 8) {
            for (i = uncompressedAddressComponents.size(); i < 8; ++i) {
                uncompressedAddressComponents.add("0000");
            }
        }
        StringBuilder uncompressedAddress = new StringBuilder("");
        for (int i3 = 0; i3 < uncompressedAddressComponents.size(); ++i3) {
            uncompressedAddress.append((String)uncompressedAddressComponents.get(i3));
            uncompressedAddress.append(":");
        }
        uncompressedAddress.replace(uncompressedAddress.length() - 1, uncompressedAddress.length(), "");
        return uncompressedAddress.toString();
    }

    public static void main(String[] args) throws Exception {
        KVMSessionConnection http = new KVMSessionConnection("10.147.160.2", "ADMIN", "ADMIN");
        http.setDebug(true);
        http.getLoginUser(true);
    }
}

