/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.ProxyConfig;
import com.supermicro.ipmi.text.MOut;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Observable;

public class UDPSocket
extends Observable {
    private String ip;
    private int port;
    private double timeout = 5.0;
    private int retry = 2;
    private int receiveLength = 2048;
    public DatagramSocket socket;
    InetAddress remoteAddress;
    InetAddress localAddress;
    DatagramPacket sendPacket;
    DatagramPacket receivePacket;
    int timeoutMillisecond;
    public byte[] result;
    public UDPDaemon udpDaemon;
    ProxyConfig proxyConfig;
    byte[] latestSeqFromBMC = new byte[4];

    public UDPSocket(String ip, int port, int timeout, int retry) throws UnknownHostException {
        this.ip = ip;
        this.port = port;
        this.timeout = timeout;
        this.timeoutMillisecond = timeout * 1000;
        this.retry = retry < 0 ? 0 : retry;
        this.remoteAddress = InetAddress.getByName(ip);
        try {
            this.localAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            boolean isIPv4 = true;
            try {
                this.localAddress = this.getFirstNonLoopbackAddress(isIPv4, !isIPv4);
            }
            catch (Exception e) {
                this.localAddress = InetAddress.getByName("127.0.0.1");
            }
        }
        try {
            this.socket = new DatagramSocket();
        }
        catch (BindException be) {
            throw new RuntimeException(be);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized boolean sendPacketEx(byte[] data) throws Exception {
        this.result = null;
        byte[] buffer = new byte[this.receiveLength];
        int remotePort = this.port;
        if (this.proxyConfig != null && this.proxyConfig.isProxyEnabled) {
            this.remoteAddress = InetAddress.getByName(this.proxyConfig.proxyIP);
            remotePort = this.proxyConfig.proxyPort;
        }
        this.sendPacket = new DatagramPacket(data, data.length, this.remoteAddress, remotePort);
        this.receivePacket = new DatagramPacket(buffer, buffer.length, this.localAddress, remotePort);
        do {
            this.socket.send(this.sendPacket);
            this.socket.setSoTimeout(this.timeoutMillisecond);
            try {
                this.socket.receive(this.receivePacket);
                if (this.isDuplicatePacketFromBMC(data, buffer)) {
                    throw new SocketTimeoutException();
                }
            }
            catch (SocketTimeoutException ste) {
                MessageCenter.getInstance().put(this, (Object)"retry");
                if (!GlobalDefine.OOB_PROJECT || GlobalDefine.OOB_PROJECT_TOOLD) continue;
                MOut.G().print(". .");
                continue;
            }
            this.result = new byte[this.receivePacket.getLength()];
            System.arraycopy(buffer, 0, this.result, 0, this.receivePacket.getLength());
            return true;
        } while (--this.retry > 0);
        return false;
    }

    public synchronized boolean sendPacket(byte[] data) {
        int currentRetry = this.retry;
        this.result = null;
        byte[] buffer = new byte[this.receiveLength];
        int remotePort = this.port;
        if (this.proxyConfig != null && this.proxyConfig.isProxyEnabled) {
            try {
                this.remoteAddress = InetAddress.getByName(this.proxyConfig.proxyIP);
                remotePort = this.proxyConfig.proxyPort;
            }
            catch (UnknownHostException ex3) {
                MessageCenter.getInstance().put(this, (Object)"Proxy IP error");
            }
        }
        this.sendPacket = new DatagramPacket(data, data.length, this.remoteAddress, remotePort);
        this.receivePacket = new DatagramPacket(buffer, buffer.length, this.localAddress, remotePort);
        do {
            try {
                this.socket.send(this.sendPacket);
            }
            catch (IOException ex) {
                return false;
            }
            try {
                this.socket.setSoTimeout(this.timeoutMillisecond);
            }
            catch (SocketException ex2) {
                return false;
            }
            try {
                this.socket.receive(this.receivePacket);
                if (this.isDuplicatePacketFromBMC(data, buffer)) {
                    throw new SocketTimeoutException();
                }
            }
            catch (SocketTimeoutException ste) {
                MessageCenter.getInstance().put(this, (Object)("Timeout(" + this.timeout + " sec). Retry =" + currentRetry));
                if (!GlobalDefine.OOB_PROJECT || GlobalDefine.OOB_PROJECT_TOOLD) continue;
                MOut.G().print(". .");
                continue;
            }
            catch (IOException ex1) {
                return false;
            }
            this.result = new byte[this.receivePacket.getLength()];
            System.arraycopy(buffer, 0, this.result, 0, this.receivePacket.getLength());
            return true;
        } while (currentRetry != 0 && --currentRetry >= 0);
        return false;
    }

    public synchronized boolean receivePacket() {
        this.result = null;
        byte[] buffer = new byte[this.receiveLength];
        int remotePort = this.port;
        if (this.proxyConfig != null && this.proxyConfig.isProxyEnabled) {
            try {
                this.remoteAddress = InetAddress.getByName(this.proxyConfig.proxyIP);
                remotePort = this.proxyConfig.proxyPort;
            }
            catch (UnknownHostException ex3) {
                MessageCenter.getInstance().put(this, (Object)"Proxy IP error");
            }
        }
        this.receivePacket = new DatagramPacket(buffer, buffer.length, this.localAddress, remotePort);
        try {
            this.socket.receive(this.receivePacket);
        }
        catch (IOException ex1) {
            return false;
        }
        this.result = new byte[this.receivePacket.getLength()];
        System.arraycopy(buffer, 0, this.result, 0, this.receivePacket.getLength());
        return true;
    }

    private boolean isDuplicatePacketFromBMC(byte[] command, byte[] response) {
        byte AuthType = command[4];
        byte[] seq = new byte[4];
        if (AuthType == 1 || AuthType == 2) {
            System.arraycopy(response, 5, seq, 0, 4);
        } else if (AuthType == 6) {
            System.arraycopy(response, 10, seq, 0, 4);
        } else {
            return false;
        }
        if ((seq[0] != 0 || seq[1] != 0 || seq[2] != 0 || seq[3] != 0) && seq[0] == this.latestSeqFromBMC[0] && seq[1] == this.latestSeqFromBMC[1] && seq[2] == this.latestSeqFromBMC[2] && seq[3] == this.latestSeqFromBMC[3]) {
            MessageCenter.getInstance().put(this, (Object)("Duplicate Packet from BMC. seq =" + ByteUtility.bytesToHex(seq)));
            return seq[0] > 4;
        }
        this.latestSeqFromBMC = seq;
        return false;
    }

    public synchronized boolean dropPacketEx(byte[] data) throws Exception {
        int remotePort = this.port;
        if (this.proxyConfig != null && this.proxyConfig.isProxyEnabled) {
            this.remoteAddress = InetAddress.getByName(this.proxyConfig.proxyIP);
            remotePort = this.proxyConfig.proxyPort;
        }
        this.sendPacket = new DatagramPacket(data, data.length, this.remoteAddress, remotePort);
        this.socket.send(this.sendPacket);
        return true;
    }

    public synchronized boolean dropPacket(byte[] data) {
        int remotePort = this.port;
        if (this.proxyConfig != null && this.proxyConfig.isProxyEnabled) {
            try {
                this.remoteAddress = InetAddress.getByName(this.proxyConfig.proxyIP);
                remotePort = this.proxyConfig.proxyPort;
            }
            catch (UnknownHostException ex3) {
                MessageCenter.getInstance().put(this, (Object)"Proxy IP error");
            }
        }
        this.sendPacket = new DatagramPacket(data, data.length, this.remoteAddress, remotePort);
        try {
            this.socket.send(this.sendPacket);
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public void startListenEx() throws Exception {
        this.udpDaemon = new UDPDaemon(this);
        this.udpDaemon.start();
    }

    public void startListen() {
        this.udpDaemon = new UDPDaemon(this);
        this.udpDaemon.start();
    }

    public void startListenEx(int port) throws Exception {
        this.socket = new DatagramSocket(port);
        this.udpDaemon = new UDPDaemon(this);
        this.udpDaemon.start();
    }

    public boolean startListen(int port) {
        try {
            this.socket = new DatagramSocket(port);
        }
        catch (SocketException ex) {
            return false;
        }
        this.udpDaemon = new UDPDaemon(this);
        this.udpDaemon.start();
        return true;
    }

    public void stopListenEx() throws Exception {
        int localPort = this.socket.getLocalPort();
        byte[] b = new byte[]{0};
        this.sendPacket = new DatagramPacket(b, b.length, this.localAddress, localPort);
        this.socket.send(this.sendPacket);
    }

    public void stopListen() {
        int localPort = this.socket.getLocalPort();
        byte[] b = new byte[]{0};
        this.sendPacket = new DatagramPacket(b, b.length, this.localAddress, localPort);
        try {
            this.socket.send(this.sendPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setTimeout(double timeout) {
        this.timeout = timeout;
        this.timeoutMillisecond = (int)(timeout * 1000.0);
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public double getTimeout() {
        return this.timeout;
    }

    public int getRetry() {
        return this.retry;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void closeSocket() {
        this.socket.disconnect();
        this.socket.close();
    }

    public static void main(String[] args) throws Exception {
        UDPSocket udpSocket = new UDPSocket("localhost", 7777, 3, 3);
        udpSocket.dropPacket(new String("1,192.168.10.246,623").getBytes());
        udpSocket.dropPacket(new String("asdfasfasdfasdfasf").getBytes());
        udpSocket.dropPacket(new String("0").getBytes());
        udpSocket = new UDPSocket("203.204.140.16", 2211, 3, 3);
        udpSocket.dropPacket(new String("1,192.168.10.246,623").getBytes());
    }

    public InetAddress getFirstNonLoopbackAddress(boolean preferIpv4, boolean preferIPv6) throws Exception {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress()) continue;
                if (addr instanceof Inet4Address) {
                    if (preferIPv6) continue;
                    return addr;
                }
                if (!(addr instanceof Inet6Address) || preferIpv4) continue;
                return addr;
            }
        }
        return InetAddress.getByName("127.0.0.1");
    }

    class UDPDaemon
    extends Thread {
        UDPSocket udpSocket;
        DatagramPacket receivePacket = null;

        public UDPDaemon(UDPSocket udpSocket) {
            this.udpSocket = udpSocket;
        }

        @Override
        public void run() {
            byte[] buffer = new byte[2048];
            this.receivePacket = new DatagramPacket(buffer, buffer.length);
            while (!this.isInterrupted()) {
                try {
                    this.udpSocket.socket.setSoTimeout(0);
                    this.udpSocket.socket.receive(this.receivePacket);
                }
                catch (SocketTimeoutException ste) {
                    MessageCenter.getInstance().put(this, (Object)"TimeOut");
                    continue;
                }
                catch (IOException ex1) {
                    MessageCenter.getInstance().put(this, (Object)"Network error");
                    continue;
                }
                byte[] result = new byte[this.receivePacket.getLength()];
                System.arraycopy(buffer, 0, result, 0, this.receivePacket.getLength());
                if (result.length == 1 && result[0] == 0) {
                    MessageCenter.getInstance().put(this, (Object)"Receive Stop command");
                    break;
                }
                this.udpSocket.setChanged();
                try {
                    this.udpSocket.notifyObservers(result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    this.udpSocket.socket.setSoTimeout(this.udpSocket.timeoutMillisecond);
                }
                catch (SocketException socketException) {}
            }
        }
    }
}

