/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.MCUUpdateInterface;

class MCUA7Update
extends MCUUpdateInterface {
    MCUA7Update() {
    }

    @Override
    boolean validatePrerequisites() {
        try {
            if (this.ipmiTwinProComm.getNodeID() != 1) {
                this.mout.println("The operation node must be A node.");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    boolean verifyFileFormat() {
        int position = this.indexOf(this.mcuFirmware, this.ver);
        if (position == -1) {
            this.mout.println("Can't get MUC ID from the file");
            return false;
        }
        String newFW = ByteUtility.byteToHex(this.mcuFirmware[position + 7]).trim();
        byte readCount = 1;
        byte[] dataToWrite = new byte[]{-3};
        String mcuID = "";
        try {
            mcuID = ByteUtility.bytesToHex(this.ipmiTwinProComm.sendTwinPro80hCommand(readCount, dataToWrite)).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (!mcuID.equals(newFW)) {
            this.mout.println("MCU ID is not matched.");
            return false;
        }
        return true;
    }
}

