/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.vstorage;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMPortServiceCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.kvm.authentication.KVMSessionConnection;
import com.supermicro.ipmi.kvm.authentication.KVMUser;
import com.supermicro.ipmi.stunnel.StunnelParameterBuilder;
import com.supermicro.ipmi.stunnel.StunnelParameters;
import com.supermicro.ipmi.stunnel.StunnelUtility;
import java.util.HashMap;
import java.util.Map;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.vstorage.VirtualStorage;

public class VirtualStorageManager {
    private static VirtualStorageManager instance = new VirtualStorageManager();
    HashMap<String, VirtualStorage> virtualStorages = new HashMap();
    public static Map<String, String> mountedStunnelFolderMap = new HashMap<String, String>();

    private VirtualStorageManager() {
    }

    public static VirtualStorageManager getInstance() {
        return instance;
    }

    public VirtualStorage createVirtualStorage(IPMIInterfaceConfig config) {
        return this.createVirtualStorage(config, false);
    }

    public VirtualStorage createVirtualStorage(IPMIInterfaceConfig config, boolean isForceStunnelVer11) {
        block19: {
            ISessionController sessionController = IPMIVersion.getSessionController(config);
            IPMINetworkInterface ipmiInterface = sessionController.startup(config);
            IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand = new IPMIOEMPortServiceCommand(null);
            ipmiOEMPortServiceCommand.setIPMIInterface(ipmiInterface);
            int stunnelVer = 0;
            String username = config.getUserName();
            String password = config.getPassword();
            try {
                stunnelVer = ipmiOEMPortServiceCommand.checkStunenelVer();
                if (isForceStunnelVer11) {
                    stunnelVer = 11;
                } else if (stunnelVer == 13) {
                    stunnelVer = 11;
                }
                if (stunnelVer >= 9) {
                    StunnelParameters parameters = null;
                    try {
                        parameters = this.setupStunnel(ipmiOEMPortServiceCommand, config, stunnelVer);
                        mountedStunnelFolderMap.put(config.getIp(), parameters.getStunnelFolder());
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        return null;
                    }
                    VirtualStorage.loadLibrary(stunnelVer);
                    if (stunnelVer > 9) {
                        username = parameters.getUser().getUsername();
                        password = parameters.getUser().getPassword();
                    }
                    InfoRepository infoRepository = InfoRepository.createInfoRepository(parameters.getStunnelIP(), username, password, parameters.getSturnnlPortList().get(0));
                    VirtualStorage vs = new VirtualStorage(infoRepository);
                    this.virtualStorages.put(config.getIp(), vs);
                    return vs;
                }
                if (stunnelVer == 5) {
                    StunnelParameters parameters = null;
                    try {
                        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(config.getIp());
                        parameters = StunnelParameterBuilder.run(stunnelVer, config.getIp(), ipmiOEMPortServiceCommand, guid, config.getUserName(), config.getPassword());
                        StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
                        if (!StunnelUtility.preCheck(parameters, config, stunnelVer)) {
                            StunnelUtility.showProgress = true;
                            StunnelUtility.stopStunnel(parameters.getStunnelFolder());
                            stunnelVer = 11;
                            KVMSessionConnection connection = new KVMSessionConnection(config.getIp(), config.getUserName(), config.getPassword());
                            try {
                                KVMUser user = connection.getLoginUser();
                                if (user == null) {
                                    System.out.println("Could not establish KVM connction");
                                } else {
                                    username = user.getUsername();
                                    password = user.getPassword();
                                }
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                            try {
                                parameters = this.setupStunnel(ipmiOEMPortServiceCommand, config, stunnelVer);
                                mountedStunnelFolderMap.put(config.getIp(), parameters.getStunnelFolder());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            VirtualStorage.loadLibrary(stunnelVer);
                            InfoRepository infoRepository = InfoRepository.createInfoRepository(parameters.getStunnelIP(), username, password, parameters.getSturnnlPortList().get(0));
                            VirtualStorage vs = new VirtualStorage(infoRepository);
                            this.virtualStorages.put(config.getIp(), vs);
                            StunnelUtility.showProgress = false;
                            return vs;
                        }
                        StunnelUtility.stopStunnel(parameters.getStunnelFolder());
                        VirtualStorage.loadLibrary();
                        InfoRepository infoRepository = InfoRepository.createInfoRepository(config.getIp(), config.getUserName(), config.getPassword());
                        VirtualStorage vs = new VirtualStorage(infoRepository);
                        this.virtualStorages.put(config.getIp(), vs);
                        return vs;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block19;
                    }
                }
                VirtualStorage.loadLibrary();
                InfoRepository infoRepository = InfoRepository.createInfoRepository(config.getIp(), config.getUserName(), config.getPassword());
                VirtualStorage vs = new VirtualStorage(infoRepository);
                this.virtualStorages.put(config.getIp(), vs);
                return vs;
            }
            catch (IPMIException e) {
                e.printStackTrace();
            }
        }
        VirtualStorage.loadLibrary();
        InfoRepository infoRepository = InfoRepository.createInfoRepository(config.getIp(), config.getUserName(), config.getPassword());
        VirtualStorage vs = new VirtualStorage(infoRepository);
        this.virtualStorages.put(config.getIp(), vs);
        return vs;
    }

    public StunnelParameters setupStunnel(IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, IPMIInterfaceConfig config, int stunnelVer) throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(config.getIp());
        StunnelParameters parameters = StunnelParameterBuilder.runByFunction(stunnelVer, config.getIp(), config.getUserName(), config.getPassword(), ipmiOEMPortServiceCommand, guid, "VirtualMedia");
        try {
            StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parameters;
    }

    public StunnelParameters setupStunnel2Ports(IPMIOEMPortServiceCommand ipmiOEMPortServiceCommand, IPMIInterfaceConfig config, int stunnelVer) throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(config.getIp());
        StunnelParameters parameters = StunnelParameterBuilder.runByFunction(stunnelVer, config.getIp(), config.getUserName(), config.getPassword(), ipmiOEMPortServiceCommand, guid, "iKVM", "VirtualMedia");
        try {
            StunnelUtility.configAndStartStunnel(parameters, ipmiOEMPortServiceCommand.getIPMIInterface(), parameters.getCAMode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parameters;
    }

    public VirtualStorage getVirtualStorage(IPMIInterfaceConfig config) {
        VirtualStorage vs = this.virtualStorages.get(config.getIp());
        if (vs == null) {
            vs = this.createVirtualStorage(config);
        }
        return vs;
    }

    public boolean isVirtualStorageExist(IPMIInterfaceConfig config) {
        VirtualStorage vs = this.virtualStorages.get(config.getIp());
        return vs != null;
    }

    public String getStatus(IPMIInterfaceConfig config) {
        return this.getMountStatus(config);
    }

    public VirtualStorage getVirtualStorage(IPMIInterfaceConfig config, boolean isForceStunnelVer11) {
        VirtualStorage vs = this.virtualStorages.get(config.getIp());
        if (vs == null) {
            vs = this.createVirtualStorage(config, isForceStunnelVer11);
        }
        return vs;
    }

    public String getMountStatus() {
        StringBuffer sb = new StringBuffer();
        if (this.virtualStorages.keySet().size() == 0) {
            return "None";
        }
        for (String item : this.virtualStorages.keySet()) {
            VirtualStorage vs = this.virtualStorages.get(item);
            sb.append("[" + item.toString() + "]:\n");
            sb.append(vs.mountStatus());
        }
        return sb.toString();
    }

    public String getMountStatus(IPMIInterfaceConfig config) {
        return this.getMountStatus(config, false);
    }

    /*
     * Exception decompiling
     */
    public String getMountStatus(IPMIInterfaceConfig config, boolean isForceStunnelVer11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

