/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class RadiusCommand
extends RedfishCommand {
    boolean status;

    @Override
    public boolean preValidate() {
        int tempPort;
        if (this.parameters == null) {
            return true;
        }
        if (this.parameters.length != 4) {
            this.printUsage();
            return false;
        }
        try {
            byte authentication = Byte.parseByte(this.parameters[0]);
            if (authentication != 0 && authentication != 1) {
                MOut.G(this).println("authentication should be 0 or 1");
                return false;
            }
            this.status = authentication == 1;
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("authentication should be 0 or 1");
            this.printUsage();
            return false;
        }
        try {
            tempPort = Integer.parseInt(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("port should be number");
            this.printUsage();
            return false;
        }
        if (tempPort < 1 || tempPort > 65535) {
            MOut.G(this).println("port should be 1-65535");
            this.printUsage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/Managers/1/" + "Oem/" + "Supermicro/" + "RADIUS";
        BasicAuthClient bc = new BasicAuthClient(this.config);
        if (this.parameters == null) {
            int result = bc.send_https_get(url);
            if (result >= 200 && result <= 210) {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode node = mapper.readTree(bc.getResponseString());
                JsonNode ServiceEnabled = node.path("RadiusEnabled");
                JsonNode server = node.path("RadiusServer");
                JsonNode port = node.path("RadiusPortNumber");
                boolean isEnable = ServiceEnabled.asBoolean();
                String formatServer = " %-50s | %20s \n";
                StringBuffer header = new StringBuffer();
                header.append(String.format(formatServer, "Item", "Value"));
                header.append(String.format(formatServer, "----", "-----"));
                MOut.G(this).printf(formatServer, "RADIUS Enabled", ServiceEnabled.asBoolean());
                MOut.G(this).printf(formatServer, "Port", port.asText());
                MOut.G(this).printf(formatServer, "IP Address", server.asText());
                MOut.G(this).printf(formatServer, "Secret", "*****");
                MOut.G(this).println();
                this.printUsage();
                this.statusCode = 0;
            } else {
                this.printFailMessage(result, bc.getResponseString());
                this.statusCode = 149;
            }
        } else {
            String body = "{\"RadiusEnabled\":" + this.status + ",\"RadiusServer\":\"" + this.parameters[2] + "\",\"RadiusPortNumber\":" + this.parameters[1] + ",\"RadiusSecret\":\"" + this.parameters[3] + "\"}";
            System.out.println(body);
            int result = bc.send_https_patch(url, body);
            if (result >= 200 && result <= 210) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                this.printFailMessage(result, bc.getResponseString());
                this.statusCode = 149;
            }
        }
    }

    public void printUsage() {
        String usage = "Usage: redfish accountService radius [<authentication> <port> <ip address> <secret>]\nFor authentication:\nOn  : 1\nOff : 0\n* The port number should be 1-65535";
        MOut.G(this).println(usage);
    }
}

