/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.HashMap;

public class HIStatusCommand
extends RedfishCommand {
    public static final int STATE_GET = 0;
    public static final int STATE_SET_ENABLE = 1;
    public static final int STATE_SET_DISABLE = 2;
    public static final String URL_SUFFIX = "Managers/1/HostInterfaces/1";
    public static final String HOST_INTERFACE_NODE_ENABLED = "InterfaceEnabled";
    private int commandState = 0;

    @Override
    public boolean preValidate() {
        boolean result = false;
        if (this.parameters != null) {
            try {
                int status = Integer.parseInt(this.parameters[0]);
                if (0 <= status && status <= 1) {
                    this.commandState = status == 0 ? 2 : 1;
                    result = true;
                }
            }
            catch (Exception exception) {}
        } else {
            result = true;
            this.commandState = 0;
        }
        if (!result) {
            this.printUsage();
        }
        return result;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        RedfishHttpUtils utils = new RedfishHttpUtils();
        String url = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/" + URL_SUFFIX;
        if (this.commandState == 0) {
            int result = utils.sendRedfishGet(super.getConfig(), url);
            if (result >= 200 && result <= 210) {
                HashMap<String, String> entryMap = utils.getEntry();
                String state = entryMap.get(HOST_INTERFACE_NODE_ENABLED);
                MOut.G(this).print("Host Interface state is ");
                if (state != null && !state.isEmpty()) {
                    if (state.equalsIgnoreCase("true")) {
                        MOut.G(this).println("enabled");
                    } else if (state.equalsIgnoreCase("false")) {
                        MOut.G(this).println("disabled");
                    }
                    MOut.G(this).println("");
                    this.printUsage();
                    this.statusCode = 0;
                } else {
                    MOut.G(this).println("unknown");
                    this.statusCode = 149;
                }
            } else {
                MOut.G(this).println("Fail to set Host Interface. ErrorCode:" + result);
                this.statusCode = 149;
            }
        } else {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            String template = "{\"InterfaceEnabled\": %s}";
            String jsonBody = String.format(template, this.commandState == 1 ? "true" : "false");
            BasicAuthClient client = new BasicAuthClient(super.getConfig());
            int result = client.send_https_patch(url, jsonBody);
            if (result >= 200 && result <= 210) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Fail to set Host Interface. ErrorCode:" + result);
                this.statusCode = 149;
            }
        }
    }

    private void printUsage() {
        MOut.G(this).println("Usage: redfish hostInterface status [enabled]");
        MOut.G(this).println("       enable  : 1");
        MOut.G(this).println("       disable : 0");
    }
}

