/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishCommand;
import com.supermicro.redfish.RedfishHttpUtils;

public class CrashDumpDownloadCommand
extends RedfishCommand {
    public static final String DUMPDOWNLOAD = "/redfish/v1/Oem/Supermicro/DumpService/Dumps/HostCrashDump/Actions/SmcDump.Download";

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("File name is needed (.tar.gz)");
            return false;
        }
        if (!this.parameters[0].endsWith(".tar.gz")) {
            MOut.G(this).println("file format should be .tar.gz");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String ip = RedfishHttpUtils.getUrlIP(this.config.getIp());
        String url = "https://" + ip + "/" + DUMPDOWNLOAD;
        BasicAuthClient bc = new BasicAuthClient(this.config);
        int result = bc.send_https_get("https://" + ip + "/" + "/redfish/v1/Oem/Supermicro/DumpService/");
        if (result == 404) {
            MOut.G(this).println("Not supported device");
            this.statusCode = 153;
            return;
        }
        result = bc.send_http_post_download(url, this.parameters[0]);
        if (result >= 200 && result <= 210) {
            MOut.G(this).println("File had been saved");
            this.statusCode = 0;
            return;
        }
        if (result == 404) {
            MOut.G(this).println("Crash dump file is not ready, please run redfish crashDump generate command first");
            this.statusCode = 149;
            return;
        }
        this.printFailMessage(result, bc.getResponseString());
        this.statusCode = 149;
    }
}

