/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.RedfishHttpUtils;
import com.supermicro.redfish.text.AlertSetBaseCommand;

public class AlertSetRedfishCommand
extends AlertSetBaseCommand {
    public static final String URI_SUFFIX = "EventService/Subscriptions/";
    public static final String JSON_TEMPLATE = "{\"Oem\":{\"Supermicro\":{\"EnableSubscription\":true}},\"Protocol\":\"Redfish\",\"Destination\":\"%s\",\"Context\":\"%s\",\"EventTypes\":[\"Alert\"]}";

    @Override
    public boolean preValidate() {
        if (null == this.parameters || this.parameters.length != 3) {
            this.usage();
            this.statusCode = 147;
            return false;
        }
        if (!this.isValidNumber(this.parameters[0])) {
            this.statusCode = 147;
            MOut.G(this).println("Number should be a integer in 1-16 range.");
            this.usage();
            return false;
        }
        if (!this.isValidURL(this.parameters[1])) {
            this.statusCode = 147;
            MOut.G(this).println("It is an invalid destination.");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!AlertSetBaseCommand.isSupported(this.config)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        String jsonBody = String.format(JSON_TEMPLATE, this.parameters[1], this.parameters[2]);
        String redfishURI = "https://" + RedfishHttpUtils.getUrlIP(this.config.getIp()) + "/redfish/v1/" + URI_SUFFIX + this.parameters[0];
        this.runPatchCommand(redfishURI, jsonBody);
    }

    private void usage() {
        MOut.G(this).println("Usage: redfish event alert setRedfish <number> <destination> <message>");
        MOut.G(this).println("Destination: ");
        MOut.G(this).println("  start with http or https and also need port. [ex.https://smc.com:443]");
    }
}

