/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.DeviceInfo;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.redfish.BasicAuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.util.Iterator;
import org.apache.http.Header;

public class RedfishFlash
implements IPMIDCMOEMCommand.Progress {
    IPMIDCMOEMCommand.Progress progress;
    MOut mout = MOut.G();
    int valueBak = 0;

    public boolean flash(IPMIInterfaceConfig config, String filename, String bodyString) {
        String firmwareVersion;
        String pw;
        String id;
        String ip;
        RedfishFlash redfishFlash;
        long start;
        block31: {
            start = System.currentTimeMillis();
            redfishFlash = new RedfishFlash();
            redfishFlash.progress = redfishFlash;
            redfishFlash.setMOut(this.mout);
            ip = config.getIp();
            id = config.getUserName();
            pw = config.getPassword();
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
            this.mout.print("Check firmware file...");
            firmwareVersion = null;
            try {
                if (IPMIMessagingCommand.isX12GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12RoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12RoT(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12RoTHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12RoTHW1(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isH12RoTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12RoT(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isAST2600GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAST2600(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isAST2600HW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAST2600HW1(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isB12RoTHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB12RoTHW1(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isB12AST2600GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB12AST2600RoTHW1(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isB3ST1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB3AST2500(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12DGOGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12DGO(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isH12SSFFGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12SSFF(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isH12SSFRGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12SSFR(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isH12SSGGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12SSG(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionAST2600HW1ROT20(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isB12AST2600MAC1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionB12AST2600MAC1(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isM12GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionM12(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12AST2600NonRoT(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12SDV(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12AST2600NonRoTHW1(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12STW(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12DSCGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12DSC(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12DGQGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12DGQ(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isH12DSGGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionH12DSG(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isHGIMEZZGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionHGIMEZZ(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX13EGSGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13EGS(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX13EGSHW1GUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX13EGSHW1(filename);
                    break block31;
                }
                if (IPMIMessagingCommand.isX12SPTGUID(guid)) {
                    firmwareVersion = redfishFlash.checkFirmwareVersionX12SPT(filename);
                    break block31;
                }
                this.mout.println("Target BMC type error");
                return false;
            }
            catch (Exception ex) {
                this.mout.println(ex.getMessage());
                return false;
            }
        }
        this.mout.println(" Done (ver:" + firmwareVersion + ")");
        this.mout.print("Check BMC status...");
        String bmcVersion = null;
        try {
            bmcVersion = redfishFlash.getCurrentFWVersion(ip, id, pw);
        }
        catch (Exception ex) {
            this.mout.println(ex.getMessage());
            return false;
        }
        this.mout.print(" Done (ver:" + bmcVersion + ")");
        try {
            redfishFlash.flashWorker(config, filename, bodyString, true);
        }
        catch (Exception ex1) {
            this.mout.println(ex1.getMessage());
            return false;
        }
        this.printTimeString("\nTotal Elapsed Time", System.currentTimeMillis() - start);
        return true;
    }

    public boolean flashBIOS(IPMIInterfaceConfig config, String filename, String bodyString) {
        long start = System.currentTimeMillis();
        RedfishFlash redfishFlash = new RedfishFlash();
        redfishFlash.progress = redfishFlash;
        redfishFlash.setMOut(this.mout);
        try {
            redfishFlash.flashWorker(config, filename, bodyString, false);
        }
        catch (Exception ex1) {
            this.mout.println(ex1.getMessage());
            return false;
        }
        this.printTimeString("\nUpdate Time", System.currentTimeMillis() - start);
        return true;
    }

    public void flashWorker(IPMIInterfaceConfig config, String filename, String bodyString, boolean isBMCUpdate) throws Exception {
        this.resetValue();
        this.progress.message("Uploading file ");
        String ip = RedfishHttpUtils.getUrlIP(config.getIp());
        String url = "https://" + ip + "/redfish/v1/UpdateService/" + "upload";
        BasicAuthClient bc = new BasicAuthClient(config);
        int returncode = bc.post_https_Update_multipart(url, filename, bodyString, this.progress);
        if (returncode >= 200 && returncode <= 210) {
            this.printPercentage();
            this.resetValue();
            this.progress.message("Updating       ");
            for (Header header : bc.getResponseHeader()) {
                if (!header.getName().trim().equalsIgnoreCase("Location")) continue;
                url = "https://" + ip + header.getValue().trim();
                break;
            }
            bc.send_https_get(url);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode task = node.path("Task");
            url = "https://" + ip + task.asText();
            int i = 0;
            boolean missPercentCount = false;
            int progressRetry = 0;
            while (i != 100) {
                try {
                    bc.send_https_get(url);
                    node = mapper.readTree(bc.getResponseString());
                    JsonNode percent = node.path("PercentComplete");
                    JsonNode taskState = node.path("TaskState");
                    if (taskState.asText().equalsIgnoreCase("Exception")) {
                        JsonNode messageArray = node.path("Messages");
                        JsonNode message = messageArray.findValue("Message");
                        JsonNode resolution = messageArray.findValue("Resolution");
                        this.progress.message(message.asText() + " " + resolution.asText() + "\n");
                        throw new Exception("Update failed");
                    }
                    i = percent.asInt();
                    this.progress.setValue(i);
                    Thread.sleep(1000L);
                    progressRetry = 0;
                }
                catch (Exception e) {
                    if (i != 0) {
                        if (progressRetry == 5) {
                            this.progress.setValue(100);
                            break;
                        }
                        ++progressRetry;
                        continue;
                    }
                    throw e;
                }
            }
            this.printPercentage();
            if (isBMCUpdate) {
                int retry = 250;
                if (i == 100) {
                    this.progress.message("Resetting BMC");
                } else {
                    this.progress.message("Wait for BMC reset[" + i + "] ...");
                    try {
                        Thread.sleep((100 - i) * 3 * 1000);
                    }
                    catch (InterruptedException taskState) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException taskState) {
                    // empty catch block
                }
                while (retry > 0) {
                    InetAddress address = InetAddress.getByName(config.getIp());
                    boolean result = address.isReachable(3000);
                    if (result) {
                        try {
                            Thread.sleep(25000L);
                            if (address.isReachable(3000)) break;
                            result = false;
                        }
                        catch (Exception ex) {
                            result = false;
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    --retry;
                }
                if (retry == 0) {
                    this.progress.message("BMC IP is unavailable currently. Please check after 2 minutes later");
                    this.progress.message("RoT devices will perform system backup, may need up to 8 minutes to recover.");
                } else {
                    this.progress.message("Done");
                }
            } else {
                this.progress.message("Done");
            }
        } else if (returncode >= 400 && returncode < 500) {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(bc.getResponseString());
            JsonNode error = node.path("error");
            JsonNode extendInfo = error.path("@Message.ExtendedInfo");
            if (extendInfo.isArray()) {
                for (JsonNode l : extendInfo) {
                    Iterator<JsonNode> iterator;
                    JsonNode messageArgs = l.path("MessageArgs");
                    if (!messageArgs.isArray() || !(iterator = messageArgs.iterator()).hasNext()) continue;
                    JsonNode m = iterator.next();
                    throw new Exception("Error: " + m.asText());
                }
            }
        } else {
            if (returncode == 500) {
                throw new Exception("Error: 500 Internal Server Error. \nBMC is busy, please try again later");
            }
            throw new Exception("...Failed upload file, completion code " + returncode);
        }
    }

    public String checkFirmwareVersionX12RoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -15 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12RoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 2 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 RoT HW1 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 50 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12RoT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && (byte32[30] & 0xFF) == 34 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionM12(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && (byte32[30] & 0xFF) == 178 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (M12 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2600(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 82 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2600HW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 98 && byte32[31] == 2) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 AST2600RoT HW1 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB12RoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 18 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B12 RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB12AST2600RoTHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 114 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B12 AST2600RoT BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12DGO(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -46 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 DGO BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12SDV(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -14 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 SDV BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12SSFF(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -110 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12SSFF BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12SSFR(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -30 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12SSFR BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionAST2600HW1ROT20(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -62 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (SMT_X12IPMI2600 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB12AST2600MAC1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 3 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B12AST2600 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12STW(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 99 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 STW BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12DSC(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -125 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 DSC BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12SSG(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -109 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12 SSG BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionB3AST2500(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -93 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (B3 AST2500 BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12DGQ(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 19 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 DGQ BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionH12DSG(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 67 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12 DSG BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionHGIMEZZ(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 83 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (H12 DSG BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13EGS(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -61 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 EGS BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX13EGSHW1(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == -45 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X13 EGS BMC *.bin required)");
        }
        return version;
    }

    public String checkFirmwareVersionX12SPT(String filename) throws Exception {
        String version = null;
        File firmware = new File(filename);
        byte[] byte32 = new byte[32];
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        int block = 4096;
        do {
            int i = (int)(firmware.length() / (long)block / 2L);
            while ((long)i < firmware.length() / (long)block - 1L) {
                raf.seek((i + 1) * block);
                int count = raf.read(byte32);
                if (count != byte32.length) {
                    raf.close();
                    throw new Exception("File error");
                }
                if (byte32[0] == 83 && byte32[1] == 77 && byte32[2] == 67 && byte32[3] == 73 && byte32[4] == 115 && byte32[5] == 95 && byte32[6] == 70 && byte32[7] == 87 && byte32[30] == 84 && byte32[31] == 1) {
                    version = byte32[8] + "." + ByteUtility.byteToHex(byte32[9]);
                    break;
                }
                ++i;
            }
            if (version == null) continue;
            if (byte32[29] == -1) break;
            version = version + "." + ByteUtility.byteToHex(byte32[29]);
            break;
        } while ((block /= 2) >= 64);
        raf.close();
        if (version == null) {
            throw new Exception("Invalid file (X12 SPT BMC *.bin required)");
        }
        return version;
    }

    @Override
    public void setValue(int value) {
        if (value > this.valueBak) {
            for (int i = 0; i < value - this.valueBak; ++i) {
                if ((i + value) % 2 != 0) continue;
                this.mout.print(">");
            }
            this.valueBak = value;
        }
    }

    public void resetValue() {
        this.valueBak = 0;
    }

    public void printPercentage() {
        if (this.valueBak == 100) {
            this.mout.print(" 100%");
        }
    }

    public String getCurrentFWVersion(String ip, String username, String password) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiGlobalCommand);
        if (sessionController == null) {
            throw new Exception("Connect failed");
        }
        DeviceInfo deviceInfo = ipmiGlobalCommand.getDevice();
        sessionController.closeSession();
        if (deviceInfo.usingAuxiliaryFWVesion) {
            return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2) + "." + ByteUtility.byteToHex(deviceInfo.auxiliaryFirmwareRevisionInfo[0]);
        }
        return "" + deviceInfo.firmwareRevision1 + "." + ByteUtility.byteToHex(deviceInfo.firmwareRevision2);
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    @Override
    public void message(String message) {
        this.mout.print("\n" + message);
    }

    @Override
    public void left(long value) {
    }

    public IPMIDCMOEMCommand.Progress getProgress() {
        return this.progress;
    }

    public void setProgress(IPMIDCMOEMCommand.Progress progress) {
        this.progress = progress;
    }

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public static void main(String[] args) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String s = "{\r\n    \"Accepted\": {\r\n        \"code\": \"Base.v1_4_0.Accepted\",\r\n        \"Message\": \"Successfully Accepted Request. Please see the location header and ExtendedInfo for more information.\",\r\n        \"@Message.ExtendedInfo\": [\r\n            {\r\n                \"MessageId\": \"SMC.v1.0.OemSimpleupdateAcceptedMessage\",\r\n                \"Severity\": \"Ok\",\r\n                \"Resolution\": \"No resolution was required.\",\r\n                \"Message\": \"Please also check Task Resource /redfish/v1/TaskService/Tasks/1 to see more information.\",\r\n                \"MessageArgs\": [\r\n                    \"/redfish/v1/TaskService/Tasks/1\"\r\n                ],\r\n                \"RelatedProperties\": [\r\n                    \"BmcUpdateAccepted\"\r\n                ]\r\n            }\r\n        ]\r\n    }\r\n}";
        JsonNode node = mapper.readTree(s);
        JsonNode accept = node.path("Accepted");
        JsonNode extendInfo = accept.path("@Message.ExtendedInfo");
        if (extendInfo.isArray()) {
            for (JsonNode l : extendInfo) {
                JsonNode messageArgs = l.path("MessageArgs");
                if (!messageArgs.isArray()) continue;
                for (JsonNode m : messageArgs) {
                    System.out.println(m.asText());
                }
            }
        }
    }
}

