/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.redfish;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIDCMOEMCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.redfish.AuthClient;
import com.supermicro.redfish.RedfishHttpUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class BasicAuthClient
extends AuthClient {
    private String token;
    private String responseString;
    private String currentURL;
    private int statusCode;
    private Header[] responseHeaders;

    public BasicAuthClient(IPMIInterfaceConfig config) {
        this.config = config;
        this.token = Base64.getEncoder().encodeToString((config.getUserName() + ":" + config.getPassword()).getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_get(String url) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Authorization", "Basic " + this.token);
        CloseableHttpResponse response2 = httpClient.execute(httpGet);
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http get " + httpGet.getURI() + "]");
        }
        try {
            this.statusCode = response2.getStatusLine().getStatusCode();
            this.responseHeaders = response2.getAllHeaders();
            HttpEntity entity2 = response2.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
            int n = this.statusCode;
            return n;
        }
        finally {
            response2.close();
            httpClient.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_post(String url, String bodyString) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", "Basic " + this.token);
        if (bodyString.length() != 0) {
            StringEntity body = new StringEntity(bodyString);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setEntity(body);
        }
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http post " + httpPost.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpPost);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            this.responseHeaders = response.getAllHeaders();
            HttpEntity entity2 = response.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_http_post_download(String url, String localFile) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Authorization", "Basic " + this.token);
        httpPost.setHeader("Content-type", "application/json");
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http post " + httpPost.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpPost);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            this.responseHeaders = response.getAllHeaders();
            HttpEntity entity2 = response.getEntity();
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "]");
            }
            if (this.statusCode < 200 || this.statusCode > 210) {
                int n = this.statusCode;
                return n;
            }
            InputStream in = entity2.getContent();
            FileOutputStream outputStream = new FileOutputStream(new File(localFile));
            try {
                int read = 0;
                byte[] bytes = new byte[1024];
                boolean i = false;
                while ((read = in.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, read);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("error writing zip file, error message : " + ex.getMessage(), ex);
            }
            finally {
                try {
                    outputStream.close();
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_post_uploadFile(String url, String bodyString, String fileName) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpPost httpUpload = new HttpPost(url);
        httpUpload.setHeader("Authorization", "Basic " + this.token);
        FileBody fileBody = new FileBody(new File(fileName));
        StringBody stringBody = new StringBody(bodyString, ContentType.MULTIPART_FORM_DATA);
        MultipartEntityBuilder mpBuilder = MultipartEntityBuilder.create();
        mpBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        mpBuilder.addPart("UpdateParameters", stringBody);
        mpBuilder.addPart("UpdateFile", fileBody);
        HttpEntity entity = mpBuilder.build();
        httpUpload.setEntity(entity);
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http post " + httpUpload.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpUpload);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity2 = response.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int post_https_Update_multipart(String url, String filename, String bodyString, IPMIDCMOEMCommand.Progress progress) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        HttpPost httpUpload = new HttpPost(url);
        httpUpload.setHeader("Authorization", "Basic " + this.token);
        FileBody fileBody = new FileBody(new File(filename));
        StringBody stringBody1 = new StringBody(bodyString, ContentType.MULTIPART_FORM_DATA);
        MultipartEntityBuilder mpBuilder = MultipartEntityBuilder.create();
        mpBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        mpBuilder.addPart("UpdateParameters", stringBody1);
        mpBuilder.addPart("UpdateFile", fileBody);
        HttpEntity entity = mpBuilder.build();
        ProgressListener pListener = percentage -> progress.setValue((int)percentage);
        httpUpload.setEntity(new ProgressEntityWrapper(entity, pListener));
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http post " + httpUpload.getURI() + "]");
        }
        try (CloseableHttpResponse response = httpClient.execute(httpUpload);){
            this.statusCode = response.getStatusLine().getStatusCode();
            this.responseHeaders = response.getAllHeaders();
            HttpEntity entity2 = response.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        httpClient.close();
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_patch(String url, String bodyString) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setHeader("Authorization", "Basic " + this.token);
        if (bodyString.length() != 0) {
            StringEntity body = new StringEntity(bodyString);
            httpPatch.setHeader("Content-type", "application/json");
            httpPatch.setEntity(body);
        }
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http patch " + httpPatch.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpPatch);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity2 = response.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_patch(String url, String bodyString, String charSet) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpPatch httpPatch = new HttpPatch(url);
        httpPatch.setHeader("Authorization", "Basic " + this.token);
        if (bodyString.length() != 0) {
            StringEntity body = new StringEntity(bodyString, charSet);
            httpPatch.setHeader("Content-type", "application/json");
            httpPatch.setEntity(body);
        }
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http patch " + httpPatch.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpPatch);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity2 = response.getEntity();
            this.responseString = EntityUtils.toString(entity2);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send_https_delete(String url) throws Exception {
        CloseableHttpClient httpClient = this.prepareHttpClient();
        this.resetURL(url);
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.setHeader("Authorization", "Basic " + this.token);
        if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
            System.out.println("[ YOU -> BMC : Sending http post " + httpDelete.getURI() + "]");
        }
        CloseableHttpResponse response = httpClient.execute(httpDelete);
        try {
            this.statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            this.responseString = EntityUtils.toString(entity);
            if (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL > 0) {
                System.out.println("[ BMC -> YOU : " + this.statusCode + "  " + this.responseString + "]");
            }
        }
        finally {
            response.close();
            httpClient.close();
        }
        return this.statusCode;
    }

    public String getResponseString() {
        return this.responseString;
    }

    public Header[] getResponseHeader() {
        return this.responseHeaders;
    }

    private void resetURL(String url) {
        this.responseString = "";
        this.currentURL = url;
        this.statusCode = 0;
    }

    public void printResult() {
        System.out.println("URL:" + this.currentURL);
        System.out.println("Redfish StatusCode:" + this.statusCode);
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.147.160.34");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        BasicAuthClient bc = new BasicAuthClient(config);
        try {
            GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = 1;
            bc.send_https_get("https://" + RedfishHttpUtils.getUrlIP(config.getIp()) + "/redfish/v1/Systems/1");
            System.out.println(bc.responseString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class CountingOutputStream
    extends FilterOutputStream {
        private ProgressListener listener;
        private long transferred;
        private long totalBytes;

        public CountingOutputStream(OutputStream out, ProgressListener listener, long totalBytes) {
            super(out);
            this.listener = listener;
            this.transferred = 0L;
            this.totalBytes = totalBytes;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.transferred += (long)len;
            this.listener.progress(this.getCurrentProgress());
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.transferred;
            this.listener.progress(this.getCurrentProgress());
        }

        private float getCurrentProgress() {
            return (float)this.transferred / (float)this.totalBytes * 100.0f;
        }
    }

    public class ProgressEntityWrapper
    extends HttpEntityWrapper {
        ProgressListener listener;

        public ProgressEntityWrapper(HttpEntity entity, ProgressListener listener) {
            super(entity);
            this.listener = listener;
        }

        @Override
        public void writeTo(OutputStream outstream) throws IOException {
            super.writeTo(new CountingOutputStream(outstream, this.listener, this.getContentLength()));
        }
    }

    public static interface ProgressListener {
        public void progress(float var1);
    }
}

