/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.nm.suspendperiod;

import com.supermicro.ipmi.text.nm.suspendperiod.AbstractSuspenPeriodCommand;
import java.text.ParseException;

public class ClearPeriod
extends AbstractSuspenPeriodCommand {
    private int domainId;
    private int policyId;

    public ClearPeriod(String[] parameters) {
        super(parameters);
        try {
            this.validate(parameters);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid value: " + e.getMessage());
        }
    }

    protected void validate(String[] parameters) throws ParseException {
        if (parameters == null || parameters.length != 2) {
            this.help();
            throw new IllegalArgumentException();
        }
        this.domainId = Integer.parseInt(parameters[0]);
        this.policyId = Integer.parseInt(parameters[1]);
        if (this.domainId < 0 || this.policyId < 0 || this.policyId > 255) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    @Override
    public byte[] getNewPeriod(byte[] currentPeriod) {
        return new byte[0];
    }

    @Override
    public int getDomainId() {
        return this.domainId;
    }

    @Override
    public int getPolicyId() {
        return this.policyId;
    }

    @Override
    public void help() {
        System.out.println("clear <domainId> <policyId>");
        System.out.println("domainId :");
        System.out.println("\t0 \u2013 Entire platform");
        System.out.println("\t1 \u2013 CPU subsystem");
        System.out.println("\t2 \u2013 Memory subsystem");
        System.out.println("\t3 \u2013 HW Protection (NM3.0)");
        System.out.println("\t4 \u2013 High Power I/O subsystem");
        System.out.println("policyId : 0~255");
    }
}

