/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.trap.usm.UserTable;
import com.supermicro.ipmi.trap.usm.UserTableUtils;
import java.util.List;

public class TrapUserTableListCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        this.listUserTable();
        this.statusCode = 0;
    }

    private void listUserTable() {
        List<UserTable> userTableList = UserTableUtils.readPropertyFile(UserTableUtils.DEFAULT_FILE_PATH);
        if (null != userTableList && userTableList.size() > 0) {
            String formatHeader = "%3s | %-16s | %-19s | %-16s | %-16s | %-16s\n";
            String formatPayload = "%3d | %-16s | %-19s | %-16s | %-16s | %-16s\n";
            StringBuilder outputBuilder = new StringBuilder();
            outputBuilder.append(String.format("%3s | %-16s | %-19s | %-16s | %-16s | %-16s\n", "---", "----------------", "-------------------", "----------------", "----------------", "----------------"));
            outputBuilder.append(String.format("%3s | %-16s | %-19s | %-16s | %-16s | %-16s\n", UserTableUtils.FIELD_NAMES));
            outputBuilder.append(String.format("%3s | %-16s | %-19s | %-16s | %-16s | %-16s\n", "---", "----------------", "-------------------", "----------------", "----------------", "----------------"));
            for (int idx = 0; idx < userTableList.size(); ++idx) {
                UserTable userTable = userTableList.get(idx);
                outputBuilder.append(String.format("%3d | %-16s | %-19s | %-16s | %-16s | %-16s\n", idx + 1, userTable.getName(), userTable.getAuthProtocol().getProtocol(), userTable.getAuthPassword(), userTable.getPrivProtocol().getProtocol(), userTable.getPrivPassword()));
            }
            System.out.println(outputBuilder.toString());
        } else {
            System.out.println("snmpUserTable.properties file does not exist or file is empty.");
            System.out.println("You can create it by 'trap userTable add <..>' command.");
        }
        this.statusCode = 0;
    }
}

