/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.GetTurboSynchronizationRatio;
import com.supermicro.ipmi.nm.TurboRatio;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM40AbstractCommand;

public class NM40GetTurboSyncRatioCommand
extends NM40AbstractCommand {
    private int socket;
    private int core;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 2) {
            this.help();
            return false;
        }
        try {
            this.socket = Integer.parseInt(this.parameters[0]);
            this.core = Integer.parseInt(this.parameters[1]);
            if (this.socket < 0 || this.core > 255 || this.core < 0 || this.core > 255) {
                this.help();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runNM40Command() throws Exception {
        try {
            IPMINM20Command ipmiNM20Command = new IPMINM20Command(this.getNMInterface());
            GetTurboSynchronizationRatio command = new GetTurboSynchronizationRatio(ipmiNM20Command, (byte)this.socket, (byte)this.core);
            TurboRatio tr = command.execute();
            this.print(tr);
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = ex.getMessage().contains("Used to indicate an unrecognized or unsupported command") ? 153 : 148;
        }
    }

    private void print(TurboRatio tr) {
        MOut.G(this).println("Current Turbo Ratio Limit = " + tr.curTurboRatioLimit);
        MOut.G(this).println("Default Turbo Ratio Limit = " + tr.defTurboRatioLimit);
        MOut.G(this).println("Maximum Turbo Ratio Limit = " + tr.maxTurboRatioLimit);
        MOut.G(this).println("Minimum Turbo Ratio Limit = " + tr.minTurboRatioLimit);
    }

    private void help() {
        MOut.G(this).println("getTurboSyncRatio <socket> <core>");
        MOut.G(this).println("socket: CPU socket number");
        MOut.G(this).println("\t0~7       \u2013 For which current settings should be read.");
        MOut.G(this).println("\t255 (FFh) \u2013 All sockets will return common maximum settings.");
        MOut.G(this).println("core: Active cores configuration");
        MOut.G(this).println("\t255 (FFh) \u2013 Read configuration for all active cores.");
    }
}

