/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.nm.cups.CUPSPolicyParam;
import com.supermicro.ipmi.nm.cups.GetCUPSPolicy;
import com.supermicro.ipmi.nm.cups.SetCUPSPolicy;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM30AbstractCommand;

public class NM30SetCUPSPolicy
extends NM30AbstractCommand {
    private final int targetId = 1;
    private final int enable = 1;
    private int domainId;
    private int storageOpt;
    private int alert;
    private int threshold;
    private int avgWindow;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 5) {
            this.help();
            return false;
        }
        try {
            this.domainId = Integer.parseInt(this.parameters[0]);
            this.storageOpt = Integer.parseInt(this.parameters[1]);
            this.alert = Integer.parseInt(this.parameters[2]);
            this.threshold = Integer.parseInt(this.parameters[3]);
            this.avgWindow = Integer.parseInt(this.parameters[4]);
            if (this.threshold < 0 || this.avgWindow < 0) {
                this.help();
                return false;
            }
            if (!(this.isValidVal(this.domainId, new int[]{1, 2, 4}) && this.isValidVal(this.storageOpt, new int[]{0, 1}) && this.isValidVal(this.alert, new int[]{0, 1}))) {
                this.help();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print("Invalid value: " + ex.getMessage());
            return false;
        }
        return true;
    }

    private boolean isValidVal(int value, int[] valids) {
        for (int i = 0; i < valids.length; ++i) {
            if (value != valids[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void runNM30Command() throws Exception {
        try {
            byte[] avgWindowInBytes = new byte[2];
            ByteUtility.intTo2Bytes(avgWindowInBytes, 0, this.avgWindow);
            CUPSPolicyParam policy = new CUPSPolicyParam((byte)this.domainId, 1, 1, (byte)(this.storageOpt << 7), (byte)this.alert, (byte)this.threshold, avgWindowInBytes);
            SetCUPSPolicy command = new SetCUPSPolicy(this.ipmiNM20Command, policy);
            command.execute();
            MOut.G(this).print("Done.\n");
            this.getPolicy(this.domainId, 1);
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private void getPolicy(int domain, int target) throws IPMIException {
        GetCUPSPolicy command = new GetCUPSPolicy(this.ipmiNM20Command, domain, target);
        IPMINM20Command.CUPSPolicy cupsPolicy = command.execute();
        MOut.G(this).println(cupsPolicy.toString());
    }

    private void help() {
        MOut.G(this).println("setCpuPolicy <domainId> <storage> <alert> <threshold> <avgWindow>");
        MOut.G(this).println("domainId:");
        MOut.G(this).println("\t1 \u2013 Core Domain");
        MOut.G(this).println("\t2 \u2013 Memory Domain");
        MOut.G(this).println("\t4 \u2013 IO Domain");
        MOut.G(this).println("storage:");
        MOut.G(this).println("\t0 \u2013 Persistent storage");
        MOut.G(this).println("\t1 \u2013 Volatile memory");
        MOut.G(this).println("alert:");
        MOut.G(this).println("\t0 \u2013 Disable alerting");
        MOut.G(this).println("\t1 \u2013 Enable sending of alert");
        MOut.G(this).println("threshold: CUPS Threshold");
        MOut.G(this).println("avgWindow: Averaging Window (in Seconds)");
    }
}

