/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.nm.SetNodeManagerPowerDrawRange;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20SetPowerDrawRangeCommand
extends NM20AbstractCommand {
    private static final int POWER_DRAW_MAX = Short.MAX_VALUE;
    private int domainId;
    private int minPowerDraw;
    private int maxPowerDraw;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length != 3) {
            this.help();
            return false;
        }
        try {
            this.domainId = Integer.parseInt(this.parameters[0]);
            this.minPowerDraw = Integer.parseInt(this.parameters[1]);
            this.maxPowerDraw = Integer.parseInt(this.parameters[2]);
            if (this.domainId < 0 || this.minPowerDraw < 0 || this.minPowerDraw > Short.MAX_VALUE || this.maxPowerDraw < 0 || this.maxPowerDraw > Short.MAX_VALUE) {
                this.help();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runNM20Command() throws Exception {
        try {
            byte[] minPoweDrawInBytes = new byte[2];
            byte[] maxPoweDrawInBytes = new byte[2];
            ByteUtility.intTo2Bytes(minPoweDrawInBytes, 0, this.minPowerDraw);
            ByteUtility.intTo2Bytes(maxPoweDrawInBytes, 0, this.maxPowerDraw);
            SetNodeManagerPowerDrawRange command = new SetNodeManagerPowerDrawRange(this.ipmiNM20Command, (byte)this.domainId, minPoweDrawInBytes, maxPoweDrawInBytes);
            command.execute();
            MOut.G(this).println("Done");
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private void help() {
        MOut.G(this).println("setPowerDrawRange <domain ID> <min> <max>");
        MOut.G(this).println("Domain ID:");
        MOut.G(this).println("0 \u2013 Entire platform");
        MOut.G(this).println("1 \u2013 CPU subsystem");
        MOut.G(this).println("2 \u2013 Memory subsystem");
        MOut.G(this).println("3 \u2013 HW Protection (NM3.0)");
        MOut.G(this).println("4 \u2013 High Power I/O subsystem");
        MOut.G(this).println("min/max: 0~32767");
    }
}

