/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.nm.GetNodeManagerPolicyAlertThresholds;
import com.supermicro.ipmi.nm.PolicyAlertThresholds;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20GetAlertThresholdCommand
extends NM20AbstractCommand {
    private int domainId;
    private int policyId;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 2) {
            this.help();
            return false;
        }
        try {
            this.domainId = Integer.parseInt(this.parameters[0]);
            this.policyId = Integer.parseInt(this.parameters[1]);
            if (this.domainId < 0 || this.policyId < 0 || this.policyId > 255) {
                this.help();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runNM20Command() throws Exception {
        try {
            GetNodeManagerPolicyAlertThresholds command = new GetNodeManagerPolicyAlertThresholds(this.ipmiNM20Command);
            PolicyAlertThresholds resp = command.execute((byte)this.domainId, (byte)this.policyId);
            resp.toReadableString();
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private void help() {
        MOut.G(this).println("getAlertThreshold <domainId> <policyId>");
        MOut.G(this).println("domainId:");
        MOut.G(this).println("\t0 \u2013 Entire platform");
        MOut.G(this).println("\t1 \u2013 CPU subsystem");
        MOut.G(this).println("\t2 \u2013 Memory subsystem");
        MOut.G(this).println("\t3 \u2013 HW Protection (NM3.0)");
        MOut.G(this).println("\t4 \u2013 High Power I/O subsystem");
        MOut.G(this).println("policyId: 0~255");
    }
}

