/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIDCMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.nm.dcmi.ActivatePowerLimit;
import com.supermicro.ipmi.nm.dcmi.GetPowerLimit;
import com.supermicro.ipmi.nm.dcmi.PowerLimit;
import com.supermicro.ipmi.nm.dcmi.SetPowerLimit;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;

public class NM20DCMIPowerLimit
extends NM20AbstractCommand {
    private int cmdAction;
    private int action;
    private int limit;
    private int cTime;
    private int period;

    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length == 0) {
            this.cmdAction = 0;
            return true;
        }
        this.cmdAction = 1;
        return this.perValidateForSet();
    }

    private boolean perValidateForSet() {
        if (this.parameters == null || this.parameters.length != 4) {
            this.help();
            return false;
        }
        try {
            this.action = Integer.parseInt(this.parameters[0]);
            this.limit = Integer.parseInt(this.parameters[1]);
            this.cTime = Integer.parseInt(this.parameters[2]);
            this.period = Integer.parseInt(this.parameters[3]);
            if (this.action != 0 && this.action != 1 && this.action != 17) {
                this.help();
                return false;
            }
            if (this.limit < 0 || this.cTime < 0 || this.period < 0) {
                this.help();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void runNM20Command() throws Exception {
        try {
            IPMIDCMICommand dcmi = new IPMIDCMICommand(this.ipmiInterfaceForNM);
            if (this.cmdAction == 1) {
                this.set(dcmi);
            } else {
                this.get(dcmi);
            }
            this.statusCode = 0;
        }
        catch (IPMIException ie) {
            if ((ie.getIPMIMessage().completionCode & 0xFF) != 128) {
                throw ie;
            }
            MOut.G(this).print("Power limit is diabled or not set.");
            this.statusCode = 0;
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
        }
    }

    private void set(IPMIDCMICommand dcmi) throws IPMIException {
        PowerLimit pl = new PowerLimit(this.action, this.limit, this.cTime, this.period);
        new SetPowerLimit(dcmi, pl).execute();
        new ActivatePowerLimit(dcmi, 1).execute();
        MOut.G(this).println("Done");
        this.get(dcmi);
    }

    private void get(IPMIDCMICommand dcmi) throws IPMIException {
        GetPowerLimit command = new GetPowerLimit(dcmi);
        PowerLimit resp = command.execute();
        MOut.G(this).println(resp.toReadableString());
    }

    private void help() {
        MOut.G(this).println("powerLimit <action> <limit> <cTime> <period>");
        MOut.G(this).println("action: Exception actions");
        MOut.G(this).println("\t 0(0x00) \u2013 No action");
        MOut.G(this).println("\t 1(0x01) \u2013 Hard Power Off system and log event to SEL");
        MOut.G(this).println("\t17(0x11) \u2013 Log event to SEL");
        MOut.G(this).println("limit : Power limit in watts");
        MOut.G(this).println("cTime : Correction time limit in milliseconds");
        MOut.G(this).println("period: Management application statistics sampling period in seconds.");
    }
}

