/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMINM20Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.NM20AbstractCommand;
import com.supermicro.ipmi.text.NMPolicyDto;
import com.supermicro.ipmi.text.NMPolicyFinder;

public class NM20AddPowerPolicyCommand
extends NM20AbstractCommand {
    private int limit;
    private int correctionTime;
    private int reportingPeriod;
    private int ca;

    @Override
    public void runNM20Command() throws Exception {
        byte id;
        if (this.parameters == null || this.parameters.length != 4 && this.parameters.length != 5) {
            MOut.G(this).println("addPowerPolicy <pID> <limit> <t> <p> [<ca>]");
            MOut.G(this).println("pID: Policy ID");
            MOut.G(this).println("limit: Policy Target Limit");
            MOut.G(this).println("t: Correction Time Limit (ms)");
            MOut.G(this).println("p: Statistics Reporting Period in seconds");
            MOut.G(this).println("ca: Policy ID conflict action:");
            MOut.G(this).println("  0 - no action (default)");
            MOut.G(this).println("  1 - overwrite");
            MOut.G(this).println("");
            MOut.G(this).println("* domainID will be 0(Entire platform) for this command");
            MOut.G(this).println("ex: nm20 addPowerPolicy  1 100 6000 10");
            this.statusCode = 0;
            return;
        }
        this.correctionTime = 60000;
        this.reportingPeriod = 1;
        this.ca = 0;
        try {
            id = (byte)Integer.parseInt(this.parameters[0]);
            this.limit = Integer.parseInt(this.parameters[1]);
            this.correctionTime = Integer.parseInt(this.parameters[2]);
            this.reportingPeriod = Integer.parseInt(this.parameters[3]);
            if (this.parameters.length == 5) {
                this.ca = Integer.parseInt(this.parameters[4]);
                if (this.ca != 0 && this.ca != 1) {
                    MOut.G(this).println("Invalid value of <ca>");
                    this.statusCode = 147;
                    return;
                }
            }
        }
        catch (NumberFormatException ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        NMPolicyFinder pf = new NMPolicyFinder(this.ipmiNM20Command, id);
        if (pf.hasExist()) {
            System.out.println("Policy ID is conflict!\n");
            this.displayCompareTable(pf.policy);
            System.out.println("Policy ID conflict action: " + (this.ca == 1 ? "Overwrite" : "No action"));
            if (this.ca == 0) {
                System.out.println("If the policy need to be overwritten, please set the <ca> to 1.");
                this.statusCode = 0;
                return;
            }
        }
        IPMINM20Command.NodeManagerPolicySetting policySetting = this.ipmiNM20Command.createNodeManagerPolicySetting();
        policySetting.domainID = (byte)16;
        policySetting.policyID = id;
        policySetting.policyConfig = (byte)16;
        policySetting.PolicyException = 1;
        ByteUtility.intTo2Bytes(policySetting.powerLimit, 0, this.limit);
        ByteUtility.intTo4Bytes(policySetting.correctionTimeLimit, 0, this.correctionTime);
        ByteUtility.intTo2Bytes(policySetting.policyTriggerLimit, 0, this.limit);
        ByteUtility.intTo2Bytes(policySetting.statisticsReportingPeriod, 0, this.reportingPeriod);
        try {
            this.ipmiNM20Command.setNodeManagerPolicy(policySetting);
            this.ipmiNM20Command.enableDisableNodeManagerPolicyControl((byte)5, (byte)0, id);
        }
        catch (Exception ex) {
            MOut.G(this).print(ex.getMessage());
            this.statusCode = 148;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }

    public void displayCompareTable(NMPolicyDto pd) {
        StringBuilder sb = new StringBuilder();
        String format = "%-32s|%8s|%6s\n";
        sb.append(String.format(format, "Item", "Current", "New"));
        sb.append(String.format(format, "--------------------------------", "--------", "------"));
        sb.append(String.format(format, "Domain ID", pd.domainId, 0));
        sb.append(String.format(format, "Policy Target Limit", pd.getTargetLimit(), this.limit));
        sb.append(String.format(format, "Correction Time Limit", pd.corrTime, this.correctionTime));
        sb.append(String.format(format, "Statistics Reporting Period", pd.statPeriod, this.reportingPeriod));
        System.out.println(sb.toString());
    }
}

