/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class IPMIOEMRadiusCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte authentication;
    private byte[] port;
    private byte[] ip;
    private byte[] secret;
    private byte ipFormat;
    private String usage = "Usage: ipmi oem x10cfg radius [<authentication> <port> <ip address> <secret>]\nFor authentication:\nOn  : 1\nOff : 0\n* The port number should be 1-65535";
    private final byte INVALID_IP_FORMAT = 0;
    private final byte VALID_IPv4_FORMAT = 1;
    private final byte VALID_IPv6_FORMAT = (byte)2;
    private final byte VALID_FQDN_FORMAT = (byte)3;
    private final byte[] DEFAULT_IPv4 = new byte[]{0, 0, 0, 0};

    @Override
    public boolean preValidate() {
        int tempPort;
        if (this.parameters == null) {
            return true;
        }
        if (this.parameters.length != 4) {
            MOut.G(this).println(this.usage);
            return false;
        }
        try {
            this.authentication = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("authentication should be number");
            MOut.G(this).println(this.usage);
            return false;
        }
        if (this.authentication < 0 || this.authentication > 1) {
            MOut.G(this).println("authentication should be 0 or 1");
            MOut.G(this).println(this.usage);
            return false;
        }
        try {
            tempPort = Integer.parseInt(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("port should be number");
            MOut.G(this).println(this.usage);
            return false;
        }
        if (tempPort < 1 || tempPort > 65535) {
            MOut.G(this).println("port should be 1-65535");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.port = new byte[2];
        ByteUtility.intTo2Bytes(this.port, 0, tempPort);
        this.ipFormat = this.checkAddressFormat(this.parameters[2]);
        if (this.ipFormat == 0) {
            MOut.G(this).println("Address format:");
            MOut.G(this).println("IPv4 should be ###.###.###.###");
            MOut.G(this).println("IPv6 should be ###:###:###:###:###:###:###:###");
            MOut.G(this).println("FQDN should be ######.####.#####.###");
            MOut.G(this).println(this.usage);
            return false;
        }
        this.ip = this.ipFormat == 1 ? ByteUtility.ipToBytes(this.parameters[2]) : this.parameters[2].getBytes();
        this.secret = this.parameters[3].getBytes();
        if (this.secret.length > 255) {
            MOut.G(this).println("Secret should less then 255 characters");
            MOut.G(this).println(this.usage);
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        this.handleGetRadiusCommand(ipmiOEMWebSettingCommand);
        this.handleSetRadiusCommand(ipmiOEMWebSettingCommand);
    }

    private void handleGetRadiusCommand(IPMIOEMWebSettingCommand ipmiCommand) throws Exception {
        if (this.parameters == null) {
            byte[] params = ipmiCommand.getRadius((byte)0);
            byte[] secret = ipmiCommand.getLdap((byte)1);
            String ipAdrr = this.getIPAddress(params, ipmiCommand);
            String formatServer = " %-50s | %20s \n";
            StringBuffer header = new StringBuffer();
            header.append(String.format(formatServer, "Item", "Value"));
            header.append(String.format(formatServer, "----", "-----"));
            MOut.G(this).printf(formatServer, "RADIUS Authentication", params[0] == 1 ? "On" : "Off");
            MOut.G(this).printf(formatServer, "Port", ByteUtility.twoBytesToIntLSB(ByteUtility.getBytes(params, 1, 2)));
            MOut.G(this).printf(formatServer, "IP Address", ipAdrr);
            MOut.G(this).printf(formatServer, "Secret", secret == null ? "" : new String(secret).trim());
            this.statusCode = 0;
            MOut.G(this).println("\n" + this.usage);
            return;
        }
    }

    private void handleSetRadiusCommand(IPMIOEMWebSettingCommand ipmiCommand) throws Exception {
        ByteBuffer byteBuffer;
        if (this.parameters == null) {
            return;
        }
        if (this.checkIfSystemLockdown()) {
            return;
        }
        byte adAuth = ipmiCommand.getADServer((byte)0)[0];
        if (adAuth == 1) {
            MOut.G(this).println("Active Directory has been enabled, please disable Active Directory before enabling Radius");
            this.statusCode = 149;
            return;
        }
        byte auth = ipmiCommand.getLdap((byte)0)[0];
        if (auth == 1) {
            MOut.G(this).println("LDAP has been enabled, please disable LDAP before enabling Radius");
            this.statusCode = 149;
            return;
        }
        if (this.ipFormat == 1) {
            byteBuffer = ByteBuffer.allocate(1 + this.port.length + this.ip.length);
            byteBuffer.put(this.authentication);
            byteBuffer.put(this.port);
            byteBuffer.put(this.ip);
            if (!ipmiCommand.setRadius((byte)0, byteBuffer.array())) {
                MOut.G(this).println("Set RADIUS IPv4 auth, port and ip parameter failed");
                this.statusCode = 149;
                return;
            }
        }
        if (this.ipFormat == 2 || this.ipFormat == 3) {
            byteBuffer = ByteBuffer.allocate(1 + this.port.length + 4);
            byteBuffer.put(this.authentication);
            byteBuffer.put(this.port);
            byteBuffer.put(this.DEFAULT_IPv4);
            if (!ipmiCommand.setRadius((byte)0, byteBuffer.array())) {
                MOut.G(this).println("Set RADIUS IPv6 auth and port parameter failed");
                this.statusCode = 149;
                return;
            }
            ByteBuffer byteBufferIPv6 = ByteBuffer.allocate(this.ip.length + 1);
            byteBufferIPv6.put(this.ip);
            byteBufferIPv6.put((byte)0);
            if (!ipmiCommand.setRadius((byte)2, byteBufferIPv6.array())) {
                MOut.G(this).println("Set RADIUS IPv6 or FQDN parameter failed");
                this.statusCode = 149;
                return;
            }
        }
        byteBuffer = ByteBuffer.allocate(this.secret.length + 1);
        byteBuffer.put(this.secret);
        byteBuffer.put((byte)0);
        if (!ipmiCommand.setRadius((byte)1, byteBuffer.array())) {
            MOut.G(this).println("Set secret failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }

    private String getIPAddress(byte[] params, IPMIOEMWebSettingCommand ipmiCommand) throws IPMIException {
        if ((params[3] | params[4] | params[5] | params[6]) != 0) {
            return (params[3] & 0xFF) + "." + (params[4] & 0xFF) + "." + (params[5] & 0xFF) + "." + (params[6] & 0xFF);
        }
        StringBuffer strBuffer = new StringBuffer();
        byte[] ipByteArray = ipmiCommand.getRadius((byte)2);
        if (ipByteArray == null) {
            return "0.0.0.0";
        }
        for (byte asciiByte : ipByteArray) {
            strBuffer.append(Character.toString((char)asciiByte));
        }
        return strBuffer.toString();
    }

    private byte checkAddressFormat(String addr) {
        String chunkIPv4 = "([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
        String chunkIPv6 = "[0-9a-fA-F]{1,4}";
        String chunkFQDN = "[0-9a-zA-Z]{1,63}";
        Pattern IPV4_STD_REGEX = Pattern.compile("^(" + chunkIPv4 + "\\.){3}" + chunkIPv4 + "$");
        Pattern IPV6_STD_REGEX = Pattern.compile("^(?:" + chunkIPv6 + ":){7}" + chunkIPv6 + "$");
        Pattern IPV6_COMPRESS_REGEX = Pattern.compile("^((?:" + chunkIPv6 + "(:" + chunkIPv6 + ")*)?)::((?:(" + chunkIPv6 + ":)*" + chunkIPv6 + ")?)$");
        Pattern IPV6_COMPRESS_REGEX_BORDER = Pattern.compile("^(::(?:" + chunkIPv6 + ")(?::" + chunkIPv6 + "){5})|((?:" + chunkIPv6 + ")(?::" + chunkIPv6 + "){5}::)$");
        Pattern FQDN_REGEX = Pattern.compile("^(" + chunkFQDN + "\\.)*" + chunkFQDN + "$");
        if (IPV4_STD_REGEX.matcher(addr).matches()) {
            return 1;
        }
        if (IPV6_STD_REGEX.matcher(addr).matches() || IPV6_COMPRESS_REGEX.matcher(addr).matches() || IPV6_COMPRESS_REGEX_BORDER.matcher(addr).matches()) {
            return 2;
        }
        if (FQDN_REGEX.matcher(addr).matches() && addr.length() <= 255) {
            return 3;
        }
        return 0;
    }

    public static void main(String[] args) {
    }
}

