/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIAMIOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIOEMLANInterfaceCommand
extends SuperBladeCommand {
    public static final byte GET_LAN_MODE = -1;
    public static final byte DEDICATED = 0;
    public static final byte SHARE = 1;
    public static final byte FAILOVER = 2;
    private byte commandArgs;

    @Override
    public boolean preValidate() {
        this.commandArgs = (byte)-2;
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("0")) {
                this.commandArgs = 0;
            } else if (this.parameters[0].equalsIgnoreCase("1")) {
                this.commandArgs = 1;
            } else if (this.parameters[0].equalsIgnoreCase("2")) {
                this.commandArgs = (byte)2;
            }
        } else {
            this.commandArgs = (byte)-1;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMIAMIOEMCommand ipmiAMIOEMCommand = new IPMIAMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte supportedMask = this.getLANModeMask(ipmiAMIOEMCommand);
        int returnCode = 0;
        switch (this.commandArgs) {
            case 0: 
            case 1: 
            case 2: {
                returnCode = this.setLANMode(ipmiAMIOEMCommand, supportedMask);
                break;
            }
            case -1: {
                returnCode = this.getLANMode(ipmiAMIOEMCommand, supportedMask);
                break;
            }
            default: {
                returnCode = this.unknownMode();
            }
        }
        this.statusCode = returnCode;
    }

    private byte getLANModeMask(IPMIAMIOEMCommand command) {
        try {
            return command.getLANModeCap();
        }
        catch (IPMIException e) {
            return 0;
        }
    }

    private byte getLANMode(IPMIAMIOEMCommand command) throws IPMIException {
        return command.getLANMode();
    }

    private int getLANMode(IPMIAMIOEMCommand command, byte supportedMask) throws IPMIException {
        try {
            byte currentLANMode = command.getLANMode();
            this.printLANType(currentLANMode, supportedMask);
            return 0;
        }
        catch (IPMIException e) {
            MOut.G(this).println(e.getMessage());
            return 149;
        }
    }

    private int setLANMode(IPMIAMIOEMCommand command, byte supportedMask) throws IPMIException {
        try {
            if (supportedMask == 0 || (supportedMask & 1 << this.commandArgs) != 0) {
                command.setLANMode(this.commandArgs);
                MOut.G(this).println("done");
                return 0;
            }
            MOut.G(this).println("This mode is not supported\n");
            this.printLANType(this.getLANMode(command), supportedMask);
            return 153;
        }
        catch (IPMIException e) {
            MOut.G(this).println(e.getMessage());
            return 149;
        }
    }

    private int unknownMode() {
        MOut.G(this).println("Unknown parameters");
        this.printLANType((byte)-1, (byte)0);
        return 147;
    }

    private void printLANType(byte currentMode, byte supportedMask) {
        switch (currentMode) {
            case 0: {
                MOut.G(this).println("Current LAN interface is [ Dedicated ]");
                break;
            }
            case 1: {
                MOut.G(this).println("Current LAN interface is [ Shared ]");
                break;
            }
            case 2: {
                MOut.G(this).println("Current LAN interface is [ Failover ]");
                break;
            }
        }
        MOut.G(this).println("\n" + (supportedMask != 0 ? "Supported parameter " : "Parameter ") + "for setting:");
        if (supportedMask == 0 || (supportedMask & 1) != 0) {
            MOut.G(this).println("0:Dedicated");
        }
        if (supportedMask == 0 || (supportedMask & 2) != 0) {
            MOut.G(this).println("1:Shared");
        }
        if (supportedMask == 0 || (supportedMask & 4) != 0) {
            MOut.G(this).println("2:Failover");
        }
    }
}

