/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIOEMWebSettingCommand;
import com.supermicro.ipmi.text.IPMIX10OEMWebSettingAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class IPMIOEMIpCtrlAddCommand
extends IPMIX10OEMWebSettingAbstractCommand {
    private byte[] ip;
    private byte[] netmask;
    private byte policy;

    @Override
    public boolean preValidate() {
        String usage = "Usage: ipmi oem x10cfg ipCtrl add <ip address> <netmask> <policy> \n\nFor Policy:\nAccept : 1\nDrop   : 0\n";
        if (this.parameters == null || this.parameters.length != 3) {
            MOut.G(this).println(usage);
            return false;
        }
        String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
        try {
            if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[0]).matches()) {
                throw new NumberFormatException();
            }
            this.ip = ByteUtility.ipToBytes(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("ip address should be ###.###.###.###");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            if (!Pattern.compile(IPV4_REGEX).matcher(this.parameters[1]).matches()) {
                throw new NumberFormatException();
            }
            this.netmask = ByteUtility.ipToBytes(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("netmask should be ###.###.###.###");
            MOut.G(this).println(usage);
            return false;
        }
        try {
            this.policy = Byte.parseByte(this.parameters[2]);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println("policy should be number");
            MOut.G(this).println(usage);
            return false;
        }
        if (this.policy < 0 || this.policy > 1) {
            MOut.G(this).println("Policy error");
            MOut.G(this).println("Accept : 1");
            MOut.G(this).println("Drop   : 0");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] rule;
        if (!this.isX10CFGSupported()) {
            MOut.G(this).println("This device is not supported ");
            this.statusCode = 153;
            return;
        }
        if (!this.isBeforeX12()) {
            MOut.G(this).println("IPCtrl command is not supported on this device, you may try redfish ipctrl command instead.");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSWProductKeyNotActivated()) {
            return;
        }
        if (this.checkIfSystemLockdown()) {
            return;
        }
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ipmiOEMWebSettingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        int i = 0;
        for (i = 0; i < 10 && (rule = ipmiOEMWebSettingCommand.getIpCtrlRule((byte)i)) != null && rule.length == 9; ++i) {
        }
        if (i >= 10) {
            MOut.G(this).println("The ip access rule is full");
            this.statusCode = 149;
            return;
        }
        ByteBuffer target = ByteBuffer.allocate(10);
        target.put((byte)i);
        target.put(this.ip);
        target.put(this.netmask);
        target.put(this.policy);
        if (!ipmiOEMWebSettingCommand.setIpCtrl((byte)1, target.array())) {
            MOut.G(this).println("Set ip access rule failed");
            this.statusCode = 149;
            return;
        }
        MOut.G(this).println("Done");
        this.statusCode = 0;
    }
}

