/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIOEMIpv6Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanIPV6ModeCommand
extends SuperBladeCommand {
    int mode;

    @Override
    public boolean preValidate() {
        this.mode = 99;
        if (this.parameters != null && this.parameters.length == 1) {
            try {
                this.mode = Integer.parseInt(this.parameters[0]);
                if (0 <= this.mode && this.mode <= 2) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            MOut.G(this).println("Invalid parameters");
            MOut.G(this).println("Usage: ipmi lan ipv6 mode [stateless:0|stateful:1|disabled:2]");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiLanCommand.getIPProtocol() == 0) {
            MOut.G(this).println("Current protocol is IPv4 only");
            this.statusCode = 156;
            return;
        }
        IPMIOEMIpv6Command ipmioemipv6Command = new IPMIOEMIpv6Command(null);
        ipmioemipv6Command.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (0 <= this.mode && this.mode <= 2) {
            if (this.checkIfSystemLockdown()) {
                return;
            }
            int result = ipmioemipv6Command.setIPV6DHCPMode(this.mode);
            if (result == 0) {
                MOut.G(this).println("Done");
                this.statusCode = 0;
                return;
            }
            if (result == 1) {
                MOut.G(this).println("This device is not supported");
                this.statusCode = 153;
                return;
            }
            MOut.G(this).println("Fail");
            this.statusCode = 149;
            return;
        }
        switch (ipmioemipv6Command.getIPV6DHCPMode()) {
            case 0: {
                MOut.G(this).println("Current mode is Stateless");
                this.statusCode = 0;
                break;
            }
            case 1: {
                MOut.G(this).println("Current mode is Stateful");
                this.statusCode = 0;
                break;
            }
            case 2: {
                MOut.G(this).println("Current mode is Disabled");
                this.statusCode = 0;
                break;
            }
            default: {
                this.statusCode = 144;
            }
        }
    }
}

