/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class IPMIFRUNWriteCommand
extends SuperBladeCommand {
    String field;
    String[] values;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 4) {
            this.usage();
            return false;
        }
        this.field = this.parameters[1].toUpperCase();
        if (this.field.equals("BDT") || this.field.equals("BM") || this.field.equals("BPN") || this.field.equals("BS") || this.field.equals("BP") || this.field.equals("PM") || this.field.equals("PN") || this.field.equals("PPM") || this.field.equals("PV") || this.field.equals("PS") || this.field.equals("PAT")) {
            if (this.parameters[this.parameters.length - 1].equals(GlobalDefine.FRU1_EDIT_Password)) {
                if (!this.field.equals("BDT")) return true;
                if (this.parameters.length == 3 && this.parameters[2].length() == 12) {
                    return true;
                }
                MOut.G(this).println("Date/Time format error.");
                MOut.G(this).println("");
                MOut.G(this).println("Format: YYYYMMDDhhmm  ex:201007161200 (2010/07/16 12:00)");
                return false;
            }
            MOut.G(this).println("Invalid password.");
            return false;
        }
        MOut.G(this).println("Invalid field.");
        MOut.G(this).println("");
        this.usage();
        return false;
    }

    @Override
    public void runCommand() throws Exception {
        int number = 0;
        try {
            number = Integer.parseInt(this.parameters[0]);
        }
        catch (NumberFormatException ex1) {
            this.usage();
            this.statusCode = 0;
            return;
        }
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        FRUInfo fruInfo = ipmiFRUCommand.getFRUNData((byte)number);
        if (fruInfo == null) {
            MOut.G(this).print("FRU " + number + " is empty");
            this.statusCode = 0;
            return;
        }
        if (this.field.equals("BDT")) {
            byte[] bdtAry = new byte[3];
            Date dt1 = new Date();
            Date dt2 = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat();
            sdf.applyPattern("yyyyMMddHHmm");
            try {
                dt1 = sdf.parse("199601010000");
                dt2 = sdf.parse(this.parameters[2]);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            long timeValue = (dt2.getTime() - dt1.getTime()) / 60000L;
            byte[] tempAry = new byte[4];
            ByteUtility.longTo4Bytes(tempAry, 0, timeValue);
            System.arraycopy(tempAry, 0, bdtAry, 0, bdtAry.length);
            ipmiFRUCommand.frunWrite(number, this.field, bdtAry);
        } else {
            String str = "";
            if (this.parameters.length >= 4) {
                for (int i = 2; i < this.parameters.length - 1; ++i) {
                    str = i == 2 ? this.parameters[i] : str + " " + this.parameters[i];
                }
            }
            if (str.length() > 63) {
                MOut.G(this).print("Data exeed the maximum acceptable length.");
                this.statusCode = 149;
                return;
            }
            ipmiFRUCommand.frunWrite(number, this.field, str.getBytes());
        }
        fruInfo = ipmiFRUCommand.getFRUNData((byte)number);
        MOut.G(this).print(fruInfo.toReadableString());
        this.statusCode = 0;
    }

    public void usage() {
        MOut.G(this).println("Usage: fruidw <number> <field> <value> <password>");
        MOut.G(this).println("Available Fields for FRU:");
        MOut.G(this).println("  Chassis Info Fields:");
        MOut.G(this).println("    CT  :Chassis Type");
        MOut.G(this).println("    CP  :Chassis Part number");
        MOut.G(this).println("    CS  :Chassis Serial number");
        MOut.G(this).println("  Board Info Fields:");
        MOut.G(this).println("    BDT :Board Mfg. Date/Time (YYYYMMDDhhmm)");
        MOut.G(this).println("    BM  :Board Manufacturer");
        MOut.G(this).println("    BPN :Board Product Name");
        MOut.G(this).println("    BS  :Board Serial Name");
        MOut.G(this).println("    BP  :Board Part Number");
        MOut.G(this).println("  Product Info Fields:");
        MOut.G(this).println("    PM  :Product Manufacturer");
        MOut.G(this).println("    PN  :Product Name");
        MOut.G(this).println("    PPM :Product Part/Model Number");
        MOut.G(this).println("    PV  :Product Version");
        MOut.G(this).println("    PS  :Product Serial Number");
        MOut.G(this).println("    PAT :Asset Tag");
    }
}

