/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.DCPMMCommand;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.io.File;
import java.util.LinkedList;

public class DCPMMUpdateCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 2) {
            this.printUsage();
            return false;
        }
        File file = new File(this.parameters[0]);
        if (!file.isFile()) {
            MOut.G(this).println("File(" + this.parameters[0] + ") not found");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        int i;
        DCPMMCommand dcpmmCommand = new DCPMMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] bitmap = dcpmmCommand.getDCMMPresentBitmap();
        byte[] updateMap = new byte[8];
        LinkedList<DCPMMCommand.DIMM> presentDimm = new LinkedList<DCPMMCommand.DIMM>();
        for (i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((bitmap[i] & 1 << j) != 1 << j) continue;
                DCPMMCommand dCPMMCommand = dcpmmCommand;
                dCPMMCommand.getClass();
                DCPMMCommand.DIMM dimm = dCPMMCommand.new DCPMMCommand.DIMM(i, j);
                presentDimm.add(dimm);
            }
        }
        for (i = 1; i < this.parameters.length; ++i) {
            if (this.parameters[i].length() != 4 || this.parameters[i].toLowerCase().indexOf("p") != 0 || this.parameters[i].charAt(1) < '1' || this.parameters[i].charAt(1) > '4') {
                MOut.G(this).println("Invalid Dimm locater :" + this.parameters[i]);
                this.statusCode = 147;
                return;
            }
            int cpu = Integer.parseInt(this.parameters[i].substring(1, 2)) - 1;
            int channel = this.parameters[i].toUpperCase().charAt(2) - 65;
            int slot = Integer.parseInt(this.parameters[i].substring(3)) - 1;
            boolean isPresent = false;
            for (int j = 0; j < presentDimm.size(); ++j) {
                DCPMMCommand.DIMM dimm = (DCPMMCommand.DIMM)presentDimm.get(j);
                if (cpu != dimm.getCpu() || channel != dimm.getChannel() || slot != dimm.getSlot()) continue;
                this.fillMap(this.parameters[i].substring(1, 2), this.parameters[i].toUpperCase().substring(2), updateMap);
                MOut.G(this).println("Dimm " + this.parameters[i] + " is present");
                isPresent = true;
                break;
            }
            if (isPresent) continue;
            MOut.G(this).println("Dimm " + this.parameters[i] + " is not present");
        }
        LinkedList<DCPMMCommand.DIMM> updateDimm = new LinkedList<DCPMMCommand.DIMM>();
        for (int i2 = 0; i2 < 8; ++i2) {
            for (int j = 0; j < 8; ++j) {
                if ((updateMap[i2] & 1 << j) != 1 << j) continue;
                DCPMMCommand dCPMMCommand = dcpmmCommand;
                dCPMMCommand.getClass();
                DCPMMCommand.DIMM dimm = dCPMMCommand.new DCPMMCommand.DIMM(i2, j);
                updateDimm.add(dimm);
            }
        }
        if (!dcpmmCommand.setDCMMUpdateBitmap(updateMap)) {
            MOut.G(this).println("Dimm update fail, bitmap can not be updated.");
            return;
        }
        String fileName = this.parameters[0];
        MOut.G(this).println("================");
        MOut.G(this).println(" Uploading file");
        MOut.G(this).println("================");
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean result = ipmiBMCFileCommand.generalFileUpload((byte)19, fileName);
        int count = 0;
        long startTime = System.currentTimeMillis();
        MOut.G(this).println();
        MOut.G(this).println("===============");
        MOut.G(this).println(" Updating file");
        MOut.G(this).println("===============");
        block8: for (int i3 = 0; i3 < updateDimm.size(); ++i3) {
            int targetRate = 0;
            int curRate = 0;
            DCPMMCommand.DIMM dimm = (DCPMMCommand.DIMM)updateDimm.get(i3);
            boolean flag = false;
            MOut.G(this).print("Progress of " + dimm.getName() + ":");
            try {
                while (true) {
                    byte percentage = dcpmmCommand.getDCMMFirmwareUpdateStatus((byte)dimm.getCpu(), (byte)dimm.getChannel(), (byte)dimm.getSlot());
                    targetRate = percentage / 3;
                    while (curRate < targetRate) {
                        if (flag) {
                            MOut.G(this).print(">");
                        }
                        flag = true;
                        ++curRate;
                    }
                    if (percentage >= 100 && percentage != -1) {
                        MOut.G(this).println("| 100%");
                        ++count;
                        continue block8;
                    }
                    if (percentage == -1) {
                        MOut.G(this).println("Update " + dimm.getName() + " failed. Internal Error");
                    }
                    Thread.sleep(500L);
                }
            }
            catch (IPMIException e) {
                MOut.G(this).println("Update " + dimm.getName() + " failed. " + e.getMessage());
            }
        }
        MOut.G(this).println("Update " + count + " Dimm(s) successfully");
        this.printTimeString("Update Time", System.currentTimeMillis() - startTime);
        this.statusCode = 0;
    }

    public void printUsage() {
        MOut.G(this).println("Usage: dcpmm update <fileName> <DimmLocater1> [DimLocater2] ....");
        MOut.G(this).println("DimmLocater example: P1A1, P2D1");
        MOut.G(this).println("For Dimm present detail please refer dcpmm status command");
    }

    public void fillMap(String cpuIndex, String channelSlot, byte[] map) {
        int dataIndex = 0;
        int bitIndex = 0;
        if (channelSlot.contains("A1") || channelSlot.contains("E1")) {
            bitIndex = 0;
        } else if (channelSlot.contains("A2") || channelSlot.contains("E2")) {
            bitIndex = 1;
        } else if (channelSlot.contains("B1") || channelSlot.contains("F1")) {
            bitIndex = 2;
        } else if (channelSlot.contains("B2") || channelSlot.contains("F2")) {
            bitIndex = 3;
        } else if (channelSlot.contains("C1") || channelSlot.contains("G1")) {
            bitIndex = 4;
        } else if (channelSlot.contains("C2") || channelSlot.contains("G2")) {
            bitIndex = 5;
        } else if (channelSlot.contains("D1") || channelSlot.contains("H1")) {
            bitIndex = 6;
        } else if (channelSlot.contains("D2") || channelSlot.contains("H2")) {
            bitIndex = 7;
        }
        if (cpuIndex.toLowerCase().contains("p1")) {
            dataIndex = channelSlot.contains("A") || channelSlot.contains("B") || channelSlot.contains("C") || channelSlot.contains("D") ? 0 : 1;
        } else if (cpuIndex.toLowerCase().contains("p2")) {
            dataIndex = channelSlot.contains("A") || channelSlot.contains("B") || channelSlot.contains("C") || channelSlot.contains("D") ? 2 : 3;
        } else if (cpuIndex.toLowerCase().contains("p3")) {
            dataIndex = channelSlot.contains("A") || channelSlot.contains("B") || channelSlot.contains("C") || channelSlot.contains("D") ? 4 : 5;
        } else if (cpuIndex.toLowerCase().contains("p4")) {
            dataIndex = channelSlot.contains("A") || channelSlot.contains("B") || channelSlot.contains("C") || channelSlot.contains("D") ? 6 : 7;
        }
        map[dataIndex] = (byte)(map[dataIndex] | 1 << bitIndex);
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        MOut.G(this).println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }
}

