/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMITimeoutException;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.RMCPPlusSessionController;
import com.supermicro.ipmi.SessionInfo;
import com.supermicro.ipmi.lic.License;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.util.Arrays;

public class BIOSUpdateCommand
extends BIOSAbstractCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("BIOS filename is needed");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        String filename;
        File biosFile;
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (IPMIMessagingCommand.isH11GUID(guid) || IPMIMessagingCommand.isP8DTUGUID(guid) || IPMIMessagingCommand.isPOWER9GUID(guid) || IPMIMessagingCommand.isH12GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isH12SSFFGUID(guid) || IPMIMessagingCommand.isH12SSFRGUID(guid) || IPMIMessagingCommand.isH12SSGGUID(guid) || IPMIMessagingCommand.isH12DSGGUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isHGIMEZZGUID(guid) || IPMIMessagingCommand.isMicroBladeCMM64MBGUID(guid)) {
            MOut.G(this).println("This device is not supported");
            this.statusCode = 153;
            return;
        }
        if (!IPMIMessagingCommand.isBeforeX12(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isB3ST1GUID(guid) || IPMIMessagingCommand.isX13EGSGUID(guid) || IPMIMessagingCommand.isX13EGSHW1GUID(guid)) {
            MOut.G(this).println("The command is deprecated on this device. Please use 'bios rfupdate' command instead.");
            this.statusCode = 153;
            return;
        }
        IPMIBMCFileCommand ipmiBMCFileCommand = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            byte[] featureFlagArray = ipmiBMCFileCommand.generalFileDownloadbyArray((byte)10, false, false);
            if (featureFlagArray[1] >= 2 && (featureFlagArray[20] & 0x20) == 32 || featureFlagArray[1] >= 8 && (featureFlagArray[21] & 8) == 8) {
                MOut.G(this).println("This device does not support OOB BIOS update");
                this.statusCode = 153;
                return;
            }
        }
        catch (Exception featureFlagArray) {
            // empty catch block
        }
        IPMIOEMCommand ipmiOemCommand = new IPMIOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] boardID = BIOSUpdateCommand.swap(ipmiOemCommand.getBoardModelByte(), 0, 1);
        byte[] X9DRL_3F = new byte[]{6, 103};
        byte[] X11SAE = new byte[]{8, -107};
        byte[] X11SAT = new byte[]{9, 7};
        byte[] X11SSZ = new byte[]{8, -120};
        byte[] X11SBA = new byte[]{8, -111};
        byte[] X11SRL_F = new byte[]{27, 65};
        byte[] X12SAE = new byte[]{27, 108};
        if (Arrays.equals(boardID, X11SAE) || Arrays.equals(boardID, X11SAT) || Arrays.equals(boardID, X11SSZ) || Arrays.equals(boardID, X11SBA) || Arrays.equals(boardID, X11SRL_F) || Arrays.equals(boardID, X12SAE) || Arrays.equals(boardID, X9DRL_3F)) {
            MOut.G(this).println("This device does not support OOB BIOS update");
            this.statusCode = 153;
            return;
        }
        if (this.checkIfSystemLockdown()) {
            return;
        }
        String options = "";
        int optionFlag = 1;
        int sessions = 1;
        boolean multiSessionUploadEnabled = false;
        boolean longDistance = false;
        boolean debug = false;
        boolean forceReboot = false;
        boolean ignoreBiosInfo = false;
        boolean checkboardID = true;
        boolean checkEqualVersion = false;
        int delayAfterUpdate = 0;
        String replacedModelName = null;
        boolean pchReset = false;
        boolean isTwitterOEMProject = false;
        if (GlobalDefine.OOB_PROJECT_TWITTER_BYPASS) {
            isTwitterOEMProject = License.confirmIsTwitterOEMProject(this.config);
        }
        RMCPPlus rmcpPlus = ((RMCPPlusSessionController)this.sessionController).getRMCPPlus();
        SessionInfo sessionInfo = ipmiMessagingCommand.getCurrentlySessionInfo(rmcpPlus.getRmcpPlusSession().getSessionID());
        byte maxSession = sessionInfo.getNumberOfPossibleActiveSessions();
        byte currSession = sessionInfo.getNumberOfCurrentlyActiveSession();
        int availableSession = maxSession - currSession;
        if (IPMIMessagingCommand.isBeforeX12(guid)) {
            boolean isPassSWKey;
            boolean bl = isPassSWKey = !this.checkIfSWProductKeyNotActivated();
            if (!isTwitterOEMProject) {
                if (!this.checkIfSupportBIOSUpdate()) {
                    MOut.G(this).println("This device doesn't support BIOS commands");
                    MOut.G(this).println("BIOS commands support X9,X10 series montherboards");
                    this.statusCode = 153;
                    return;
                }
                if (!isPassSWKey) {
                    this.statusCode = 155;
                    return;
                }
            }
        }
        if (this.parameters.length > 1) {
            for (int i = 1; i < this.parameters.length; ++i) {
                options = options + this.parameters[i] + " ";
                if (this.parameters[i].toLowerCase().indexOf("-f") == -1 || this.parameters[i].length() != 2) continue;
                ignoreBiosInfo = true;
            }
            if (options.toLowerCase().indexOf("-forcereboot") != -1) {
                MOut.G(this).println("Option: Reboot");
                forceReboot = true;
            }
            if (options.toLowerCase().indexOf("-n") != -1) {
                MOut.G(this).println("Option: NVRAM overwrite");
                optionFlag = 0;
            } else {
                optionFlag = 1;
            }
            if (options.toLowerCase().indexOf("-mer") != -1) {
                MOut.G(this).println("Option: ME region");
                optionFlag |= 2;
            }
            if (options.toLowerCase().indexOf("-r") != -1) {
                MOut.G(this).println("Option: SMBIOS preserve");
                optionFlag |= 8;
            }
            if (options.toLowerCase().indexOf("-pch") != -1) {
                pchReset = true;
            }
            if (options.toLowerCase().indexOf("-checkequalversion") != -1) {
                checkEqualVersion = true;
            }
            if (options.toLowerCase().indexOf("-w1") != -1) {
                delayAfterUpdate = 60;
            }
            if (options.toLowerCase().indexOf("-w2") != -1) {
                delayAfterUpdate = 120;
            }
            if (options.toLowerCase().indexOf("-w3") != -1) {
                delayAfterUpdate = 180;
            }
            if (options.toLowerCase().indexOf("-w4") != -1) {
                delayAfterUpdate = 240;
            }
            if (options.toLowerCase().indexOf("-s2") != -1) {
                sessions = 2;
            }
            if (options.toLowerCase().indexOf("-s4") != -1) {
                sessions = 4;
            }
            if (options.toLowerCase().indexOf("-s8") != -1) {
                sessions = 8;
            }
            if (options.toLowerCase().indexOf("-s16") != -1) {
                sessions = 16;
            }
            if (options.toLowerCase().indexOf("-s32") != -1) {
                sessions = 32;
            }
            if (options.toLowerCase().indexOf("-d") != -1) {
                debug = true;
            }
            if (options.toLowerCase().indexOf("-crossupdate") != -1) {
                checkboardID = false;
                replacedModelName = options.substring(options.toLowerCase().indexOf("-crossupdate") + "-crossupdate".length(), options.length());
                replacedModelName = replacedModelName.trim();
            }
        }
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean isPowerOn = ipmiChassisCommand.isPowerOn();
        if ((IPMIMessagingCommand.isAST2600GUID(guid) || IPMIMessagingCommand.isX12RoTGUID(guid) || IPMIMessagingCommand.isX12RoTHW1GUID(guid) || IPMIMessagingCommand.isH12RoTGUID(guid) || IPMIMessagingCommand.isAST2600HW1GUID(guid) || IPMIMessagingCommand.isB12RoTHW1GUID(guid) || IPMIMessagingCommand.isM12GUID(guid) || IPMIMessagingCommand.isB12AST2600GUID(guid) || IPMIMessagingCommand.isB12AST2600MAC1GUID(guid) || IPMIMessagingCommand.isAST2600HW1ROT20GUID(guid) || IPMIMessagingCommand.isX12DSCGUID(guid) || IPMIMessagingCommand.isX12DGQGUID(guid) || IPMIMessagingCommand.isX12SPTGUID(guid)) && isPowerOn) {
            if (forceReboot) {
                MOut.G(this).println("Update BIOS image requries system power off");
                MOut.G(this).println("\nGoing to force shutdown the system");
                ipmiChassisCommand.powerDown();
                Thread.sleep(2000L);
                int i = 0;
                MOut.G(this).println("Detecting system power status");
                while (ipmiChassisCommand.isPowerOn()) {
                    if (i < 10) {
                        Thread.sleep(1000L);
                        ++i;
                        continue;
                    }
                    MOut.G(this).println("Can not shut down this system");
                    this.statusCode = 149;
                    return;
                }
                MOut.G(this).println("\nSystem power status: off");
                Thread.sleep(2000L);
            } else {
                MOut.G(this).println("Update BIOS image requries system power off");
                this.statusCode = 149;
                return;
            }
        }
        if (!(biosFile = new File(filename = this.parameters[0])).isFile()) {
            MOut.G(this).println("File is not found");
            this.usage();
            this.statusCode = 147;
            return;
        }
        try {
            this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
            int chunksize = 1024;
            try {
                multiSessionUploadEnabled = this.ipmiX9BIOSOEMCommand.ifMultiSessionUploadSupported();
            }
            catch (Exception exception) {
                // empty catch block
            }
            int time = this.ipmiX9BIOSOEMCommand.speedTest();
            if (time > 50) {
                longDistance = true;
            }
            if (sessions == 1) {
                if (longDistance && multiSessionUploadEnabled) {
                    if (availableSession > 32) {
                        sessions = 8;
                    } else if (availableSession > 16) {
                        sessions = 8;
                    } else if (availableSession > 8) {
                        sessions = 8;
                    } else if (availableSession > 4) {
                        sessions = 4;
                    } else if (availableSession > 2) {
                        sessions = 2;
                    }
                }
            } else {
                if (sessions > availableSession) {
                    sessions = 1;
                }
                if (!multiSessionUploadEnabled) {
                    sessions = 1;
                }
            }
            if (options.toLowerCase().indexOf("-s1") != -1) {
                sessions = 1;
            }
            if (debug) {
                MOut.G(this).println("Multi Session Upload Enabled ? " + multiSessionUploadEnabled);
                MOut.G(this).println("Speed             = " + time + "ms");
                MOut.G(this).println("Available Session = " + availableSession);
                MOut.G(this).println("Use Session       = " + sessions + " session(s)");
            }
            this.ipmiX9BIOSOEMCommand.setMOut(MOut.G(this));
            this.ipmiX9BIOSOEMCommand.replacedModelName = replacedModelName;
            this.statusCode = this.ipmiX9BIOSOEMCommand.flashBIOSNew(chunksize, optionFlag, filename, sessions, forceReboot, ignoreBiosInfo, pchReset, checkboardID, checkEqualVersion, delayAfterUpdate) ? 0 : 149;
        }
        catch (IPMITimeoutException ie) {
            MOut.G(this).println(ie.getMessage());
            this.statusCode = 145;
        }
        catch (IPMIException ie) {
            MOut.G(this).println(ie.getMessage());
            this.statusCode = 82;
        }
        catch (Exception ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 148;
        }
    }

    public static final <T> byte[] swap(byte[] array, int first, int second) {
        byte b = array[first];
        array[first] = array[second];
        array[second] = b;
        return array;
    }

    public void usage() {
        MOut.G(this).println("Usage: bios update <filename> [options...]");
        MOut.G(this).println("Options: ");
        MOut.G(this).println("           -N: Program NVRAM");
        MOut.G(this).println("           -R: Preserve SMBIOS");
        MOut.G(this).println("         -MER: Program ME Firmware ME Region");
        MOut.G(this).println(" -FORCEREBOOT: Force to reboot after BIOS update");
        MOut.G(this).println("");
        MOut.G(this).println("Example:");
        MOut.G(this).println("bios update X10.bin -N -R -MER");
        MOut.G(this).println("");
        MOut.G(this).println("* This function needs to activate Node product key");
    }
}

