/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.task.BTask;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.task.BTaskVariable;
import com.supermicro.ipmi.task.mbtauto.MBTConfig;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandIncompleteException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MOutFactory;
import com.supermicro.ipmi.text.Parser;
import java.util.ArrayList;

public class BTaskFlow
extends BTask {
    private int loginRetryIndex = 1;
    private int loginRetryCount = 0;
    private String[][] cmdStringArray;
    static final int LOGIN_RETRY_COUNT_LIMIT = 3;

    public BTaskFlow(String ip, String id, String pw, String[][] cmdStrArray) {
        this.ip = ip;
        this.id = id;
        this.pw = pw;
        this.cmdStringArray = cmdStrArray;
    }

    public BTaskFlow(String ip, String[][] cmdStrArray, ArrayList<MBTConfig.IPMIAccount> accounts) {
        this.ip = ip;
        this.id = accounts.get(0).getUsername();
        this.pw = accounts.get(0).getPassword();
        this.ipmiAccounts = accounts;
        this.cmdStringArray = cmdStrArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTask() {
        Command command = null;
        this.parser = new Parser();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.pw);
        this.aMout = MOutFactory.createMOutInstanceWtihBufferOutput();
        MOut.addMOut(this.parser, this.aMout);
        for (int i = 0; i < this.cmdStringArray.length; ++i) {
            this.replaceVariable(this.cmdStringArray[i]);
            this.cmdString = this.cmdStringArray[i];
            this.aMout.println("\n" + (i + 1) + " >" + this.getCommandString());
            try {
                command = this.parser.parse(this.parser.getArgumentRoot(), this.cmdStringArray[i]);
            }
            catch (CommandIncompleteException commandIncompleteException) {
                // empty catch block
            }
            if (command == null) {
                this.exitCode = 180;
                break;
            }
            if (!command.isSupportBackgroundModeForTaskRunCommand) {
                this.exitCode = 154;
                break;
            }
            try {
                int statusCode = 144;
                do {
                    command.setConfig(config);
                    command.setOriginalParser(this.parser);
                    try {
                        command.execute();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        statusCode = command.getStatusCode();
                    }
                } while (statusCode == 146 && this.retryLogin(config));
                this.aMout.println("[Exit Code =" + statusCode + "]");
                if (statusCode == 0) continue;
            }
            catch (Exception ex) {
                MOut.G(command).println(ex.getMessage());
            }
            break;
        }
    }

    public void replaceVariable(String[] cmdString) {
        BTaskVariable bTaskVariable = BTaskManager.getInstance().getBTaskVariable(this.taskID);
        if (bTaskVariable == null) {
            return;
        }
        String[] variables = bTaskVariable.getNames();
        for (int i = 0; i < cmdString.length; ++i) {
            for (int j = 0; j < variables.length; ++j) {
                if (cmdString[i].indexOf("$DATETIME") != -1) {
                    cmdString[i] = cmdString[i].replace("$DATETIME", ByteUtility.getDateTimeShortString());
                }
                if (cmdString[i].indexOf("$DATE") != -1) {
                    cmdString[i] = cmdString[i].replace("$DATE", ByteUtility.getDateShortString());
                }
                if (cmdString[i].indexOf("$TIME") != -1) {
                    cmdString[i] = cmdString[i].replace("$TIME", ByteUtility.getTimeShortString());
                }
                if (cmdString[i].indexOf(variables[j]) == -1) continue;
                cmdString[i] = cmdString[i].replace(variables[j], bTaskVariable.get(variables[j]));
            }
        }
    }

    @Override
    public String getMessageDisplay(boolean tag) {
        String content = "No Message";
        if (this.getMOut() != null) {
            content = this.getMOut().getBufferContent();
        }
        String result = "";
        if (tag) {
            result = "TaskID : " + this.taskID + " [" + this.getStateString() + "]\n";
        }
        result = result + content + "\n";
        if (tag) {
            result = result + "TaskID : " + this.taskID + " [" + this.getStateString() + "]\n";
        }
        return result;
    }

    public static void main(String[] args) {
        String a = "$AAA_CC_DDD_BBBB";
        System.out.println(a.replace("$AAA", "TODAY"));
    }

    private boolean retryLogin(IPMIInterfaceConfig config) {
        if (this.ipmiAccounts != null && this.ipmiAccounts.size() > 0) {
            if (this.loginRetryIndex <= this.ipmiAccounts.size() && this.loginRetryCount < 3) {
                if (this.loginRetryIndex == this.ipmiAccounts.size()) {
                    ++this.loginRetryCount;
                    this.loginRetryIndex = 0;
                }
                config.setUserName(((MBTConfig.IPMIAccount)this.ipmiAccounts.get(this.loginRetryIndex)).getUsername());
                config.setPassword(((MBTConfig.IPMIAccount)this.ipmiAccounts.get(this.loginRetryIndex)).getPassword());
                this.id = ((MBTConfig.IPMIAccount)this.ipmiAccounts.get(this.loginRetryIndex)).getUsername();
                this.pw = ((MBTConfig.IPMIAccount)this.ipmiAccounts.get(this.loginRetryIndex)).getPassword();
                ++this.loginRetryIndex;
                return true;
            }
            this.loginRetryIndex = 0;
            return false;
        }
        return false;
    }
}

