/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.smbios;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.smbios.TypeStruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StorageDevice
extends TypeStruct {
    byte[] portDesign;
    byte[] deviceIndex;
    byte[] connectorType;
    byte[] deviceProtocol;
    byte[] deviceType;
    byte[] deviceCapacity;
    byte[] deviceRPM;
    byte[] deviceModel;
    byte[] deviceSerial;
    byte[] classCode;
    byte[] vendorId;
    byte[] deviceId;
    byte[] subVendorId;
    byte[] subDeviceId;
    byte[] fwVersion;

    public StorageDevice(byte[] dataByte) {
        super(dataByte);
        this.portDesign = this.getTypeLength(this.BYTE);
        this.deviceIndex = this.getTypeLength(this.BYTE);
        this.connectorType = this.getTypeLength(this.BYTE);
        this.deviceProtocol = this.getTypeLength(this.BYTE);
        this.deviceType = this.getTypeLength(this.BYTE);
        this.deviceCapacity = this.getTypeLength(this.DWORD);
        this.deviceRPM = this.getTypeLength(this.WORD);
        this.deviceModel = this.getTypeLength(this.BYTE);
        this.deviceSerial = this.getTypeLength(this.BYTE);
        this.classCode = this.getTypeLength(this.BYTE);
        this.vendorId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.vendorId);
        this.deviceId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.deviceId);
        this.subVendorId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.subVendorId);
        this.subDeviceId = this.getTypeLength(this.WORD);
        ArrayUtils.reverse(this.subDeviceId);
        this.fwVersion = this.getTypeLength(this.BYTE);
        this.strFieldCount = 6;
    }

    int getPortDesign() {
        return this.portDesign[0];
    }

    int getDeviceIndex() {
        return this.deviceIndex[0] & 0xFF;
    }

    String getConnectorType() {
        switch (this.connectorType[0]) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "SATA";
            }
            case 2: {
                return "SAS";
            }
            case 3: {
                return "PCIe";
            }
            case 4: {
                return "m.2";
            }
            case 5: {
                return "USB";
            }
            case 6: {
                return "U.2";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.connectorType[0]) + ")";
    }

    String getDeviceProtocol() {
        switch (this.deviceProtocol[0]) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "IDE";
            }
            case 2: {
                return "AHCI";
            }
            case 3: {
                return "NVMe";
            }
            case 4: {
                return "USB";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.deviceProtocol[0]) + ")";
    }

    String getDeviceType() {
        switch (this.deviceType[0]) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "HDD";
            }
            case 2: {
                return "SSD";
            }
            case 3: {
                return "Optical \u2013 DVD";
            }
            case 4: {
                return "Optical \u2013 Blue Ray";
            }
            case 5: {
                return "USB";
            }
        }
        return "Unknown (0x" + ByteUtility.byteToHex(this.deviceType[0]) + ")";
    }

    int getDeviceCapacity() {
        return ByteUtility.fourBytesToIntByLSBFirst(this.deviceCapacity);
    }

    int getDeviceRPM() {
        return ByteUtility.twoBytesToIntLSB(this.deviceRPM);
    }

    int getDeviceModel() {
        return this.deviceModel[0];
    }

    int getDeviceSerial() {
        return this.deviceSerial[0];
    }

    byte getClassCode() {
        return this.classCode[0];
    }

    String getVendorId() {
        return ByteUtility.bytesToHexNoSpace(this.vendorId);
    }

    String getDeviceId() {
        return ByteUtility.bytesToHexNoSpace(this.deviceId);
    }

    String getSubVendorId() {
        return ByteUtility.bytesToHexNoSpace(this.subVendorId);
    }

    String getSubDeviceId() {
        return ByteUtility.bytesToHexNoSpace(this.subDeviceId);
    }

    int getFWVersion() {
        return this.fwVersion[0];
    }

    public String getStorageConnectorType() {
        return this.getConnectorType();
    }

    public String getStorageDeviceProtocol() {
        return this.getDeviceProtocol();
    }

    public int getStorageDeviceCapacity() {
        return this.getDeviceCapacity();
    }

    public int getStorageDeviceRPM() {
        return this.getDeviceRPM();
    }

    @Override
    public String toFormatedString() {
        String format = " %-30s | %30s \n";
        StringBuffer fStr = new StringBuffer();
        fStr.append(String.format(format, "Type", (this.type & 0xFF) + " (0x" + this.getType() + ")"));
        fStr.append(String.format(format, "Structure", "Storage Device Information"));
        if (this.debug) {
            fStr.append(String.format(format, "Length", (this.length & 0xFF) + " (0x" + this.getLength() + ")"));
            fStr.append(String.format(format, "Handle", "0x" + this.getHandle()));
        }
        fStr.append(String.format(format, "Port Designation", this.strField[this.getPortDesign()] != null ? this.strField[this.getPortDesign()] : "N/A"));
        fStr.append(String.format(format, "Device Index", this.getDeviceIndex()));
        fStr.append(String.format(format, "Connector Type", this.getConnectorType()));
        fStr.append(String.format(format, "Device Protocol", this.getDeviceProtocol()));
        fStr.append(String.format(format, "Device Type", this.getDeviceType()));
        fStr.append(String.format(format, "Device Capacity", this.getDeviceCapacity() + " GB"));
        fStr.append(String.format(format, "Device RPM", this.getDeviceRPM() != 0 ? this.getDeviceRPM() + " RPM" : "N/A"));
        fStr.append(String.format(format, "Device Model", this.strField[this.getDeviceModel()] != null ? this.strField[this.getDeviceModel()] : "N/A"));
        fStr.append(String.format(format, "Device Serial", this.strField[this.getDeviceSerial()] != null ? this.strField[this.getDeviceSerial()] : "N/A"));
        fStr.append(String.format(format, "Class Code", (this.getClassCode() & 0xFF) + " (0x" + ByteUtility.byteToHex(this.getClassCode()) + ")"));
        fStr.append(String.format(format, "Vendor ID", "0x" + this.getVendorId()));
        fStr.append(String.format(format, "Device ID", "0x" + this.getDeviceId()));
        fStr.append(String.format(format, "SubVendor ID", "0x" + this.getSubVendorId()));
        fStr.append(String.format(format, "SubDevice ID", "0x" + this.getSubDeviceId()));
        fStr.append(String.format(format, "Firmware Version", StringUtils.isNotBlank(this.strField[this.getFWVersion()]) ? this.strField[this.getFWVersion()] : "N/A"));
        fStr.append(String.format("\n", new Object[0]));
        return fStr.toString();
    }
}

