/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;
import com.supermicro.redfish.RedfishHttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CommandForGettingSELRecords
extends Command {
    @Override
    public Result execute(Host host) {
        if (this.isBeforeX12(host.config)) {
            SELInfo selInfo;
            ArrayList list;
            IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
            IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
            IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
            Result result = new Result(this, host);
            ISessionController sessionController = IPMIVersion.getSessionController(host.config);
            if (sessionController == null) {
                result.booleanResult = false;
                result.description = L.t("group.Cannot_connect_to_the_host");
                return result;
            }
            IPMINetworkInterface rmcp = sessionController.startup(host.config);
            if (rmcp == null) {
                result.booleanResult = false;
                result.description = L.t("group.Cannot_login_to") + host.getIp();
                return result;
            }
            ipmiSELCommand.setIPMIInterface(rmcp);
            ipmiSDRCommand.setIPMIInterface(rmcp);
            ipmiOEMCommand.setIPMIInterface(rmcp);
            byte[] aProductID = ipmiOEMCommand.getProductID();
            if (aProductID == null) {
                aProductID = new byte[2];
            }
            host.productID = aProductID;
            if (host.sdrRecords == null) {
                host.sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
                host.sdrRecords = ipmiSDRCommand.getSDRs(host.sdrInfo.getRecordCount());
            }
            if ((list = ipmiSELCommand.getSELEntries((selInfo = ipmiSELCommand.getSELInfoModal()).getLogEntries())).size() != 0) {
                for (SELRecord sELRecord : list) {
                }
            } else {
                MessageCenter.getInstance().put(L.t("group.Get_SEL_Entry_failed"));
            }
            if (list != null) {
                result.booleanResult = true;
                result.description = result.description + "ok";
                host.selRecords = list;
            } else {
                result.booleanResult = false;
                result.description = L.t("group.Get_SEL_Info_failed");
            }
            host.isBeforeX12 = true;
            sessionController.closeSession();
            return result;
        }
        Result result = new Result(this, host);
        RedfishHttpUtils utils = new RedfishHttpUtils();
        ArrayList output = new ArrayList();
        String url = "https://" + host.config.getIp() + "/redfish/v1/Systems/1/LogServices/Log1/Entries/";
        try {
            utils.sendRedfishGet(host.config, url);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            List<HashMap<String, String>> entryList = utils.getEntryList();
            for (int index = 0; index < entryList.size(); ++index) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(host.getHostname());
                arrayList.add(host.getIp());
                arrayList.add(entryList.get(index).get("Severity"));
                arrayList.add(utils.convertDatetimeFormat(entryList.get(index).get("Created")));
                arrayList.add(entryList.get(index).containsKey("SensorType") ? entryList.get(index).get("SensorType") : entryList.get(index).get("OemSensorType"));
                arrayList.add("");
                arrayList.add(entryList.get(index).get("Message"));
                output.add(arrayList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.booleanResult = true;
        result.description = result.description + "ok";
        host.selRecords = output;
        host.isBeforeX12 = false;
        return result;
    }

    public String toString() {
        return "Get SEL Records";
    }

    private boolean isBeforeX12(IPMIInterfaceConfig ipmiInterfaceConfig) {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithRetry(ipmiInterfaceConfig, ipmiMessagingCommand);
        if (null != sessionController) {
            byte[] guid = ipmiMessagingCommand.getSystemGUID();
            boolean isBeforeX12 = IPMIMessagingCommand.isBeforeX12(guid);
            sessionController.closeSession();
            sessionController = null;
            return isBeforeX12;
        }
        return false;
    }
}

