/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForDisableUIDLED
extends Command {
    @Override
    public Result execute(Host host) {
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        boolean bResult = ipmiOEMCommand.enableUIDLED();
        if (bResult) {
            result.booleanResult = true;
            result.description = "UID LED disabled";
        } else {
            result.booleanResult = false;
            result.description = "This device doesn't support disable UID LED";
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Disable UID LED";
    }
}

