/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ServerInfo;
import com.supermicro.ipmi.UDPSocket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;

public class UDPProxy {
    int port;
    UDPSocket server;
    HashMap ipPortTable = new HashMap();
    HashMap clientIPToSocket = new HashMap();
    HashMap socketToClientIP = new HashMap();
    ArrayList serverInfos;

    public UDPProxy(int port) {
        this.port = port;
        this.serverInfos = new ArrayList();
        this.loadServerInfo();
    }

    public boolean start() {
        try {
            this.server = new UDPSocket("127.0.0.1", this.port, 0, 0);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        this.server.addObserver(new UDPSocketServerHandler(this));
        boolean result = this.server.startListen(this.port);
        return result;
    }

    public static void main(String[] args) {
        UDPProxy proxy;
        boolean result;
        int port = 6666;
        if (args.length != 0 && args[0] != null) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException ex) {
                port = 6666;
            }
        }
        if (result = (proxy = new UDPProxy(port)).start()) {
            System.out.println("Supermicro UDPProxy for IPMI V1.0 Build 060222");
            System.out.println("IPMIUDPProxy Server listen on port " + proxy.port);
        } else {
            System.out.println("Can't start IPMIUDPProxy Server");
        }
    }

    public boolean sendUDP(DatagramSocket socket, String toIP, int toPort, byte[] data) {
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(toIP);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            return false;
        }
        DatagramPacket dp = new DatagramPacket(data, data.length, ia, toPort);
        try {
            socket.send(dp);
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
            return false;
        }
        return true;
    }

    public String getDateTime() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss EEE");
        return f.format(Calendar.getInstance().getTime());
    }

    public void loadServerInfo() {
        File f = new File("server.properties");
        String timeoutString = "";
        String retryString = "";
        if (f.exists()) {
            try {
                FileReader fin = new FileReader("server.properties");
                BufferedReader br = new BufferedReader(fin);
                String raw = null;
                while ((raw = br.readLine()) != null && raw.length() != 0) {
                    ServerInfo serverInfo = ServerInfo.fromRaw(raw);
                    this.serverInfos.add(serverInfo);
                    System.out.println(serverInfo.toFormatString());
                }
                fin.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Load server.properties ok");
        } else {
            System.out.println("Server.properties don't exist in the folder.");
        }
    }

    public void saveServerInfo() {
        try {
            FileWriter outs = new FileWriter("server.properties", false);
            for (ServerInfo item : this.serverInfos) {
                outs.write("" + item.toString() + "\n");
            }
            outs.close();
        }
        catch (IOException ex) {
            System.out.println("--- error to write log[server.properties]! ---");
        }
    }

    class UDPSocketServerHandler
    implements Observer {
        UDPProxy udpProxy;

        public UDPSocketServerHandler(UDPProxy udpProxy) {
            this.udpProxy = udpProxy;
        }

        @Override
        public void update(Observable o, Object arg) {
            byte[] received = (byte[])arg;
            if (received[0] == 49) {
                this.createUDPSocket(o, received);
            } else if (received[0] == 48) {
                this.disposeUDPSocket(o, received);
            } else if (received[0] == 50) {
                this.receiveServersInfo(o, received);
            } else if (received[0] == 51) {
                this.getNumberOfServersInfo(o, received);
            } else if (received[0] == 52) {
                this.getServerByID(o, received);
            } else if (received[0] == 53) {
                this.giveMeZero(o, received);
            } else {
                this.forwardUDPPacket(o, received);
            }
        }

        private void createUDPSocket(Observable o, byte[] received) throws NumberFormatException {
            String data = new String(received);
            StringTokenizer st = new StringTokenizer(data, ",");
            st.nextToken();
            String toIP = st.nextToken();
            int toPort = Integer.parseInt(st.nextToken());
            UDPSocket socket = null;
            try {
                socket = new UDPSocket(toIP, toPort, 0, 0);
                socket.addObserver(new UDPSocketHandler(this.udpProxy));
                socket.startListen();
            }
            catch (UnknownHostException ex) {
                System.out.println(UDPProxy.this.getDateTime() + ":Cannot create a UDPSocket");
            }
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            String from = fromIP + ":" + fromPort;
            String to = toIP + ":" + toPort;
            this.udpProxy.ipPortTable.put(from, to);
            this.udpProxy.clientIPToSocket.put(from, socket);
            this.udpProxy.socketToClientIP.put(socket, from);
            this.udpProxy.sendUDP(this.udpProxy.server.socket, fromIP, fromPort, "0".getBytes());
            System.out.println(UDPProxy.this.getDateTime() + ": [" + from + " --> " + to + "]");
        }

        private void disposeUDPSocket(Observable o, byte[] received) throws NumberFormatException {
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            String from = fromIP + ":" + fromPort;
            UDPSocket udpSocket = (UDPSocket)this.udpProxy.clientIPToSocket.get(from);
            if (udpSocket != null) {
                udpSocket.stopListen();
            }
            this.udpProxy.ipPortTable.remove(from);
            this.udpProxy.clientIPToSocket.remove(from);
            this.udpProxy.socketToClientIP.remove(udpSocket);
            this.udpProxy.sendUDP(this.udpProxy.server.socket, fromIP, fromPort, "0".getBytes());
            System.out.println(UDPProxy.this.getDateTime() + ":" + from + " --> removed");
        }

        private void forwardUDPPacket(Observable o, byte[] received) throws NumberFormatException {
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            String from = fromIP + ":" + fromPort;
            UDPSocket udpSocket = (UDPSocket)this.udpProxy.clientIPToSocket.get(from);
            if (udpSocket != null) {
                udpSocket.dropPacket(received);
            }
            System.out.println(UDPProxy.this.getDateTime() + ": [" + from + " --> data --> " + UDPProxy.this.ipPortTable.get(from) + "]");
        }

        private void receiveServersInfo(Observable o, byte[] received) {
            String data = new String(received);
            ServerInfo serverInfo = ServerInfo.fromRaw(data.substring(data.indexOf(","), data.length()));
            System.out.println("add:" + serverInfo.toFormatString());
            UDPProxy.this.serverInfos.add(serverInfo);
            UDPProxy.this.saveServerInfo();
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            this.udpProxy.sendUDP(this.udpProxy.server.socket, fromIP, fromPort, "0".getBytes());
        }

        private void getNumberOfServersInfo(Observable o, byte[] received) {
            String numberServers = Integer.toString(UDPProxy.this.serverInfos.size());
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            this.udpProxy.sendUDP(this.udpProxy.server.socket, fromIP, fromPort, numberServers.getBytes());
        }

        private void getServerByID(Observable o, byte[] received) {
            String data = new String(received);
            StringTokenizer st = new StringTokenizer(data, ",");
            st.nextToken();
            int id = Integer.parseInt(st.nextToken());
            ServerInfo serverInfo = (ServerInfo)UDPProxy.this.serverInfos.get(id);
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            this.udpProxy.sendUDP(this.udpProxy.server.socket, fromIP, fromPort, serverInfo.toString().getBytes());
        }

        private void giveMeZero(Observable o, byte[] received) {
            byte[] reply = new byte[]{0};
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            this.udpProxy.sendUDP(this.udpProxy.server.socket, fromIP, fromPort, reply);
        }
    }

    class UDPSocketHandler
    implements Observer {
        UDPProxy udpProxy;

        public UDPSocketHandler(UDPProxy udpProxy) {
            this.udpProxy = udpProxy;
        }

        @Override
        public void update(Observable o, Object arg) {
            byte[] received = (byte[])arg;
            this.forwardUDPPacket(o, received);
        }

        private void forwardUDPPacket(Observable o, byte[] received) throws NumberFormatException {
            UDPSocket udpSocket = (UDPSocket)o;
            String to = (String)this.udpProxy.socketToClientIP.get(udpSocket);
            StringTokenizer st = new StringTokenizer(to, ":");
            String toIP = st.nextToken();
            String toPortStr = st.nextToken();
            int toPort = Integer.parseInt(toPortStr);
            UDPProxy.this.sendUDP(this.udpProxy.server.socket, toIP, toPort, received);
            String fromIP = ((UDPSocket)o).udpDaemon.receivePacket.getAddress().getHostAddress();
            int fromPort = ((UDPSocket)o).udpDaemon.receivePacket.getPort();
            String from = fromIP + ":" + fromPort;
            System.out.println(UDPProxy.this.getDateTime() + ": [" + to + " <-- data <-- " + from + "]");
        }
    }
}

