/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class SystemLockdownCommand
extends IPMICommand {
    public static final byte SYSTEMUNLOCK = 0;
    public static final byte SYSTEMLOCK = 1;

    public SystemLockdownCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public void CMD_______________________() {
    }

    public IPMIMessage getSystemInfoParametersCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{53, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSystemInfoParametersCommand(byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{53, 1, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void API_______________________() {
    }

    public boolean isSystemLocked() {
        IPMIMessage resMessage = this.getSystemInfoParametersCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            return false;
        }
        return false;
    }

    public boolean setSystemLocked(byte status) throws Exception {
        IPMIMessage resMessage = this.setSystemInfoParametersCommand(status);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new Exception("get system lockdown status failed");
    }
}

