/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.MOut;
import java.util.ArrayList;

public class SessionControllerFactory {
    public static ISessionController createSessionController(IPMIInterfaceConfig config, IPMICommand ipmiCommand) {
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            MessageCenter.getInstance().put("Can't connect to " + config.getIp());
            return null;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            if (sessionController != null) {
                sessionController.closeSession();
            }
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiCommand.setIPMIInterface(rmcp);
        return sessionController;
    }

    public static ISessionController createSessionControllerEx(IPMIInterfaceConfig config, IPMICommand ipmiCommand) throws IPMIException {
        double startTime = System.currentTimeMillis();
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            if (GlobalDefine.OOB_PROJECT && !GlobalDefine.OOB_PROJECT_TOOLD) {
                MOut.G().println("");
                MOut.G().println("Network connection failed after retry connection for " + ((double)System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
            }
            throw new IPMIException("Can't connect to " + config.getIp());
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            if (sessionController != null) {
                sessionController.closeSession();
            }
            throw new IPMIException("Can't login to " + config.getIp());
        }
        ipmiCommand.setIPMIInterface(rmcp);
        return sessionController;
    }

    public static ISessionController createSessionControllerWithRetry(IPMIInterfaceConfig config, IPMICommand ipmiCommand) {
        return SessionControllerFactory.createSessionControllerWithRetry(config, ipmiCommand, 5);
    }

    public static ISessionController createSessionControllerWithRetry(IPMIInterfaceConfig config, IPMICommand ipmiCommand, int retryCount) {
        ISessionController sessionController = null;
        IPMINetworkInterface interf = null;
        do {
            if ((sessionController = IPMIVersion.getSessionController(config)) != null) {
                interf = sessionController.startup(config);
                if (interf != null) {
                    ipmiCommand.setIPMIInterface(interf);
                    return sessionController;
                }
                sessionController.closeSession();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (retryCount-- > 0);
        if (sessionController == null) {
            MessageCenter.getInstance().put("Can't connect to " + config.getIp());
        }
        if (interf == null) {
            MessageCenter.getInstance().put("Network error");
        }
        return null;
    }

    public static ISessionController createSessionController(IPMIInterfaceConfig config, ArrayList ipmiCommands) {
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            MessageCenter.getInstance().put("Can't connect to " + config.getIp());
            return null;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            if (sessionController != null) {
                sessionController.closeSession();
            }
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        for (Object item : ipmiCommands) {
            if (!(item instanceof IPMICommand)) continue;
            ((IPMICommand)item).setIPMIInterface(rmcp);
        }
        return sessionController;
    }

    public static ISessionController createSessionControllerWithAutomaticllyCheckPrivilege(IPMIInterfaceConfig config, IPMICommand ipmiCommand) {
        IPMINetworkInterface rmcp = null;
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            MessageCenter.getInstance().put("Can't connect to " + config.getIp());
            return null;
        }
        for (int i = 4; i >= 2; --i) {
            config.setPrivilege((byte)i);
            rmcp = sessionController.startup(config);
            if (rmcp == null) continue;
            MessageCenter.getInstance().put("RMCP Login successfully");
            break;
        }
        if (rmcp == null) {
            if (sessionController != null) {
                sessionController.closeSession();
            }
            return null;
        }
        ipmiCommand.setIPMIInterface(rmcp);
        return sessionController;
    }

    public static ISessionController createSessionControllerWithAutomaticllyCheckPrivilegeEx(IPMIInterfaceConfig config, IPMICommand ipmiCommand) throws IPMIException {
        double startTime = System.currentTimeMillis();
        IPMINetworkInterface rmcp = null;
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            if (GlobalDefine.OOB_PROJECT && !GlobalDefine.OOB_PROJECT_TOOLD) {
                MOut.G().println("");
                MOut.G().println("Network connection failed after retry connection for " + ((double)System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
            }
            throw new IPMIException("Can't connect to " + config.getIp());
        }
        for (int retry = 10; retry > 0 && rmcp == null; --retry) {
            for (int i = 4; i >= 2; --i) {
                config.setPrivilege((byte)i);
                rmcp = sessionController.startup(config);
                if (rmcp == null) continue;
                MessageCenter.getInstance().put("RMCP Login successfully");
                break;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (rmcp == null) {
            rmcp = sessionController.startup(config);
            if (sessionController != null) {
                sessionController.closeSession();
            }
            throw new IPMIException("Can't login to " + config.getIp());
        }
        ipmiCommand.setIPMIInterface(rmcp);
        return sessionController;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        config.setIp("192.168.12.157");
        config.setUserName("oper");
        config.setPassword("oper");
        SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiGlobalCommand);
        if (ipmiGlobalCommand.getIPMIInterface() != null) {
            System.out.println(ipmiGlobalCommand.getDevice().toString());
        } else {
            System.out.println("ip or password error");
        }
    }
}

