/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

public class MidplaneSystemInfo {
    byte signatureCode;
    byte[] Systemlength = new byte[4];
    byte[] modelNumber = new byte[21];
    byte[] serialNumber = new byte[32];
    byte sgpio;
    byte zone;
    byte[] reserved = new byte[31];
    byte checkSum;

    public byte[] toRaw() {
        this.signatureCode = (byte)-90;
        this.Systemlength[0] = 0;
        this.Systemlength[1] = 0;
        this.Systemlength[2] = 0;
        this.Systemlength[3] = 92;
        byte[] raw = new byte[92];
        int index = 0;
        raw[index] = this.signatureCode;
        System.arraycopy(this.Systemlength, 0, raw, ++index, 4);
        System.arraycopy(this.modelNumber, 0, raw, index += 4, 21);
        System.arraycopy(this.serialNumber, 0, raw, index += 21, 32);
        raw[index += 32] = this.sgpio;
        raw[++index] = this.zone;
        System.arraycopy(this.reserved, 0, raw, ++index, 31);
        index += 31;
        byte sum = 0;
        for (int i = 0; i < raw.length - 1; ++i) {
            sum = (byte)(sum + raw[i]);
        }
        raw[raw.length - 1] = -sum;
        return raw;
    }

    public void fromRaw(byte[] raw) {
        int index = 0;
        this.signatureCode = raw[index];
        System.arraycopy(raw, ++index, this.Systemlength, 0, 4);
        System.arraycopy(raw, index += 4, this.modelNumber, 0, 21);
        System.arraycopy(raw, index += 21, this.serialNumber, 0, 32);
        this.sgpio = raw[index += 32];
        this.zone = raw[++index];
        System.arraycopy(raw, ++index, this.reserved, 0, 31);
        this.checkSum = raw[index += 31];
    }

    public byte getSystemSignatureCode() {
        return this.signatureCode;
    }

    public String getSystemModelNumber() {
        return new String(this.modelNumber);
    }

    public String getSystemSerialNumber() {
        return new String(this.serialNumber);
    }

    public byte getSGPIOMode() {
        return this.sgpio;
    }

    public byte getZoneConfig() {
        return this.zone;
    }

    public byte[] getReservedByte() {
        return this.reserved;
    }

    public byte getChecksum() {
        return this.checkSum;
    }

    public void setSystemSignatureCode(byte systemSignatureCode) {
        this.signatureCode = systemSignatureCode;
    }

    public void setSystemModelNumber(String model) {
        byte[] b = model.getBytes();
        for (int i = 0; i < this.modelNumber.length; ++i) {
            this.modelNumber[i] = 0;
        }
        System.arraycopy(b, 0, this.modelNumber, 0, b.length);
    }

    public void setSystemSerialNumber(String serial) {
        byte[] b = serial.getBytes();
        for (int i = 0; i < this.serialNumber.length; ++i) {
            this.serialNumber[i] = 0;
        }
        System.arraycopy(b, 0, this.serialNumber, 0, b.length);
    }

    public void setSGPIOMode(byte input) {
        this.sgpio = input;
    }

    public void setZoneConfig(byte input) {
        this.zone = input;
    }

    public void setReservedByte(byte[] input) {
        for (int i = 0; i < this.reserved.length; ++i) {
            this.reserved[i] = 0;
        }
        System.arraycopy(input, 0, this.reserved, 0, input.length);
    }
}

