/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import java.util.StringTokenizer;

public class IPMIOEMWebSettingCommand
extends IPMICommand {
    public static byte VM_PARAM_HOST = 0;
    public static byte VM_PARAM_PATH = 1;
    public static byte VM_PARAM_USERNAME = (byte)2;
    public static byte VM_PARAM_PASSWORD = (byte)3;

    public IPMIOEMWebSettingCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void CMD____________() {
    }

    public IPMIMessage getNTPDateTimeCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setNTPDateTimeCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 1;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getActiveDirectoryCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getActiveDirectoryRoleGroupCommand(byte param, byte index) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, 0, param, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setActiveDirectoryCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 2;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDDNSCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDDNSCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 4;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getRADIUSCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{5, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setRADIUSCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 5;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSMTPCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSMTPCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 6;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getLDAPCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{8, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setLDAPCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 8;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIPV6Command(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIPV6Command(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + value.length];
        data[0] = 9;
        data[1] = 1;
        data[2] = param;
        System.arraycopy(value, 0, data, 3, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getDNSServerCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, 0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setDNSServerCommand(byte param, byte[] value, byte operation) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4 + value.length];
        data[0] = 10;
        data[1] = 1;
        data[2] = param;
        data[3] = operation;
        System.arraycopy(value, 0, data, 4, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getAlertCommand(byte number, byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{11, 0, number, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAlertCommand(byte number, byte type, byte[] param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4 + param.length];
        data[0] = 11;
        data[1] = 1;
        data[2] = number;
        data[3] = type;
        System.arraycopy(param, 0, data, 4, param.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getVMDeviceStatusCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setVMParameterCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + value.length];
        data[0] = 13;
        data[1] = param;
        System.arraycopy(value, 0, data, 2, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIPCtrlCommand(byte param) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)113, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIPCtrlRuleCommand(byte param, byte index) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, param, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)113, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIPCtrlCommand(byte param, byte[] value) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2 + value.length];
        data[0] = 1;
        data[1] = param;
        System.arraycopy(value, 0, data, 2, value.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)113, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage mountISOCommand(byte type) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{14, type};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage umountISOCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{15};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage umountFloppyCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSMBStatusCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{23};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getKCSStatusCommand() throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{33, 1, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setKCSStatusCommand(byte isEnable) throws IPMIException {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{33, 1, 1, isEnable};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage restKVMCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{7, 1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public byte[] getVMDeviceStatus() throws IPMIException {
        IPMIMessage resMessage = this.getVMDeviceStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getVMDeviceStatusCommand failed");
    }

    public void setVMParameter(byte param, String value) throws IPMIException {
        IPMIMessage resMessage = this.setVMParameterCommand(param, value.getBytes());
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setVMParameterCommand failed");
    }

    public boolean mountISOImageForTextMode(byte deviceID, String host, String path, String username, String password) throws IPMIException {
        try {
            this.setVMParameter((byte)0, host);
        }
        catch (IPMIException e) {
            throw new IPMIException("Set host IP failed");
        }
        try {
            this.setVMParameter((byte)1, path);
        }
        catch (IPMIException e) {
            throw new IPMIException("Set path failed");
        }
        if (username != null && username.length() > 0) {
            try {
                this.setVMParameter((byte)2, username);
            }
            catch (IPMIException e) {
                throw new IPMIException("Set username failed");
            }
        }
        if (password != null && password.length() > 0) {
            try {
                this.setVMParameter((byte)3, password);
            }
            catch (IPMIException e) {
                throw new IPMIException("Set password failed");
            }
        }
        try {
            this.mountISO(deviceID);
        }
        catch (IPMIException e) {
            throw new IPMIException("mount ISO failed");
        }
        return true;
    }

    public void mountISO(byte param) throws IPMIException {
        IPMIMessage resMessage = this.mountISOCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call mountISOCommand failed");
    }

    public void umountISO() throws IPMIException {
        IPMIMessage resMessage = this.umountISOCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call umountISOCommand failed");
    }

    public void umountFloppy() throws IPMIException {
        IPMIMessage resMessage = this.umountFloppyCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call umountFloppyCommand failed");
    }

    public byte[] getADServer(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getActiveDirectoryCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getADServer failed");
    }

    public byte[] getADRoleGroup(byte param, byte index) throws IPMIException {
        IPMIMessage resMessage = this.getActiveDirectoryRoleGroupCommand(param, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getADServerRoleGroup failed");
    }

    public boolean setActiveDirectory(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setActiveDirectoryCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set Active Directory");
        return false;
    }

    public byte[] getLdap(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getLDAPCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getLdap failed");
    }

    public boolean setLdap(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setLDAPCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set LDAP");
        return false;
    }

    public byte[] getRadius(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getRADIUSCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getRadius failed");
    }

    public boolean setRadius(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setRADIUSCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set Radius");
        return false;
    }

    public byte[] getIpCtrl() throws IPMIException {
        IPMIMessage resMessage = this.getIPCtrlCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getIpCtrl failed");
    }

    public byte[] getIpCtrlRule(byte index) throws IPMIException {
        IPMIMessage resMessage = this.getIPCtrlRuleCommand((byte)1, index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        throw new IPMIException("Call getIpCtrlRule failed");
    }

    public boolean setIpCtrl(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setIPCtrlCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set IP control rule");
        return false;
    }

    public byte[] getNTPDateTime(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getNTPDateTimeCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getNTPDateTimeCommand failed");
    }

    public void setNTPDateTime(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setNTPDateTimeCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setNTPDateTimeCommand failed");
    }

    public byte[] getDDNS(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getDDNSCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getDDNSCommand failed");
    }

    public void setDDNS(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setDDNSCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setDDNSCommand failed");
    }

    public byte[] getAlert(byte number, byte param) throws IPMIException {
        IPMIMessage resMessage = this.getAlertCommand(number, param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getAlertCommand failed");
    }

    public byte[] setAlert(byte number, byte type, byte[] param) throws IPMIException {
        IPMIMessage resMessage = this.setAlertCommand(number, type, param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getAlertCommand failed");
    }

    public byte[] getSMTP(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getSMTPCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSMTPCommand failed");
    }

    public void setSMTP(byte param, byte[] value) throws IPMIException {
        IPMIMessage resMessage = this.setSMTPCommand(param, value);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setSMTPCommand failed");
    }

    public byte getSMBStatus() throws IPMIException {
        IPMIMessage resMessage = this.getSMBStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getSMBStatusCommand failed");
    }

    public String getDNS(byte param) throws IPMIException {
        IPMIMessage resMessage = this.getDNSServerCommand(param);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data);
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getDNSCommand failed");
    }

    public boolean setDNS(byte param, String ip, byte operation) throws IPMIException {
        IPMIMessage resMessage;
        int ipLength = 4;
        byte[] data = null;
        if (param == 1) {
            ipLength = ip.length();
            data = new byte[ipLength];
            for (int i = 0; i < ipLength; ++i) {
                data[i] = (byte)(ip.charAt(i) & 0xFF);
            }
        } else {
            data = new byte[ipLength];
            StringTokenizer st = new StringTokenizer(ip, ".");
            for (int i = 0; i < ipLength; ++i) {
                if (!st.hasMoreTokens()) {
                    MessageCenter.getInstance().put(this, (Object)"IP format error!");
                    return false;
                }
                data[i] = (byte)Integer.parseInt(st.nextToken());
            }
        }
        if ((resMessage = this.setDNSServerCommand(param, data, operation)) != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setDNSCommand failed");
    }

    public void setKCSControl(boolean isEnable) throws IPMIException {
        byte enable = isEnable ? (byte)1 : 0;
        IPMIMessage resMessage = this.setKCSStatusCommand(enable);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call setKCSCommand failed");
    }

    public byte getKCSControl() throws IPMIException {
        IPMIMessage resMessage = this.getKCSStatusCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException("Call getKCSCommand failed");
    }

    public boolean resetKVM() throws IPMIException {
        IPMIMessage resMessage = this.restKVMCommand();
        if (resMessage == null) {
            throw new IPMIException("call restKVMCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        return false;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("10.133.176.175");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIOEMWebSettingCommand ipmiOEMWebSettingCommand = new IPMIOEMWebSettingCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiOEMWebSettingCommand);
        if (sessionController == null) {
            return;
        }
        try {
            GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = 1;
            ipmiOEMWebSettingCommand.setVMParameter(VM_PARAM_HOST, "10.133.176.217");
            ipmiOEMWebSettingCommand.setVMParameter(VM_PARAM_PATH, "\\test_vm\\a.iso");
            ipmiOEMWebSettingCommand.mountISO((byte)0);
            byte[] vmStatus = ipmiOEMWebSettingCommand.getVMDeviceStatus();
            System.out.println(ByteUtility.bytesToHex(vmStatus));
            System.out.println("Sleep");
            try {
                Thread.sleep(100000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
    }
}

