/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class BIOSPostCode {
    public static final String[][] BIOS_CODE_AMI = new String[][]{{"D0", "Early Boot Strap Processor (BSP) initialization like microcode update,frequency and other CPU critical initialization. Early chipset initialization is done."}, {"D1", "Early super I/O initialization is done including RTC and keyboard controller.Serial port is enabled at this point if needed for debugging. NMI is disabled. Perform keyboard controller BAT test. Save power-on CPUID value in scratch CMOS. Go to flat mode with 4GB limit and GA20 enabled."}, {"D2", "Verify the boot block checksum. System will hang here if checksum is bad."}, {"D3", "Disable CACHE before memory detection. Execute full memory sizing module. If memory sizing module not executed, start memory refresh and do memory sizing in Boot block code. Do additional chipset initialization. Re-enable CACHE. Verify that flat mode is enabled."}, {"D4", "Test base 512KB memory. Adjust policies and cache first 8MB. Set stack."}, {"D5", "Bootblock code is copied from ROM to lower system memory and control is given to it. BIOS now executes out of RAM. Copies compressed boot block code to memory in right segments. Copies BIOS from ROM to RAM for faster access. Performs main BIOS checksum and updates recovery status accordingly."}, {"D6", "Both key sequence and OEM specific method is checked to determine if BIOS recovery is forced. If BIOS recovery is necessary, control flows to checkpoint E0. See Bootblock Recovery Code Checkpoints section of document for more information."}, {"D7", "Restore CPUID value back into register. The Bootblock-Runtime interface module is moved to system memory and control is given to it. Determine whether to execute serial flash."}, {"D8", "The Runtime module is uncompressed into memory. CPUID information is stored in memory."}, {"D9", "Store the Uncompressed pointer for future use in PMM. Copying Main BIOS into memory. Leaves all RAM below 1MB Read-Write including E000 and F000 shadow areas but closing SMRAM."}, {"DA", "Restore CPUID value back into register. Give control to BIOS POST (ExecutePOSTKernel). See POST Code Checkpoints section of document for more information."}, {"DC", "System is waking from ACPI S3 state"}, {"E1", "OEM memory detection/configuration error"}, {"E2", "OEM memory detection/configuration error"}, {"E3", "OEM memory detection/configuration error"}, {"E4", "OEM memory detection/configuration error"}, {"E5", "OEM memory detection/configuration error"}, {"E6", "OEM memory detection/configuration error"}, {"E7", "OEM memory detection/configuration error"}, {"E8", "OEM memory detection/configuration error"}, {"EC", "OEM memory detection/configuration error"}, {"EE", "OEM memory detection/configuration error"}, {"EF", "OEM memory detection/configuration error"}, {"E0", "Initialize the floppy controller in the super I/O. Some interrupt vectors are initialized. DMA controller is initialized. 8259 interrupt controller is initialized. L1 cache is enabled."}, {"E9", "Set up floppy controller and data. Attempt to read from floppy."}, {"EA", "Enable ATAPI hardware. Attempt to read from ARMD and ATAPI CDROM."}, {"EB", "Disable ATAPI hardware. Jump back to checkpoint E9."}, {"EF", "Read error occurred on media. Jump back to checkpoint EB."}, {"F0", "Search for pre-defined recovery file name in root directory."}, {"F1", "Recovery file not found."}, {"F2", "Start reading FAT table and analyze FAT to find the clusters occupied by the recovery file."}, {"F3", "Start reading the recovery file cluster by cluster."}, {"F5", "Disable L1 cache."}, {"FA", "Check the validity of the recovery file configuration to the current configuration of the flash part."}, {"FB", "Make flash write enabled through chipset and OEM specific method. Detect proper flash part. Verify that the found flash part size equals the recovery file size."}, {"F4", "The recovery file size does not equal the found flash part size."}, {"FC", "Erase the flash part."}, {"FD", "Program the flash part."}, {"FF", "The flash has been updated successfully. Make flash write disabled. Disable ATAPI hardware. Restore CPUID value back into register. Give control to F000 ROM at F000:FFF0h. 03 Disable NMI, Parity, video for EGA, and DMA controllers. Initialize BIOS, POST, Runtime data area. Also initialize BIOS modules on POST entry and GPNV area. Initialized CMOS as mentioned in the Kernel Variable \"wCMOSFlags.\""}, {"04", "Check CMOS diagnostic byte to determine if battery power is OK and CMOS checksum is OK. Verify CMOS checksum manually by reading storage area. If the CMOS checksum is bad, update CMOS with power-on default value and clear passwords. Initialize status register A. Initializes data variables that are based on CMOS setup questions. Initializes both the 8259 compatible PICs in the system"}, {"05", "Initializes the interrupt controlling hardware (generally PIC) and interrupt vector table."}, {"06", "Do R/W test to CH-2 count reg. Initialize CH-0 as system timer.Install the POSTINT1Ch handler. Enable IRQ-0 in PIC for system timer interrupt. Traps INT1Ch vector to \"POSTINT1ChHandlerBlock.\""}, {"07", "Fixes CPU POST interface calling pointer."}, {"08", "Initializes the CPU. The BAT test is being done on KBC. Program the keyboard controller command byte is being done after Auto detection of KB/MS using AMI KB-5."}, {"C0", "Early CPU Init Start -- Disable Cache \u2013 Init Local APIC"}, {"C1", "Set up boot strap processor Information"}, {"C2", "Set up boot strap processor for POST"}, {"C5", "Enumerate and set up application processors"}, {"C6", "Re-enable cache for boot strap processor"}, {"C7", "Early CPU Init Exit"}, {"0A", "Initializes the 8042 compatible Key Board Controller."}, {"0B", "Detects the presence of PS/2 mouse."}, {"0C", "Detects the presence of Keyboard in KBC port."}, {"0E", "Testing and initialization of different Input Devices. Also, update the Kernel Variables. Traps the INT09h vector, so that the POST INT09h handler gets control for IRQ1. Uncompress all available language, BIOS logo, and Silent logo modules."}, {"13", "Early POST initialization of chipset registers."}, {"20", "Relocate System Management Interrupt vector for all CPU in the system."}, {"24", "Uncompress and initialize any platform specific BIOS modules. GPNV is initialized at this checkpoint."}, {"2A", "Initializes different devices through DIM. See DIM Code Checkpoints section of document for more information."}, {"2C", "Initializes different devices. Detects and initializes the video adapter installed in the system that have optional ROMs."}, {"2E", "Initializes all the output devices."}, {"31", "Allocate memory for ADM module and uncompress it. Give control to ADM module for initialization. Initialize language and font modules for ADM. Activate ADM module."}, {"33", "Initializes the silent boot module. Set the window for displaying text information."}, {"37", "Displaying sign-on message, CPU information, setup key message, and any OEM specific information."}, {"38", "Initializes different devices through DIM. See DIM Code Checkpoints section of document for more information. USB controllers are initialized at this point."}, {"39", "Initializes DMAC-1 & DMAC-2."}, {"3A", "Initialize RTC date/time."}, {"3B", "Test for total memory installed in the system. Also, Check for DEL or ESC keys to limit memory test. Display total memory in the system."}, {"3C", "Mid POST initialization of chipset registers."}, {"40", "Detect different devices (Parallel ports, serial ports, and coprocessor in CPU, \u2026 etc.) successfully installed in the system and update the BDA, EBDA\u2026etc."}, {"52", "Updates CMOS memory size from memory found in memory test. Allocates memory for Extended BIOS Data Area from base memory. Programming the memory hole or any kind of implementation that needs an adjustment in system RAM size if needed."}, {"60", "Initializes NUM-LOCK status and programs the KBD typematic rate."}, {"75", "Initialize Int-13 and prepare for IPL detection."}, {"78", "Initializes IPL devices controlled by BIOS and option ROMs."}, {"7C", "Generate and write contents of ESCD in NVRam."}, {"84", "Log errors encountered during POST."}, {"85", "Display errors to the user and gets the user response for error."}, {"87", "Execute BIOS setup if needed / requested. Check boot password if installed."}, {"8C", "Late POST initialization of chipset registers."}, {"8D", "Build ACPI tables (if ACPI is supported)"}, {"8E", "Program the peripheral parameters. Enable/Disable NMI as selected"}, {"90", "Initialization of system management interrupt by invoking all handlers. Please note this checkpoint comes right after checkpoint 20h"}, {"A1", "Clean-up work needed before booting to OS."}, {"A2", "Takes care of runtime image preparation for different BIOS modules. Fill the free area in F000h segment with 0FFh. Initializes the Microsoft IRQ Routing Table. Prepares the runtime language module. Disables the system configuration display if needed."}, {"A4", "Initialize runtime language module. Display boot option popup menu."}, {"A7", "Displays the system configuration screen if enabled. Initialize the CPU\u2019s before boot, which includes the programming of the MTRR\u2019s."}, {"A9", "Wait for user input at config display if needed."}, {"AA", "Uninstall POST INT1Ch vector and INT09h vector."}, {"AB", "Prepare BBS for Int 19 boot. Init MP tables."}, {"AC", "End of POST initialization of chipset registers. De-initializes the ADM module."}, {"B1", "Save system context for ACPI. Prepare CPU for OS boot including final MTRR values."}, {"00", "Passes control to OS Loader (typically INT19h)."}, {"2A", "Initialize different buses and perform the following functions: Reset,Detect, and Disable (function 0); Static Device Initialization (function 1); Boot Output Device Initialization (function 2). Function 0 disables all device nodes, PCI devices, and PnP ISA cards. It also assigns PCI bus numbers. Function 1 initializes all static devices that include manual configured onboard peripherals, memory and I/O decode windows in PCIPCI bridges, and noncompliant PCI devices. Static resources are also reserved. Function 2 searches for and initializes any PnP, PCI, or AGP video devices."}, {"38", "Initialize different buses and perform the following functions: Boot Input Device Initialization (function 3); IPL Device Initialization (function 4); General Device Initialization (function 5). Function 3 searches for and configures PCI input devices and detects if system has standard keyboard controller. Function 4 searches for and configures all PnP and PCI boot devices. Function 5 configures all onboard peripherals that are set to an automatic configuration and configures all remaining PnP and PCI devices."}};
    public static final String[][] BIOS_CODE_PHONEIX = new String[][]{{"01", "IPMI Initialization"}, {"02", "Verify Real Mode"}, {"03", "Disable Non-Maskable Interrupt (NMI)"}, {"04", "Get CPU type"}, {"06", "Initialize system hardware"}, {"07", "Disable shadow and execute code from the ROM."}, {"08", "Initialize chipset with initial POST values"}, {"09", "Set IN POST fl ag"}, {"0A", "Initialize CPU registers"}, {"0B", "Enable CPU cache"}, {"0C", "Initialize caches to initial POST values"}, {"0E", "Initialize I/O component"}, {"0F", "Initialize the local bus IDE"}, {"10", "Initialize Power Management"}, {"11", "Load alternate registers with initial POST values"}, {"12", "Restore CPU control word during warm boot"}, {"13", "Reset PCI Bus Mastering devices"}, {"14", "Initialize keyboard controller"}, {"16", "1-2-2-3 BIOS ROM checksum"}, {"18", "8254 timer initialization"}, {"1A", "8237 DMA controller initialization"}, {"1C", "Reset Programmable Interrupt Controller"}, {"20", "1-3-1-1 Test DRAM refresh"}, {"22", "1-3-1-3 Test 8742 Keyboard Controller"}, {"24", "Set ES segment register to 4 GB"}, {"28", "Auto size DRAM"}, {"29", "Initialize POST Memory Manager"}, {"2A", "Clear 512 kB base RAM"}, {"2C", "1-3-4-1 RAM failure on address line xxxx*"}, {"2E", "1-3-4-3 RAM failure on data bits xxxx* of low byte of memory bus"}, {"2F", "Enable cache before system BIOS shadow"}, {"32", "Test CPU bus-clock frequency"}, {"33", "Initialize Phoenix Dispatch Manager"}, {"36", "Warm start shut down"}, {"38", "Shadow system BIOS ROM"}, {"3A", "Auto size cache"}, {"3C", "Advanced confi guration of chipset registers"}, {"3D", "Load alternate registers with CMOS values"}, {"41", "Initialize extended memory for RomPilot (optional)"}, {"42", "Initialize interrupt vectors"}, {"45", "POST device initialization"}, {"46", "2-1-2-3 Check ROM copyright notice"}, {"48", "Check video confi guration against CMOS"}, {"49", "Initialize PCI bus and devices"}, {"4A", "Initialize all video adapters in system"}, {"4B", "QuietBoot start (optional)"}, {"4C", "Shadow video BIOS ROM"}, {"4E", "Display BIOS copyright notice"}, {"4F", "Initialize MultiBoot"}, {"50", "Display CPU type and speed"}, {"51", "Initialize EISA board (optional)"}, {"52", "Test keyboard"}, {"54", "Set key click if enabled"}, {"55", "Enable USB devices"}, {"58", "2-2-3-1 Test for unexpected interrupts"}, {"59", "Initialize POST display service"}, {"5A", "Display prompt \u201cPress <ESC> to enter SETUP\u201d"}, {"5B", "Disable CPU cache17h Initialize cache before memory Auto size"}, {"5C", "Test RAM between 512 and 640 kB"}, {"60", "Test extended memory"}, {"62", "Test extended memory address lines"}, {"64", "Jump to UserPatch1"}, {"66", "Confi gure advanced cache registers"}, {"67", "Initialize Multi Processor APIC"}, {"68", "Enable external and CPU caches"}, {"69", "Setup System Management Mode (SMM) area"}, {"6A", "Display external L2 cache size"}, {"6B", "Load custom defaults (optional)"}, {"6C", "Display shadow-area message"}, {"70", "Display error messages"}, {"72", "Check for confi guration errors"}, {"76", "Check for keyboard errors"}, {"7C", "Set up hardware interrupt vectors"}, {"7D", "Initialize Intelligent System Monitoring (optional)"}, {"7E", "Initialize coprocessor if present"}, {"80", "Disable onboard Super I/O ports and IRQs (optional)"}, {"81", "Late POST device initialization"}, {"82", "Detect and install external RS232 ports"}, {"83", "Confi gure non-MCD IDE controllers"}, {"84", "Detect and install external parallel ports"}, {"85", "Initialize PC-compatible PnP ISA devices"}, {"86", "Re-initialize onboard I/O ports."}, {"87", "Confi gure Motherboard Confi gurable Devices (optional)"}, {"88", "Initialize BIOS Data Area"}, {"89", "Enable Non-Maskable Interrupts (NMIs)"}, {"8A", "Initialize Extended BIOS Data Area"}, {"8B", "Test and initialize PS/2 mouse"}, {"8C", "Initialize fl oppy controller"}, {"8F", "Determine number of ATA drives (optional)"}, {"90", "Initialize hard-disk controllers"}, {"91", "Initialize local-bus hard-disk controllers"}, {"92", "Jump to UserPatch2"}, {"93", "Build MPTABLE for multi-processor boards"}, {"95", "Install CD ROM for boot"}, {"96", "Clear huge ES segment register"}, {"97", "Fix up Multi Processor table"}, {"98", "1-2 Search for option ROMs and shadow if successful. One long, two short beeps on checksum failure"}, {"99", "Check for SMART Drive (optional)"}, {"9C", "Set up Power Management"}, {"9D", "Initialize security engine (optional)"}, {"9E", "Enable hardware interrupts"}, {"9F", "Determine number of ATA and SCSI drives"}, {"A0", "Set time of day"}, {"A2", "Check key lock"}, {"A4", "Initialize typematic rate"}, {"A8", "Erase <ESC> prompt"}, {"AA", "Scan for <ESC> key stroke"}, {"AC", "Enter SETUP"}, {"AE", "Clear Boot fl ag"}, {"B0", "Check for errors"}, {"B1", "Inform RomPilot about the end of POST (optional)"}, {"B2", "POST done - prepare to boot operating system"}, {"B4", "1 One short beep before boot"}, {"B5", "Terminate QuietBoot (optional)"}, {"B6", "Check password (optional)"}, {"B7", "Initialize ACPI BIOS and PPM Structures"}, {"B9", "Prepare Boot"}, {"BA", "Initialize SMBIOS"}, {"BC", "Clear parity checkers"}, {"BD", "Display MultiBoot menu"}, {"BE", "Clear screen (optional)"}, {"BF", "Check virus and backup reminders"}, {"C0", "Try to boot with INT 19"}, {"C1", "Initialize POST Error Manager (PEM)"}, {"C2", "Initialize error logging"}, {"C3", "Initialize error display function"}, {"C4", "Initialize system error fl ags"}, {"C6", "Console redirection init."}, {"C7", "Unhook INT 10h if console redirection enabled"}, {"C8", "Force check (optional)"}, {"C9", "Extended ROM checksum (optional)"}, {"CD", "Reclaim console redirection vector"}, {"D2", "Unknown interrupt"}, {"D4", "Check Intel Branding string"}, {"D8", "Alert Standard Format initialization"}, {"D9", "Late init for IPMI"}, {"DE", "Log error if micro-code not updated properly"}, {"E0", "Initialize the chipset"}, {"E1", "Initialize the bridge"}, {"E2", "Initialize the CPU"}, {"E3", "Initialize system timer"}, {"E4", "Initialize system I/O"}, {"E5", "Check force recovery boot"}, {"E6", "Checksum BIOS ROM"}, {"E7", "Go to BIOS"}, {"E8", "Set Huge Segment"}, {"E9", "Initialize Multi Processor"}, {"EA", "Initialize OEM special code"}, {"EB", "Initialize PIC and DMA"}, {"EC", "Initialize Memory type"}, {"ED", "Initialize Memory size"}, {"EE", "Shadow Boot Block"}, {"EF", "System memory test"}, {"F0", "Initialize interrupt vectors"}, {"F1", "Initialize Run Time Clock"}, {"F2", "Initialize video"}, {"F3", "Initialize System Management Manager"}, {"F4", "Output one beep"}, {"F5", "Clear Huge Segment"}, {"F6", "Boot to Mini DOS"}, {"F7", "Boot to Full DOS"}};

    public static void main(String[] args) {
        for (int i = 0; i <= 255; ++i) {
            String str = BIOSPostCode.getPOSTCodeDefinition(BIOS.PHOENIX, (byte)i);
            System.out.println(ByteUtility.byteToHex((byte)i) + " " + str);
        }
    }

    public static String getPOSTCodeDefinition(BIOS bios, byte code) {
        String retStr = "";
        switch (bios) {
            case AMI: {
                retStr = BIOSPostCode.getPOSTCodeDefinition(BIOS_CODE_AMI, code);
                break;
            }
            case PHOENIX: {
                retStr = BIOSPostCode.getPOSTCodeDefinition(BIOS_CODE_PHONEIX, code);
            }
        }
        return retStr;
    }

    private static String getPOSTCodeDefinition(String[][] definition, byte code) {
        String codeStr = ByteUtility.byteToHex(code);
        for (int i = 0; i < definition.length; ++i) {
            if (!definition[i][0].equals(codeStr)) continue;
            return definition[i][1];
        }
        return "undefined";
    }

    public static enum BIOS {
        AMI,
        PHOENIX;

    }
}

