/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class BIOSEFIError {
    public static String[] Class = new String[]{"EFI_COMPUTING_UNIT", "EFI_PERIPHERAL", "EFI_IO_BUS", "EFI_SOFTWARE"};
    public static String[][] Code = new String[][]{{"00", "00", "The computing unit type is unknown, undefined, or unspecified"}, {"00", "01", "The computing unit is a fullservice central processing unit"}, {"00", "02", "The computing unit is a limited service processor, typically designed to handle tasks of limited scope"}, {"00", "03", "The computing unit is a processor designed specifically to handle I/O transactions"}, {"00", "04", "The computing unit is a cache. All types of cache qualify"}, {"00", "05", "The computing unit is memory. Many types of memory qualify"}, {"00", "06", "The computing unit is a chipset component"}, {"01", "00", "The peripheral type is unknown, undefined, or unspecified"}, {"01", "01", "The peripheral referred to is a keyboard"}, {"01", "02", "The peripheral referred to is a mouse"}, {"01", "03", "The peripheral referred to is a console directly attached to the system"}, {"01", "04", "The peripheral referred to is a console that can be remotely accessed"}, {"01", "05", "The peripheral referred to is a serial port"}, {"01", "06", "The peripheral referred to is a parallel port"}, {"01", "07", "The peripheral referred to is a fixed media device\u2014e.g., an IDE hard disk drive"}, {"01", "08", "The peripheral referred to is a removable media device\u2014e.g., a DVD-ROM drive"}, {"01", "09", "The peripheral referred to is an audio input device\u2014e.g., a microphone"}, {"01", "0A", "The peripheral referred to is an audio output device\u2014e.g., speakers or headphones"}, {"01", "0B", "The peripheral referred to is an LCD device"}, {"01", "0C", "The peripheral referred to is a network device\u2014e.g., a network card"}, {"02", "00", "The bus type is unknown, undefined, or unspecified"}, {"02", "01", "The bus is a PCI bus"}, {"02", "02", "The bus is a USB bus"}, {"02", "03", "The bus is an IBA bus"}, {"02", "04", "The bus is an AGP bus"}, {"02", "05", "The bus is a PC Card bus"}, {"02", "06", "The bus is a LPC bus"}, {"02", "07", "The bus is a SCSI bus"}, {"02", "08", "The bus is a ATA/ATAPI bus"}, {"02", "09", "The bus is an EC bus"}, {"02", "0A", "The bus is an IP network bus"}, {"02", "0B", "The bus is a SMBUS bus"}, {"02", "0C", "The bus is an I2C bus"}, {"03", "00", "The software type is unknown, undefined, or unspecified"}, {"03", "01", "The software is a part of the SEC phase"}, {"03", "02", "The software is the PEI Foundation module"}, {"03", "03", "The software is a PEIM"}, {"03", "04", "The software is the DXE Foundation module"}, {"03", "05", "The software is a DXE Boot Service driver. Boot service drivers are not available once ExitBootServices() is called"}, {"03", "06", "The software is a DXE Runtime Service driver. These drivers execute during runtime phase"}, {"03", "07", "The software is a SMM driver"}, {"03", "08", "The software is an EFI application"}, {"03", "09", "The software is an OS loader"}, {"03", "0A", "The software is a part of the RT phase"}, {"03", "0B", "The software is a part of the AL phase"}, {"03", "0C", "The status code is directly related to an EBC exception"}, {"03", "0D", "The status code is directly related to an IA-32 exception"}, {"03", "0F", "The status code is directly related to a PEI Services function"}, {"03", "10", "The status code is directly related to an EFI Boot Services function"}, {"03", "11", "The status code is directly related to an EFI R untime Services function"}, {"03", "12", "The status code is directly related to a DXE Services function"}};

    public static String getCode(byte classCode, byte subClassCode) {
        String header = "EFI " + ByteUtility.byteToHex(classCode) + ByteUtility.byteToHex(subClassCode);
        for (int i = 0; i < Code.length; ++i) {
            if (!Code[i][0].equals(ByteUtility.byteToHex(classCode)) || !Code[i][1].equals(ByteUtility.byteToHex(subClassCode))) continue;
            return header + ":(" + Class[classCode] + ") " + Code[i][2];
        }
        return header + ":Undefined";
    }

    public static void main(String[] args) {
        System.out.println(BIOSEFIError.getCode((byte)0, (byte)1));
        System.out.println(BIOSEFIError.getCode((byte)0, (byte)3));
        System.out.println(BIOSEFIError.getCode((byte)3, (byte)1));
        System.out.println(BIOSEFIError.getCode((byte)15, (byte)1));
    }
}

