/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.awt;

import com.zerog.ui.gui.iStandardDialog;
import com.zerog.util.IAResourceBundle;
import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ZGStandardDialog
extends Dialog
implements ActionListener,
KeyListener,
iStandardDialog,
Flexeraaxg {
    private Flexeraab7 labelTextWrap;
    private Flexeraab7 narrativeTextWrap;
    private String labelText = "";
    private String narrativeText = "";
    public static final int ERROR = 1;
    private static final String warningIconPath = "com/zerog/util/images/Warn.gif";
    private static final String errorIconPath = "com/zerog/util/images/Error.gif";
    private static final String informationIconPath = "com/zerog/util/images/Info.gif";
    private static final String queryIconPath = "com/zerog/util/images/Query.gif";
    private Flexeraab6 dialogIcon;
    private int totalHeight;
    private int DIALOG_WIDTH = 330;
    private boolean isModal = true;
    private Frame parentFrame = null;
    private Button defaultButton;
    private Button cancelButton;
    private Button detailsButton;
    private static String defaultDialogTitle;
    private static String defaultButtonText;
    private static String cancelButtonText;
    private static String detailsButtonText;
    private boolean cancelVisibility = false;
    private boolean detailsVisibility = false;
    private ActionListener actionListener = null;
    private int whichButton = 0;
    private boolean isCentered = true;
    private int whichPlatform;
    private static final int WIN32 = 0;
    private static final int MACOS = 1;
    private static final int OTHER = 2;

    public ZGStandardDialog(String string, String string2) {
        this(new Frame(), defaultDialogTitle, string, string2, 0);
    }

    public ZGStandardDialog(Frame frame, String string, String string2) {
        this(frame, defaultDialogTitle, string, string2, 0);
    }

    public ZGStandardDialog(String string, String string2, String string3) {
        this(new Frame(), string, string2, string3, 0);
    }

    public ZGStandardDialog(Frame frame, String string, String string2, String string3) {
        this(frame, string, string2, string3, 0);
    }

    public ZGStandardDialog(Frame frame, String string, String string2, String string3, int n) {
        super(frame, string, true);
        this.labelText = string2;
        this.narrativeText = string3;
        this.parentFrame = frame;
        String string4 = System.getProperty("os.name").toLowerCase();
        this.whichPlatform = string4.indexOf("mac") != -1 ? 1 : (string4.indexOf("win") != -1 ? 0 : 2);
        this.createUI(n);
        this.majorLayout();
        this.addListeners();
        this.centerOnScreen();
        this.setModal(true);
        this.setResizable(false);
    }

    public void setModal(boolean bl) {
        this.isModal = bl;
        super.setModal(bl);
    }

    public boolean quitApprovalRequested() {
        return !this.isModal();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.addListener();
        } else {
            this.removeListener();
        }
        super.setVisible(bl);
    }

    public void show() {
        this.addListener();
        super.show();
    }

    public void hide() {
        super.hide();
        this.removeListener();
    }

    private void removeListener() {
        if (this.parentFrame instanceof Flexeraaxc) {
            ((Flexeraaxc)((Object)this.parentFrame)).removeZGQuitApprovalListener(this);
        }
    }

    private void addListener() {
        if (this.parentFrame instanceof Flexeraaxc) {
            ((Flexeraaxc)((Object)this.parentFrame)).addZGQuitApprovalListener(this);
        }
    }

    public void setDetailsButtonVisible(boolean bl) {
        this.detailsButton.setVisible(bl);
        this.detailsVisibility = bl;
    }

    public void setCancelButtonVisible(boolean bl) {
        this.cancelButton.setVisible(bl);
        this.cancelVisibility = bl;
    }

    public void setDefaultButtonLabel(String string) {
        this.defaultButton.setLabel(string);
        this.majorLayout();
    }

    public void setCancelButtonLabel(String string) {
        this.cancelButton.setLabel(string);
        this.majorLayout();
    }

    public void setDetailsButtonLabel(String string) {
        this.detailsButton.setLabel(string);
        this.majorLayout();
    }

    public void setAlertLevel(int n) {
        this.setAlertLevel(n, true);
    }

    private void setAlertLevel(int n, boolean bl) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        switch (n) {
            default: {
                System.err.println("ZGStandardDialog: Unregocnized Alert Level, using WARNING.");
            }
            case 0: {
                this.dialogIcon.aa(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(warningIconPath)));
                if (!bl) break;
                this.majorLayout();
                break;
            }
            case 2: {
                this.dialogIcon.aa(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(informationIconPath)));
                if (!bl) break;
                this.majorLayout();
                break;
            }
            case 1: {
                this.dialogIcon.aa(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(errorIconPath)));
                if (!bl) break;
                this.majorLayout();
                break;
            }
            case 3: {
                this.dialogIcon.aa(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(queryIconPath)));
                if (!bl) break;
                this.majorLayout();
            }
        }
    }

    public void setImage(Image image) {
        this.dialogIcon.aa(image);
        this.majorLayout();
    }

    private void createUI(int n) {
        this.labelTextWrap = new Flexeraab7(this.labelText);
        this.labelTextWrap.aa(this.DIALOG_WIDTH);
        this.narrativeTextWrap = new Flexeraab7(this.narrativeText);
        this.narrativeTextWrap.aa(this.DIALOG_WIDTH);
        this.dialogIcon = new Flexeraab6(){

            public Dimension getPreferredSize() {
                Dimension dimension = this.getSize();
                if (dimension.width < 1 || dimension.height < 1) {
                    dimension = new Dimension(32, 32);
                }
                return dimension;
            }
        };
        this.setAlertLevel(n, false);
        this.defaultButton = new Button(defaultButtonText);
        this.cancelButton = new Button(cancelButtonText);
        this.detailsButton = new Button(detailsButtonText);
        this.labelTextWrap.setFont(Flexeraasf.ba);
        this.narrativeTextWrap.setFont(Flexeraasf.a9);
        this.setBackground(SystemColor.control);
        this.setForeground(SystemColor.textText);
    }

    private void majorLayout() {
        int n = 15;
        this.removeAll();
        aaa aaa2 = new aaa();
        Object var3_3 = null;
        aaa2.aa(this.dialogIcon, 0, 0, 1, 3, 0, new Insets(n, n, 0, 0), 18, 0.0, 1.0);
        aaa2.aa(this.labelTextWrap, 1, 0, 0, 1, 2, new Insets(n, n, 0, n), 18, 1.0, 0.0);
        aaa2.aa(this.narrativeTextWrap, 1, 1, 0, 1, 2, new Insets(7, n, n, n), 18, 1.0, 1.0);
        aaa2.aa(this.detailsButton, 1, 2, 1, 0, 0, new Insets(0, n, n, 0), 16, 1.0, 0.0);
        this.detailsButton.setVisible(this.detailsVisibility);
        Panel panel = new Panel();
        GridLayout gridLayout = new GridLayout(1, 2);
        gridLayout.setHgap(10);
        panel.setLayout(gridLayout);
        panel.add(this.cancelButton);
        this.cancelButton.setVisible(this.cancelVisibility);
        panel.add(this.defaultButton);
        aaa2.aa(panel, 2, 2, 2, 0, 0, new Insets(0, 10, n, n), 14, 0.0, 0.0);
        this.add(aaa2);
        this.pack();
        this.repaint();
    }

    private void addListeners() {
        this.defaultButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.detailsButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                try {
                    new Thread(){

                        public void run() {
                            ZGStandardDialog.this.bringToFront();
                        }
                    }.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ZGStandardDialog.this.defaultButton.requestFocus();
            }

            public void windowClosing(WindowEvent windowEvent) {
                ZGStandardDialog.this.setVisible(false);
                ZGStandardDialog.this.dispose();
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                if (ZGStandardDialog.this.isVisible()) {
                    new Thread(){

                        public void run() {
                            ZGStandardDialog.this.bringToFront();
                        }
                    }.start();
                } else {
                    this.windowClosing(windowEvent);
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){
            public boolean aa = false;

            public void focusGained(FocusEvent focusEvent) {
                if (!this.aa) {
                    this.aa = true;
                    ZGStandardDialog.this.defaultButton.requestFocus();
                }
            }
        });
        this.defaultButton.addKeyListener(this);
        this.cancelButton.addKeyListener(this);
        this.detailsButton.addKeyListener(this);
    }

    private void centerAbsolute() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 3);
    }

    public void centerOnScreen() {
        if (this.parentFrame == null || !this.parentFrame.isVisible() || this.parentFrame.getLocation().x < 0 || this.parentFrame.getLocation().y < 0) {
            this.centerAbsolute();
            return;
        }
        Point point = this.parentFrame.getLocationOnScreen();
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(point.x + (dimension.width - dimension2.width) / 2, dimension3.width - dimension2.width - 10);
        int n2 = Math.min(point.y + (dimension.height - dimension2.height) / 3, dimension3.width - dimension2.width - 10);
        this.setLocation(n, n2);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public int getLastButtonPressed() {
        return this.whichButton;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = "NO_BUTTON";
        if (object == this.defaultButton) {
            this.whichButton = 1;
            string = "DEFAULT";
        } else if (object == this.cancelButton) {
            this.whichButton = 2;
            string = "CANCEL";
        } else if (object == this.detailsButton) {
            this.whichButton = 3;
            string = "DETAILS";
        } else {
            this.whichButton = 0;
            string = "NO_BUTTON";
        }
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
        this.dispose();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        Component component = (Component)keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && component instanceof Button && component.isEnabled() && component.isVisible()) {
            this.actionPerformed(new ActionEvent(component, 1001, ((Button)component).getActionCommand()));
        }
    }

    private void bringToFront() {
        if (this.isModal && this.isVisible()) {
            this.toFront();
        }
    }

    static {
        try {
            defaultDialogTitle = IAResourceBundle.getValue((String)"Installer.ZGStandardDialog.alert") != null ? IAResourceBundle.getValue((String)"Installer.ZGStandardDialog.alert") : "Alert";
            defaultButtonText = IAResourceBundle.getValue((String)"Installer.Customizer.ok") != null ? IAResourceBundle.getValue((String)"Installer.Customizer.ok") : "Ok";
            cancelButtonText = IAResourceBundle.getValue((String)"Installer.Customizer.cancel") != null ? IAResourceBundle.getValue((String)"Installer.Customizer.cancel") : "Cancel";
            detailsButtonText = IAResourceBundle.getValue((String)"Installer.StandardDialog.details") != null ? IAResourceBundle.getValue((String)"Installer.StandardDialog.details") + "..." : "Details...";
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            defaultDialogTitle = "Alert";
            defaultButtonText = "Ok";
            cancelButtonText = "Cancel";
            detailsButtonText = "Details...";
        }
    }

    public class aaa
    extends Container {
        private GridBagLayout aa;
        public GridBagConstraints ab = new GridBagConstraints();

        public aaa() {
            this.aa = new GridBagLayout();
            this.setLayout(this.aa);
        }

        public void aa(Component component, int n, int n2, int n3, int n4, int n5, Insets insets, int n6, double d, double d2) {
            this.ab.gridx = n;
            this.ab.gridy = n2;
            this.ab.gridwidth = n3;
            this.ab.gridheight = n4;
            this.ab.fill = n5;
            this.ab.insets = insets;
            this.ab.anchor = n6;
            this.ab.weightx = d;
            this.ab.weighty = d2;
            this.aa.setConstraints(component, this.ab);
            this.add(component);
        }
    }
}

