/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import nn.pp.drvredir.Drive;
import nn.pp.drvredir.DrvRedirNative;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.T;

class DriveSelectionDialog
extends JDialog
implements ActionListener {
    DrvRedirNative drvNative;
    PrintStream logger;
    JComboBox drvChoice;
    JButton refreshButton;
    JCheckBox writeBox;
    JButton okButton;
    JButton cancelButton;
    boolean ok = false;
    boolean writeSupport;
    String drive;
    Drive[] drives;

    DriveSelectionDialog(Frame owner, DrvRedirNative drvNative, PrintStream logger) {
        super(owner, T._("Select a drive to redirect"), true);
        Rectangle ownerBounds;
        this.drvNative = drvNative;
        this.logger = logger;
        this.addLayout();
        this.addAvailableDrives();
        this.pack();
        if (owner != null) {
            ownerBounds = owner.getBounds();
        } else {
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            ownerBounds = new Rectangle(0, 0, sd.width, sd.height);
        }
        Rectangle myBounds = this.getBounds();
        myBounds.x = Math.max(0, ownerBounds.x + ownerBounds.width / 2 - myBounds.width / 2);
        myBounds.y = Math.max(0, ownerBounds.y + ownerBounds.height / 2 - myBounds.height / 2);
        this.setBounds(myBounds);
    }

    private void addAvailableDrives() {
        if (this.drvNative == null) {
            return;
        }
        this.drives = this.drvNative.getAvailableDrives();
        this.drvChoice.removeAllItems();
        if (this.drives != null) {
            for (int i = 0; i < this.drives.length; ++i) {
                this.drvChoice.addItem(this.drives[i].getNameAndDescription());
            }
            this.drvChoice.setSelectedIndex(0);
        } else {
            this.logger.println("No drives to redirect found.");
        }
    }

    private void addLayout() {
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel(new FlowLayout(1));
        JPanel top1 = new JPanel(new GridLayout(2, 2, 5, 5));
        this.drvChoice = new JComboBox();
        top1.add(this.drvChoice);
        this.refreshButton = new JButton(T._("Refresh List"));
        top1.add(this.refreshButton);
        this.writeBox = new JCheckBox(T._("Enable Write support"), false);
        top1.add(this.writeBox);
        top.add(top1);
        this.add((Component)top, "Center");
        JPanel bottom = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(T._("OK"));
        bottom.add(this.okButton);
        this.cancelButton = new JButton(T._("Cancel"));
        bottom.add(this.cancelButton);
        this.add((Component)bottom, "South");
        this.refreshButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.okButton) {
            int index = this.drvChoice.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.ok = true;
            this.drive = this.drives[index].getName();
            this.writeSupport = this.writeBox.isSelected();
            if (this.writeSupport) {
                ConfirmDialog dlg = new ConfirmDialog(T._("Enabling Write Support is a very dangerous feature.\nThe remote and the local operating system both will have\nwrite access to the media which could destroy all data on\nthe drive. This should only be enabled with non-critical\ndata. Are you sure that you want to enable Write Support?"), T._("Warning"), 2, true);
                int x = (Toolkit.getDefaultToolkit().getScreenSize().width - dlg.getWidth()) / 2;
                int y = (Toolkit.getDefaultToolkit().getScreenSize().height - dlg.getHeight()) / 2;
                Point p = new Point(x, y);
                dlg.setLocation(p);
                dlg.setVisible(true);
                if (!dlg.yes) {
                    this.writeSupport = false;
                }
            }
            this.setVisible(false);
        } else if (src == this.cancelButton) {
            this.ok = false;
            this.setVisible(false);
        } else if (src == this.refreshButton) {
            this.addAvailableDrives();
        }
    }
}

