/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintStream;
import nn.pp.drvredir.ConnectionHandler;
import nn.pp.drvredir.DriveSelectionDialog;
import nn.pp.drvredir.DrvRedirNative;
import nn.pp.drvredir.DrvRedirSettingsPanel;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.T;

class ConnectionHandlerDrive
extends ConnectionHandler
implements ActionListener {
    DrvRedirNative drvNative;
    String drive;
    GenericTimer timer;

    ConnectionHandlerDrive(RFBProfile prof, DrvRedirSettingsPanel panel, DrvRedirNative drvNative, PrintStream logger, int msIndex) {
        super(prof, panel, drvNative, logger, msIndex);
        this.drvNative = drvNative;
        this.drive = this.drive;
        this.timer = new GenericTimer(500, this);
    }

    static void debug(String s) {
    }

    void chooseDrive(Frame frame) throws IOException {
        DriveSelectionDialog dlg = new DriveSelectionDialog(frame, this.drvNative, this.logger);
        dlg.show();
        if (!dlg.ok) {
            throw new IOException(T._("Cancelled Drive redirection"));
        }
        this.drive = dlg.drive;
        this.writeSupport = dlg.writeSupport;
    }

    @Override
    void connect() throws Exception {
        this.drvNative.initDriveRedirection();
        this.drvNative.openDrive(this.drive);
        this.drvNative.lockDriveAccess(true, false);
        this.doConnect();
        this.timer.start();
    }

    @Override
    void disconnect() {
        this.timer.stop();
        this.doDisconnect();
        try {
            this.drvNative.lockDriveAccess(true, true);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.drvNative.closeDrive();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.drvNative.cleanupDriveRedirection();
    }

    private void mediumRemovedForChange() throws Exception {
        this.drvNative.mediumRemovedForChange();
        this.proto.sendMediumRemoval();
    }

    private void mediumInsertedAfterChange() throws Exception {
        this.drvNative.lockDriveAccess(false, true);
        this.drvNative.closeDrive();
        this.drvNative.openDrive(this.drive);
        this.drvNative.lockDriveAccess(false, false);
        this.drvNative.mediumInsertedAfterChange();
        this.proto.sendMediumChange();
    }

    private void checkMediumChange() {
        try {
            switch (this.drvNative.getMediumChangeState()) {
                case 0: {
                    break;
                }
                case 1: {
                    ConnectionHandlerDrive.debug("Medium has been removed.");
                    this.mediumRemovedForChange();
                    break;
                }
                case 2: {
                    ConnectionHandlerDrive.debug("Medium has been changed.");
                    this.mediumInsertedAfterChange();
                }
            }
        }
        catch (Exception e) {
            this.disconnect();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.timer) {
            this.checkMediumChange();
        }
    }
}

