/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import java.util.HashMap;
import java.util.Map;
import jline.console.Operation;

public class KeyMap {
    public static final String VI_MOVE = "vi-move";
    public static final String VI_INSERT = "vi-insert";
    public static final String EMACS = "emacs";
    public static final String EMACS_STANDARD = "emacs-standard";
    public static final String EMACS_CTLX = "emacs-ctlx";
    public static final String EMACS_META = "emacs-meta";
    private static final int KEYMAP_LENGTH = 256;
    private static final Object NULL_FUNCTION = new Object();
    private Object[] mapping = new Object[256];
    private Object anotherKey = null;
    private String name;
    public static final char CTRL_D = '\u0004';
    public static final char CTRL_G = '\u0007';
    public static final char CTRL_H = '\b';
    public static final char CTRL_I = '\t';
    public static final char CTRL_J = '\n';
    public static final char CTRL_M = '\r';
    public static final char CTRL_R = '\u0012';
    public static final char CTRL_S = '\u0013';
    public static final char CTRL_U = '\u0015';
    public static final char CTRL_X = '\u0018';
    public static final char CTRL_Y = '\u0019';
    public static final char ESCAPE = '\u001b';
    public static final char CTRL_OB = '\u001b';
    public static final char CTRL_CB = '\u001d';
    public static final int DELETE = 127;

    public KeyMap(String name) {
        this(name, new Object[256]);
    }

    @Deprecated
    public KeyMap(String name, boolean unused) {
        this(name);
    }

    protected KeyMap(String name, Object[] mapping) {
        this.mapping = mapping;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object getAnotherKey() {
        return this.anotherKey;
    }

    public void from(KeyMap other) {
        this.mapping = other.mapping;
        this.anotherKey = other.anotherKey;
    }

    public Object getBound(CharSequence keySeq) {
        if (keySeq != null && keySeq.length() > 0) {
            KeyMap map = this;
            int i = 0;
            while (i < keySeq.length()) {
                char c = keySeq.charAt(i);
                if (c > '\u00ff') {
                    return Operation.SELF_INSERT;
                }
                if (map.mapping[c] instanceof KeyMap) {
                    if (i == keySeq.length() - 1) {
                        return map.mapping[c];
                    }
                } else {
                    return map.mapping[c];
                }
                map = (KeyMap)map.mapping[c];
                ++i;
            }
        }
        return null;
    }

    public void bindIfNotBound(CharSequence keySeq, Object function) {
        KeyMap.bind(this, keySeq, function, true);
    }

    public void bind(CharSequence keySeq, Object function) {
        KeyMap.bind(this, keySeq, function, false);
    }

    private static void bind(KeyMap map, CharSequence keySeq, Object function) {
        KeyMap.bind(map, keySeq, function, false);
    }

    private static void bind(KeyMap map, CharSequence keySeq, Object function, boolean onlyIfNotBound) {
        if (keySeq != null && keySeq.length() > 0) {
            int i = 0;
            while (i < keySeq.length()) {
                char c = keySeq.charAt(i);
                if (c >= map.mapping.length) {
                    return;
                }
                if (i < keySeq.length() - 1) {
                    if (!(map.mapping[c] instanceof KeyMap)) {
                        KeyMap m = new KeyMap("anonymous");
                        if (map.mapping[c] != Operation.DO_LOWERCASE_VERSION) {
                            m.anotherKey = map.mapping[c];
                        }
                        map.mapping[c] = m;
                    }
                    map = (KeyMap)map.mapping[c];
                } else {
                    if (function == null) {
                        function = NULL_FUNCTION;
                    }
                    if (map.mapping[c] instanceof KeyMap) {
                        map.anotherKey = function;
                    } else {
                        Object op = map.mapping[c];
                        if (onlyIfNotBound && op != null && op != Operation.DO_LOWERCASE_VERSION) {
                        }
                        map.mapping[c] = function;
                    }
                }
                ++i;
            }
        }
    }

    public void setBlinkMatchingParen(boolean on) {
        if (on) {
            this.bind("}", (Object)Operation.INSERT_CLOSE_CURLY);
            this.bind(")", (Object)Operation.INSERT_CLOSE_PAREN);
            this.bind("]", (Object)Operation.INSERT_CLOSE_SQUARE);
        }
    }

    private static void bindArrowKeys(KeyMap map) {
        KeyMap.bind(map, "\u001b[0A", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map, "\u001b[0B", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map, "\u001b[0C", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map, "\u001b[0D", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map, "\u00e0\u0000", (Object)Operation.KILL_WHOLE_LINE);
        KeyMap.bind(map, "\u00e0G", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map, "\u00e0H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map, "\u00e0I", (Object)Operation.BEGINNING_OF_HISTORY);
        KeyMap.bind(map, "\u00e0K", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map, "\u00e0M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map, "\u00e0O", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map, "\u00e0P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map, "\u00e0Q", (Object)Operation.END_OF_HISTORY);
        KeyMap.bind(map, "\u00e0R", (Object)Operation.OVERWRITE_MODE);
        KeyMap.bind(map, "\u00e0S", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(map, "\u0000G", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map, "\u0000H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map, "\u0000I", (Object)Operation.BEGINNING_OF_HISTORY);
        KeyMap.bind(map, "\u0000H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map, "\u0000K", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map, "\u0000M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map, "\u0000O", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map, "\u0000P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map, "\u0000Q", (Object)Operation.END_OF_HISTORY);
        KeyMap.bind(map, "\u0000R", (Object)Operation.OVERWRITE_MODE);
        KeyMap.bind(map, "\u0000S", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(map, "\u001b[A", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map, "\u001b[B", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map, "\u001b[C", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map, "\u001b[D", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map, "\u001b[H", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map, "\u001b[F", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map, "\u001bOA", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map, "\u001bOB", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map, "\u001bOC", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map, "\u001bOD", (Object)Operation.BACKWARD_CHAR);
        KeyMap.bind(map, "\u001bOH", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map, "\u001bOF", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map, "\u001b[1~", (Object)Operation.BEGINNING_OF_LINE);
        KeyMap.bind(map, "\u001b[4~", (Object)Operation.END_OF_LINE);
        KeyMap.bind(map, "\u001b[3~", (Object)Operation.DELETE_CHAR);
        KeyMap.bind(map, "\u001c0H", (Object)Operation.PREVIOUS_HISTORY);
        KeyMap.bind(map, "\u001c0P", (Object)Operation.NEXT_HISTORY);
        KeyMap.bind(map, "\u001c0M", (Object)Operation.FORWARD_CHAR);
        KeyMap.bind(map, "\u001c0K", (Object)Operation.BACKWARD_CHAR);
    }

    public static boolean isMeta(char c) {
        return c > '\u007f' && c <= '\u00ff';
    }

    public static char unMeta(char c) {
        return (char)(c & 0x7F);
    }

    public static char meta(char c) {
        return (char)(c | 0x80);
    }

    public static Map<String, KeyMap> keyMaps() {
        HashMap<String, KeyMap> keyMaps = new HashMap<String, KeyMap>();
        KeyMap emacs = KeyMap.emacs();
        KeyMap.bindArrowKeys(emacs);
        keyMaps.put(EMACS, emacs);
        keyMaps.put(EMACS_STANDARD, emacs);
        keyMaps.put(EMACS_CTLX, (KeyMap)emacs.getBound("\u0018"));
        keyMaps.put(EMACS_META, (KeyMap)emacs.getBound("\u001b"));
        KeyMap viMov = KeyMap.viMovement();
        KeyMap.bindArrowKeys(viMov);
        keyMaps.put(VI_MOVE, viMov);
        keyMaps.put("vi-command", viMov);
        keyMaps.put("vi", viMov);
        KeyMap viIns = KeyMap.viInsertion();
        KeyMap.bindArrowKeys(viIns);
        keyMaps.put(VI_INSERT, viIns);
        return keyMaps;
    }

    public static KeyMap emacs() {
        Object[] map = new Object[256];
        Object[] objectArray = new Object[32];
        objectArray[0] = Operation.SET_MARK;
        objectArray[1] = Operation.BEGINNING_OF_LINE;
        objectArray[2] = Operation.BACKWARD_CHAR;
        objectArray[3] = Operation.INTERRUPT;
        objectArray[4] = Operation.EXIT_OR_DELETE_CHAR;
        objectArray[5] = Operation.END_OF_LINE;
        objectArray[6] = Operation.FORWARD_CHAR;
        objectArray[7] = Operation.ABORT;
        objectArray[8] = Operation.BACKWARD_DELETE_CHAR;
        objectArray[9] = Operation.COMPLETE;
        objectArray[10] = Operation.ACCEPT_LINE;
        objectArray[11] = Operation.KILL_LINE;
        objectArray[12] = Operation.CLEAR_SCREEN;
        objectArray[13] = Operation.ACCEPT_LINE;
        objectArray[14] = Operation.NEXT_HISTORY;
        objectArray[16] = Operation.PREVIOUS_HISTORY;
        objectArray[17] = Operation.QUOTED_INSERT;
        objectArray[18] = Operation.REVERSE_SEARCH_HISTORY;
        objectArray[19] = Operation.FORWARD_SEARCH_HISTORY;
        objectArray[20] = Operation.TRANSPOSE_CHARS;
        objectArray[21] = Operation.UNIX_LINE_DISCARD;
        objectArray[22] = Operation.QUOTED_INSERT;
        objectArray[23] = Operation.UNIX_WORD_RUBOUT;
        objectArray[24] = KeyMap.emacsCtrlX();
        objectArray[25] = Operation.YANK;
        objectArray[27] = KeyMap.emacsMeta();
        objectArray[29] = Operation.CHARACTER_SEARCH;
        objectArray[31] = Operation.UNDO;
        Object[] ctrl = objectArray;
        System.arraycopy(ctrl, 0, map, 0, ctrl.length);
        int i = 32;
        while (i < 256) {
            map[i] = Operation.SELF_INSERT;
            ++i;
        }
        map[127] = Operation.BACKWARD_DELETE_CHAR;
        return new KeyMap(EMACS, map);
    }

    public static KeyMap emacsCtrlX() {
        Object[] map = new Object[256];
        map[7] = Operation.ABORT;
        map[18] = Operation.RE_READ_INIT_FILE;
        map[21] = Operation.UNDO;
        map[24] = Operation.EXCHANGE_POINT_AND_MARK;
        map[40] = Operation.START_KBD_MACRO;
        map[41] = Operation.END_KBD_MACRO;
        int i = 65;
        while (i <= 90) {
            map[i] = Operation.DO_LOWERCASE_VERSION;
            ++i;
        }
        map[101] = Operation.CALL_LAST_KBD_MACRO;
        map[127] = Operation.KILL_LINE;
        return new KeyMap(EMACS_CTLX, map);
    }

    public static KeyMap emacsMeta() {
        Object[] map = new Object[256];
        map[7] = Operation.ABORT;
        map[8] = Operation.BACKWARD_KILL_WORD;
        map[9] = Operation.TAB_INSERT;
        map[10] = Operation.VI_EDITING_MODE;
        map[13] = Operation.VI_EDITING_MODE;
        map[18] = Operation.REVERT_LINE;
        map[25] = Operation.YANK_NTH_ARG;
        map[27] = Operation.COMPLETE;
        map[29] = Operation.CHARACTER_SEARCH_BACKWARD;
        map[32] = Operation.SET_MARK;
        map[35] = Operation.INSERT_COMMENT;
        map[38] = Operation.TILDE_EXPAND;
        map[42] = Operation.INSERT_COMPLETIONS;
        map[45] = Operation.DIGIT_ARGUMENT;
        map[46] = Operation.YANK_LAST_ARG;
        map[60] = Operation.BEGINNING_OF_HISTORY;
        map[61] = Operation.POSSIBLE_COMPLETIONS;
        map[62] = Operation.END_OF_HISTORY;
        map[63] = Operation.POSSIBLE_COMPLETIONS;
        int i = 65;
        while (i <= 90) {
            map[i] = Operation.DO_LOWERCASE_VERSION;
            ++i;
        }
        map[92] = Operation.DELETE_HORIZONTAL_SPACE;
        map[95] = Operation.YANK_LAST_ARG;
        map[98] = Operation.BACKWARD_WORD;
        map[99] = Operation.CAPITALIZE_WORD;
        map[100] = Operation.KILL_WORD;
        map[102] = Operation.FORWARD_WORD;
        map[108] = Operation.DOWNCASE_WORD;
        map[112] = Operation.NON_INCREMENTAL_REVERSE_SEARCH_HISTORY;
        map[114] = Operation.REVERT_LINE;
        map[116] = Operation.TRANSPOSE_WORDS;
        map[117] = Operation.UPCASE_WORD;
        map[121] = Operation.YANK_POP;
        map[126] = Operation.TILDE_EXPAND;
        map[127] = Operation.BACKWARD_KILL_WORD;
        return new KeyMap(EMACS_META, map);
    }

    public static KeyMap viInsertion() {
        Object[] map = new Object[256];
        Object[] objectArray = new Object[32];
        objectArray[1] = Operation.SELF_INSERT;
        objectArray[2] = Operation.SELF_INSERT;
        objectArray[3] = Operation.SELF_INSERT;
        objectArray[4] = Operation.VI_EOF_MAYBE;
        objectArray[5] = Operation.SELF_INSERT;
        objectArray[6] = Operation.SELF_INSERT;
        objectArray[7] = Operation.SELF_INSERT;
        objectArray[8] = Operation.BACKWARD_DELETE_CHAR;
        objectArray[9] = Operation.COMPLETE;
        objectArray[10] = Operation.ACCEPT_LINE;
        objectArray[11] = Operation.SELF_INSERT;
        objectArray[12] = Operation.SELF_INSERT;
        objectArray[13] = Operation.ACCEPT_LINE;
        objectArray[14] = Operation.MENU_COMPLETE;
        objectArray[15] = Operation.SELF_INSERT;
        objectArray[16] = Operation.MENU_COMPLETE_BACKWARD;
        objectArray[17] = Operation.SELF_INSERT;
        objectArray[18] = Operation.REVERSE_SEARCH_HISTORY;
        objectArray[19] = Operation.FORWARD_SEARCH_HISTORY;
        objectArray[20] = Operation.TRANSPOSE_CHARS;
        objectArray[21] = Operation.UNIX_LINE_DISCARD;
        objectArray[22] = Operation.QUOTED_INSERT;
        objectArray[23] = Operation.UNIX_WORD_RUBOUT;
        objectArray[24] = Operation.SELF_INSERT;
        objectArray[25] = Operation.YANK;
        objectArray[26] = Operation.SELF_INSERT;
        objectArray[27] = Operation.VI_MOVEMENT_MODE;
        objectArray[28] = Operation.SELF_INSERT;
        objectArray[29] = Operation.SELF_INSERT;
        objectArray[30] = Operation.SELF_INSERT;
        objectArray[31] = Operation.UNDO;
        Object[] ctrl = objectArray;
        System.arraycopy(ctrl, 0, map, 0, ctrl.length);
        int i = 32;
        while (i < 256) {
            map[i] = Operation.SELF_INSERT;
            ++i;
        }
        map[127] = Operation.BACKWARD_DELETE_CHAR;
        return new KeyMap(VI_INSERT, map);
    }

    public static KeyMap viMovement() {
        Object[] map = new Object[256];
        Object[] objectArray = new Object[128];
        objectArray[3] = Operation.INTERRUPT;
        objectArray[4] = Operation.VI_EOF_MAYBE;
        objectArray[5] = Operation.EMACS_EDITING_MODE;
        objectArray[7] = Operation.ABORT;
        objectArray[8] = Operation.BACKWARD_CHAR;
        objectArray[10] = Operation.VI_MOVE_ACCEPT_LINE;
        objectArray[11] = Operation.KILL_LINE;
        objectArray[12] = Operation.CLEAR_SCREEN;
        objectArray[13] = Operation.VI_MOVE_ACCEPT_LINE;
        objectArray[14] = Operation.VI_NEXT_HISTORY;
        objectArray[16] = Operation.VI_PREVIOUS_HISTORY;
        objectArray[17] = Operation.QUOTED_INSERT;
        objectArray[18] = Operation.REVERSE_SEARCH_HISTORY;
        objectArray[19] = Operation.FORWARD_SEARCH_HISTORY;
        objectArray[20] = Operation.TRANSPOSE_CHARS;
        objectArray[21] = Operation.UNIX_LINE_DISCARD;
        objectArray[22] = Operation.QUOTED_INSERT;
        objectArray[23] = Operation.UNIX_WORD_RUBOUT;
        objectArray[25] = Operation.YANK;
        objectArray[27] = KeyMap.emacsMeta();
        objectArray[29] = Operation.CHARACTER_SEARCH;
        objectArray[31] = Operation.UNDO;
        objectArray[32] = Operation.FORWARD_CHAR;
        objectArray[35] = Operation.VI_INSERT_COMMENT;
        objectArray[36] = Operation.END_OF_LINE;
        objectArray[37] = Operation.VI_MATCH;
        objectArray[38] = Operation.VI_TILDE_EXPAND;
        objectArray[42] = Operation.VI_COMPLETE;
        objectArray[43] = Operation.VI_NEXT_HISTORY;
        objectArray[44] = Operation.VI_CHAR_SEARCH;
        objectArray[45] = Operation.VI_PREVIOUS_HISTORY;
        objectArray[46] = Operation.VI_REDO;
        objectArray[47] = Operation.VI_SEARCH;
        objectArray[48] = Operation.VI_BEGINNING_OF_LINE_OR_ARG_DIGIT;
        objectArray[49] = Operation.VI_ARG_DIGIT;
        objectArray[50] = Operation.VI_ARG_DIGIT;
        objectArray[51] = Operation.VI_ARG_DIGIT;
        objectArray[52] = Operation.VI_ARG_DIGIT;
        objectArray[53] = Operation.VI_ARG_DIGIT;
        objectArray[54] = Operation.VI_ARG_DIGIT;
        objectArray[55] = Operation.VI_ARG_DIGIT;
        objectArray[56] = Operation.VI_ARG_DIGIT;
        objectArray[57] = Operation.VI_ARG_DIGIT;
        objectArray[59] = Operation.VI_CHAR_SEARCH;
        objectArray[61] = Operation.VI_COMPLETE;
        objectArray[63] = Operation.VI_SEARCH;
        objectArray[65] = Operation.VI_APPEND_EOL;
        objectArray[66] = Operation.VI_PREV_WORD;
        objectArray[67] = Operation.VI_CHANGE_TO_EOL;
        objectArray[68] = Operation.VI_DELETE_TO_EOL;
        objectArray[69] = Operation.VI_END_WORD;
        objectArray[70] = Operation.VI_CHAR_SEARCH;
        objectArray[71] = Operation.VI_FETCH_HISTORY;
        objectArray[73] = Operation.VI_INSERT_BEG;
        objectArray[78] = Operation.VI_SEARCH_AGAIN;
        objectArray[80] = Operation.VI_PUT;
        objectArray[82] = Operation.VI_REPLACE;
        objectArray[83] = Operation.VI_KILL_WHOLE_LINE;
        objectArray[84] = Operation.VI_CHAR_SEARCH;
        objectArray[85] = Operation.REVERT_LINE;
        objectArray[87] = Operation.VI_NEXT_WORD;
        objectArray[88] = Operation.VI_RUBOUT;
        objectArray[89] = Operation.VI_YANK_TO;
        objectArray[92] = Operation.VI_COMPLETE;
        objectArray[94] = Operation.VI_FIRST_PRINT;
        objectArray[95] = Operation.VI_YANK_ARG;
        objectArray[96] = Operation.VI_GOTO_MARK;
        objectArray[97] = Operation.VI_APPEND_MODE;
        objectArray[98] = Operation.VI_PREV_WORD;
        objectArray[99] = Operation.VI_CHANGE_TO;
        objectArray[100] = Operation.VI_DELETE_TO;
        objectArray[101] = Operation.VI_END_WORD;
        objectArray[102] = Operation.VI_CHAR_SEARCH;
        objectArray[104] = Operation.BACKWARD_CHAR;
        objectArray[105] = Operation.VI_INSERTION_MODE;
        objectArray[106] = Operation.NEXT_HISTORY;
        objectArray[107] = Operation.PREVIOUS_HISTORY;
        objectArray[108] = Operation.FORWARD_CHAR;
        objectArray[109] = Operation.VI_SET_MARK;
        objectArray[110] = Operation.VI_SEARCH_AGAIN;
        objectArray[112] = Operation.VI_PUT;
        objectArray[114] = Operation.VI_CHANGE_CHAR;
        objectArray[115] = Operation.VI_SUBST;
        objectArray[116] = Operation.VI_CHAR_SEARCH;
        objectArray[117] = Operation.UNDO;
        objectArray[119] = Operation.VI_NEXT_WORD;
        objectArray[120] = Operation.VI_DELETE;
        objectArray[121] = Operation.VI_YANK_TO;
        objectArray[124] = Operation.VI_COLUMN;
        objectArray[126] = Operation.VI_CHANGE_CASE;
        objectArray[127] = Operation.VI_DELETE;
        Object[] low = objectArray;
        System.arraycopy(low, 0, map, 0, low.length);
        int i = 128;
        while (i < 256) {
            map[i] = null;
            ++i;
        }
        return new KeyMap(VI_MOVE, map);
    }
}

