/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jline.console.KeyMap;
import jline.console.Operation;
import jline.internal.Log;

public class ConsoleKeys {
    private KeyMap keys;
    private Map<String, KeyMap> keyMaps;
    private Map<String, String> variables = new HashMap<String, String>();

    public ConsoleKeys(String appName, URL inputrcUrl) {
        this.keyMaps = KeyMap.keyMaps();
        this.setVar("editing-mode", "emacs");
        this.loadKeys(appName, inputrcUrl);
        String editingMode = this.variables.get("editing-mode");
        if ("vi".equalsIgnoreCase(editingMode)) {
            this.keys = this.keyMaps.get("vi-insert");
        } else if ("emacs".equalsIgnoreCase(editingMode)) {
            this.keys = this.keyMaps.get("emacs");
        }
    }

    protected boolean setKeyMap(String name) {
        KeyMap map = this.keyMaps.get(name);
        if (map == null) {
            return false;
        }
        this.keys = map;
        return true;
    }

    protected Map<String, KeyMap> getKeyMaps() {
        return this.keyMaps;
    }

    protected KeyMap getKeys() {
        return this.keys;
    }

    protected void setKeys(KeyMap keys) {
        this.keys = keys;
    }

    protected void loadKeys(String appName, URL inputrcUrl) {
        this.keys = this.keyMaps.get("emacs");
        try {
            InputStream input = inputrcUrl.openStream();
            try {
                this.loadKeys(input, appName);
                Log.debug("Loaded user configuration: ", inputrcUrl);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            if (inputrcUrl.getProtocol().equals("file")) {
                File file = new File(inputrcUrl.getPath());
                if (file.exists()) {
                    Log.warn("Unable to read user configuration: ", inputrcUrl, e);
                }
            }
            Log.warn("Unable to read user configuration: ", inputrcUrl, e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadKeys(InputStream input, String appName) throws IOException {
        reader = new BufferedReader(new InputStreamReader(input));
        parsing = true;
        ifsStack = new ArrayList<Boolean>();
        while ((line = reader.readLine()) != null) {
            try {
                block39: {
                    line = line.trim();
                    if (line.length() == 0 || line.charAt(0) == '#') continue;
                    i = 0;
                    if (line.charAt(i) == '$') {
                        ++i;
                        while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                            ++i;
                        }
                        s = i;
                        while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                            ++i;
                        }
                        cmd = line.substring(s, i);
                        while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                            ++i;
                        }
                        s = i;
                        while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                            ++i;
                        }
                        args = line.substring(s, i);
                        if ("if".equalsIgnoreCase(cmd)) {
                            ifsStack.add(parsing);
                            if (!parsing || args.startsWith("term=")) continue;
                            if (args.startsWith("mode=")) {
                                mode = this.variables.get("editing-mode");
                                parsing = args.substring("mode=".length()).equalsIgnoreCase(mode);
                                continue;
                            }
                            parsing = args.equalsIgnoreCase(appName);
                            continue;
                        }
                        if ("else".equalsIgnoreCase(cmd)) {
                            if (ifsStack.isEmpty()) {
                                throw new IllegalArgumentException("$else found without matching $if");
                            }
                            invert = true;
                            var13_25 = ifsStack.iterator();
                            while (var13_25.hasNext()) {
                                b = (Boolean)var13_25.next();
                                if (b) continue;
                                invert = false;
                                break;
                            }
                            if (!invert) continue;
                            parsing = parsing == false;
                            continue;
                        }
                        if ("endif".equalsIgnoreCase(cmd)) {
                            if (ifsStack.isEmpty()) {
                                throw new IllegalArgumentException("endif found without matching $if");
                            }
                            parsing = (Boolean)ifsStack.remove(ifsStack.size() - 1);
                            continue;
                        }
                        "include".equalsIgnoreCase(cmd);
                        continue;
                    }
                    if (!parsing) continue;
                    keySeq = "";
                    if (line.charAt(i++) != '\"') ** GOTO lbl78
                    esc = false;
                    while (true) {
                        block41: {
                            block42: {
                                block40: {
                                    if (i >= line.length()) {
                                        throw new IllegalArgumentException("Missing closing quote on line '" + line + "'");
                                    }
                                    if (!esc) break block40;
                                    esc = false;
                                    break block41;
                                }
                                if (line.charAt(i) != '\\') break block42;
                                esc = true;
                                break block41;
                            }
                            if (line.charAt(i) == '\"') ** GOTO lbl78
                        }
                        ++i;
                    }
lbl-1000:
                    // 1 sources

                    {
                        ++i;
lbl78:
                        // 3 sources

                        ** while (i < line.length() && line.charAt((int)i) != ':' && line.charAt((int)i) != ' ' && line.charAt((int)i) != '\t')
                    }
lbl79:
                    // 1 sources

                    keySeq = line.substring(0, i);
                    equivalency = i + 1 < line.length() && line.charAt(i) == ':' && line.charAt(i + 1) == '=';
                    ++i;
                    if (equivalency) {
                        ++i;
                    }
                    if (!keySeq.equalsIgnoreCase("set")) ** GOTO lbl104
                    while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                        ++i;
                    }
                    s = i;
                    while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                        ++i;
                    }
                    key = line.substring(s, i);
                    while (i < line.length() && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                        ++i;
                    }
                    s = i;
                    while (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') {
                        ++i;
                    }
                    val = line.substring(s, i);
                    this.setVar(key, val);
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        ++i;
lbl104:
                        // 2 sources

                        ** while (i < line.length() && (line.charAt((int)i) == ' ' || line.charAt((int)i) == '\t'))
                    }
lbl105:
                    // 1 sources

                    start = i;
                    if (i < line.length() && (line.charAt(i) == '\'' || line.charAt(i) == '\"')) {
                        delim = line.charAt(i++);
                        esc = false;
                        while (i < line.length()) {
                            if (esc) {
                                esc = false;
                            } else if (line.charAt(i) == '\\') {
                                esc = true;
                            } else if (line.charAt(i) == delim) break block39;
                            ++i;
                        }
                        break block39;
                        while (true) {
                            ++i;
                            break;
                        }
                    }
                }
                if (i < line.length() && line.charAt(i) != ' ' && line.charAt(i) != '\t') ** continue;
                val = line.substring(Math.min(start, line.length()), Math.min(i, line.length()));
                if (keySeq.charAt(0) == '\"') {
                    keySeq = ConsoleKeys.translateQuoted(keySeq);
                } else {
                    keyName = keySeq.lastIndexOf(45) > 0 ? keySeq.substring(keySeq.lastIndexOf(45) + 1) : keySeq;
                    key = ConsoleKeys.getKeyFromName(keyName);
                    keyName = keySeq.toLowerCase();
                    keySeq = "";
                    if (keyName.contains("meta-") || keyName.contains("m-")) {
                        keySeq = String.valueOf(keySeq) + "\u001b";
                    }
                    if (keyName.contains("control-") || keyName.contains("c-") || keyName.contains("ctrl-")) {
                        key = (char)(Character.toUpperCase(key) & 31);
                    }
                    keySeq = String.valueOf(keySeq) + key;
                }
                if (val.length() > 0 && (val.charAt(0) == '\'' || val.charAt(0) == '\"')) {
                    this.keys.bind(keySeq, ConsoleKeys.translateQuoted(val));
                    continue;
                }
                operationName = val.replace('-', '_').toUpperCase();
                try {
                    this.keys.bind(keySeq, (Object)Operation.valueOf(operationName));
                }
                catch (IllegalArgumentException e) {
                    Log.info(new Object[]{"Unable to bind key for unsupported operation: ", val});
                }
            }
            catch (IllegalArgumentException e) {
                Log.warn(new Object[]{"Unable to parse user configuration: ", e});
            }
        }
    }

    private static String translateQuoted(String keySeq) {
        String str = keySeq.substring(1, keySeq.length() - 1);
        keySeq = "";
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '\\') {
                boolean meta;
                boolean ctrl = str.regionMatches(i, "\\C-", 0, 3) || str.regionMatches(i, "\\M-\\C-", 0, 6);
                if ((i += ((meta = str.regionMatches(i, "\\M-", 0, 3) || str.regionMatches(i, "\\C-\\M-", 0, 6)) ? 3 : 0) + (ctrl ? 3 : 0) + (!meta && !ctrl ? 1 : 0)) >= str.length()) break;
                c = str.charAt(i);
                if (meta) {
                    keySeq = String.valueOf(keySeq) + "\u001b";
                }
                if (ctrl) {
                    char c2 = c = c == '?' ? (char)'\u007f' : (char)(Character.toUpperCase(c) & 0x1F);
                }
                if (!meta && !ctrl) {
                    block0 : switch (c) {
                        case 'a': {
                            c = '\u0007';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'd': {
                            c = '\u007f';
                            break;
                        }
                        case 'e': {
                            c = '\u001b';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'v': {
                            c = '\u000b';
                            break;
                        }
                        case '\\': {
                            c = '\\';
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            int k;
                            c = '\u0000';
                            int j = 0;
                            while (j < 3) {
                                if (i >= str.length() || (k = Character.digit(str.charAt(i), 8)) < 0) break;
                                c = (char)(c * 8 + k);
                                ++j;
                                ++i;
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 'x': {
                            int k;
                            ++i;
                            c = '\u0000';
                            int j = 0;
                            while (j < 2) {
                                if (i >= str.length() || (k = Character.digit(str.charAt(i), 16)) < 0) break;
                                c = (char)(c * 16 + k);
                                ++j;
                                ++i;
                            }
                            c = (char)(c & 0xFF);
                            break;
                        }
                        case 'u': {
                            int k;
                            ++i;
                            c = '\u0000';
                            int j = 0;
                            while (j < 4) {
                                if (i >= str.length() || (k = Character.digit(str.charAt(i), 16)) < 0) break block0;
                                c = (char)(c * 16 + k);
                                ++j;
                                ++i;
                            }
                            break;
                        }
                    }
                }
                keySeq = String.valueOf(keySeq) + c;
            } else {
                keySeq = String.valueOf(keySeq) + c;
            }
            ++i;
        }
        return keySeq;
    }

    private static char getKeyFromName(String name) {
        if ("DEL".equalsIgnoreCase(name) || "Rubout".equalsIgnoreCase(name)) {
            return '\u007f';
        }
        if ("ESC".equalsIgnoreCase(name) || "Escape".equalsIgnoreCase(name)) {
            return '\u001b';
        }
        if ("LFD".equalsIgnoreCase(name) || "NewLine".equalsIgnoreCase(name)) {
            return '\n';
        }
        if ("RET".equalsIgnoreCase(name) || "Return".equalsIgnoreCase(name)) {
            return '\r';
        }
        if ("SPC".equalsIgnoreCase(name) || "Space".equalsIgnoreCase(name)) {
            return ' ';
        }
        if ("Tab".equalsIgnoreCase(name)) {
            return '\t';
        }
        return name.charAt(0);
    }

    private void setVar(String key, String val) {
        if ("keymap".equalsIgnoreCase(key)) {
            if (this.keyMaps.containsKey(val)) {
                this.keys = this.keyMaps.get(val);
            }
        } else if ("blink-matching-paren".equals(key)) {
            if ("on".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(true);
            } else if ("off".equalsIgnoreCase(val)) {
                this.keys.setBlinkMatchingParen(false);
            }
        }
        this.variables.put(key, val);
    }

    public String getVariable(String var) {
        return this.variables.get(var);
    }
}

