/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Vector;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.Window;
import jcurses.widgets.WindowManagerBlockingCondition;
import jcurses.widgets.WindowManagerInputThread;

class WindowManager {
    private static Vector __windowsStack = new Vector();
    private static CharColor __defaultScreenColors = new CharColor(4, 4);
    private static CharColor __colors = WindowManager.getDefaultScreenColors();
    private static WindowManagerInputThread _inthread = new WindowManagerInputThread();

    WindowManager() {
    }

    static synchronized void invokeAndWait(Runnable r) {
        r.run();
    }

    public static CharColor getScreenColors() {
        return __colors;
    }

    public static void setScreenColors(CharColor colors) {
        __colors = colors;
    }

    protected static CharColor getDefaultScreenColors() {
        return __defaultScreenColors;
    }

    protected static void createWindow(Window w) {
        if (__windowsStack.size() == 0) {
            WindowManager.init();
        }
        __windowsStack.add(w);
    }

    protected static void removeWindow(Window w) {
        if (__windowsStack.indexOf(w) != -1) {
            WindowManager.removeWindowFromScreen(w);
            __windowsStack.remove(w);
            w.closed();
            if (WindowManager.getTopWindow() == null) {
                WindowManager.shutdown();
            } else {
                WindowManager.getTopWindow().activate();
            }
        }
    }

    protected static void makeWindowVisible(Window w, Window oldTop) {
        Toolkit.startPainting();
        if (__windowsStack.indexOf(w) != -1) {
            int index;
            int i = index = __windowsStack.indexOf(w);
            while (i < __windowsStack.size()) {
                Window aw = (Window)__windowsStack.elementAt(i);
                if (aw.isVisible()) {
                    aw.paint();
                }
                ++i;
            }
        }
        if (WindowManager.getTopWindow() != oldTop) {
            if (oldTop != null) {
                oldTop.deactivate();
            }
            WindowManager.getTopWindow().activate();
        }
        Toolkit.endPainting();
    }

    protected static void makeWindowInvisible(Window w, Window oldTop) {
        if (__windowsStack.indexOf(w) != -1) {
            if (WindowManager.getTopWindow() == null) {
                WindowManager.shutdown();
            } else {
                WindowManager.removeWindowFromScreen(w);
                if (w == oldTop) {
                    w.deactivate();
                    if (WindowManager.getTopWindow() == null) {
                        WindowManager.getTopWindow().activate();
                    }
                }
            }
        }
    }

    private static void removeWindowFromScreen(Window w) {
        Toolkit.startPainting();
        int index = __windowsStack.indexOf(w);
        if (!WindowManager.wasPartVisible(index)) {
            Toolkit.endPainting();
            return;
        }
        Rectangle rect = w.getRectangle();
        if (w.hasShadow()) {
            rect = (Rectangle)rect.clone();
            rect.resize(rect.getWidth() + 1, rect.getHeight() + 1);
        }
        Toolkit.drawRectangle(rect, WindowManager.getScreenColors());
        int i = 0;
        while (i < index) {
            Window aw = (Window)__windowsStack.elementAt(i);
            if (aw.isVisible()) {
                Rectangle clipRect;
                Rectangle rect2 = aw.getRectangle();
                if (aw.hasShadow()) {
                    rect2 = (Rectangle)rect2.clone();
                    rect2.resize(rect2.getWidth() + 1, rect2.getHeight() + 1);
                }
                if (!(clipRect = rect.intersection(rect2)).isEmpty() && WindowManager.isToBeRepainted(clipRect, i, index)) {
                    Toolkit.setClipRectangle(clipRect);
                    aw.repaint();
                    Toolkit.unsetClipRectangle();
                }
            }
            ++i;
        }
        Toolkit.endPainting();
    }

    private static boolean isToBeRepainted(Rectangle clipRect, int index, int endIndex) {
        boolean result = true;
        int i = index + 1;
        while (i < endIndex) {
            Window aw = (Window)__windowsStack.elementAt(i);
            if (aw.isVisible() && aw.getRectangle().contains(clipRect)) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    private static boolean wasPartVisible(int index) {
        boolean result = true;
        int i = index + 1;
        while (i < __windowsStack.size()) {
            Window aw1;
            Window aw = (Window)__windowsStack.elementAt(index);
            Rectangle rect2 = aw.getRectangle();
            if (aw.hasShadow()) {
                rect2 = (Rectangle)rect2.clone();
                rect2.resize(rect2.getWidth() + 1, rect2.getHeight() + 1);
            }
            if ((aw1 = (Window)__windowsStack.elementAt(i)).isVisible() && aw1.getRectangle().contains(rect2)) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    protected static void moveToTop(Window w) {
        Window oldTop = WindowManager.getTopWindow();
        if (__windowsStack.indexOf(w) != -1) {
            __windowsStack.remove(w);
            __windowsStack.add(w);
            Toolkit.startPainting();
            w.paint();
            Toolkit.endPainting();
            if (oldTop != null) {
                oldTop.deactivate();
            }
            w.activate();
        }
    }

    protected static Window getTopWindow() {
        Window result = null;
        int i = 0;
        while (i < __windowsStack.size()) {
            Window window = (Window)__windowsStack.elementAt(__windowsStack.size() - i - 1);
            if (window.isVisible()) {
                result = window;
                break;
            }
            ++i;
        }
        return result;
    }

    public static synchronized void init() {
        Toolkit.clearScreen(WindowManager.getScreenColors());
        WindowManager.startInputThread();
    }

    private static synchronized void shutdown() {
        WindowManager.deactivateInputThread();
        Toolkit.shutdown();
        WindowManager.stopInputThread();
    }

    private static synchronized void startInputThread() {
        _inthread.start();
    }

    private static synchronized void stopInputThread() {
        _inthread.end();
    }

    private static synchronized void deactivateInputThread() {
        _inthread.deactivate();
    }

    public static void blockInputThread(WindowManagerBlockingCondition cond) {
        _inthread.block(cond);
    }

    public static boolean isInputThread() {
        return Thread.currentThread() == _inthread;
    }

    protected static synchronized void handleInput(InputChar input) {
        Window tw = WindowManager.getTopWindow();
        Toolkit.startPainting();
        if (tw != null) {
            try {
                tw.handleInput(input);
            }
            catch (Throwable e) {
                Toolkit.shutdown();
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (_inthread.isRunning()) {
            Toolkit.endPainting();
        }
    }
}

