/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Hashtable;
import java.util.Vector;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.DefaultLayoutManager;
import jcurses.widgets.LayoutManager;
import jcurses.widgets.Widget;

public abstract class WidgetContainer
extends Widget {
    private Vector _widgets = new Vector();
    private Hashtable _constraints = new Hashtable();
    private LayoutManager _layoutManager = null;

    protected abstract void paintSelf();

    private Rectangle getChildsClippingRectangle() {
        Rectangle rect = this.getChildsRectangle() == null ? this.getSize() : this.getChildsRectangle();
        int x = this.getAbsoluteX() + rect.getX();
        int y = this.getAbsoluteY() + rect.getY();
        rect.setLocation(x, y);
        return rect;
    }

    @Override
    protected void doPaint() {
        this.paintSelf();
        Toolkit.setClipRectangle(this.getChildsClippingRectangle());
        int i = 0;
        while (i < this._widgets.size()) {
            Widget widget = (Widget)this._widgets.elementAt(i);
            widget.paint();
            ++i;
        }
        Toolkit.unsetClipRectangle();
    }

    protected abstract void repaintSelf();

    @Override
    protected void doRepaint() {
        this.repaintSelf();
        Toolkit.setClipRectangle(this.getChildsClippingRectangle());
        int i = 0;
        while (i < this._widgets.size()) {
            Widget widget = (Widget)this._widgets.elementAt(i);
            widget.repaint();
            ++i;
        }
        Toolkit.unsetClipRectangle();
    }

    private Rectangle getClippingRect(Rectangle rect, Widget widget) {
        Rectangle widgetRectangle = new Rectangle(widget.getAbsoluteX(), widget.getAbsoluteY(), widget.getSize().getWidth(), widget.getSize().getHeight());
        Rectangle clip = rect.intersection(widgetRectangle);
        return clip;
    }

    private void packChild(Widget widget, Object constraint) {
        this.getLayoutManager().layout(widget, constraint);
    }

    protected void pack() {
        int i = 0;
        while (i < this._widgets.size()) {
            Widget widget = (Widget)this._widgets.elementAt(i);
            this.packChild(widget, this._constraints.get(widget));
            if (widget instanceof WidgetContainer) {
                ((WidgetContainer)widget).pack();
            }
            ++i;
        }
    }

    protected void addWidget(Widget widget, Object constraint) {
        this._widgets.add(widget);
        this._constraints.put(widget, constraint);
        widget.setParent(this);
    }

    protected void removeWidget(Widget widget) {
        this._widgets.remove(widget);
        this._constraints.remove(widget);
        widget.setParent(null);
    }

    protected Vector getListOfFocusables() {
        Vector<Widget> result = new Vector<Widget>();
        int i = 0;
        while (i < this._widgets.size()) {
            Widget widget = (Widget)this._widgets.elementAt(i);
            if (widget.isFocusable() && widget.getVisible()) {
                result.add(widget);
            } else if (widget instanceof WidgetContainer) {
                result.addAll(((WidgetContainer)widget).getListOfFocusables());
            }
            ++i;
        }
        return result;
    }

    protected Vector getListOfWidgetsWithShortCuts() {
        Vector<Widget> result = new Vector<Widget>();
        int i = 0;
        while (i < this._widgets.size()) {
            Widget widget = (Widget)this._widgets.elementAt(i);
            if (widget.getShortCutsList() != null) {
                result.add(widget);
            } else if (widget instanceof WidgetContainer) {
                result.addAll(((WidgetContainer)widget).getListOfWidgetsWithShortCuts());
            }
            ++i;
        }
        return result;
    }

    protected Rectangle getChildsRectangle() {
        return null;
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        if (this._layoutManager != null) {
            this._layoutManager.unbindFromContainer();
        }
        this._layoutManager = layoutManager;
        this._layoutManager.bindToContainer(this);
    }

    public LayoutManager getLayoutManager() {
        if (this._layoutManager == null) {
            this.setLayoutManager(new DefaultLayoutManager());
        }
        return this._layoutManager;
    }
}

