/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Vector;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.util.Rectangle;
import jcurses.widgets.WidgetContainer;
import jcurses.widgets.Window;

public abstract class Widget {
    WidgetContainer _parent = null;
    Window _window = null;
    private int _x = 0;
    private int _y = 0;
    private Rectangle _size;
    private boolean _focus = false;
    private boolean _visible = true;
    private CharColor _colors = null;
    private static CharColor __defaultColors = new CharColor(7, 7);

    protected WidgetContainer getParent() {
        return this._parent;
    }

    protected void setParent(WidgetContainer parent) {
        this._parent = parent;
    }

    protected void setWindow(Window window) {
        this._window = window;
    }

    protected Window getWindow() {
        if (this.getParent() == null) {
            return this._window;
        }
        return this.getParent().getWindow();
    }

    protected void setX(int x) {
        this._x = x;
    }

    protected int getX() {
        return this._x;
    }

    protected int getAbsoluteX() {
        int result = 0;
        if (this.getParent() == null) {
            result = this._x;
        } else {
            result = this._x + this.getParent().getAbsoluteX();
            if (this.getParent().getChildsRectangle() != null) {
                result += this.getParent().getChildsRectangle().getX();
            }
        }
        return result;
    }

    protected void setY(int y) {
        this._y = y;
    }

    protected int getY() {
        return this._y;
    }

    protected int getAbsoluteY() {
        int result = 0;
        if (this.getParent() == null) {
            result = this._y;
        } else {
            result = this._y + this.getParent().getAbsoluteY();
            if (this.getParent().getChildsRectangle() != null) {
                result += this.getParent().getChildsRectangle().getY();
            }
        }
        return result;
    }

    protected Rectangle getRectangle() {
        Rectangle size = (Rectangle)this.getSize().clone();
        size.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        return size;
    }

    protected Rectangle getSize() {
        return (Rectangle)this._size.clone();
    }

    protected void setSize(Rectangle size) {
        this._size = size;
    }

    protected abstract Rectangle getPreferredSize();

    protected void paint() {
        if (this.isVisible()) {
            this.doPaint();
        }
    }

    protected abstract void doPaint();

    protected void repaint() {
        if (this.isVisible()) {
            this.doRepaint();
        }
    }

    protected abstract void doRepaint();

    protected boolean isFocusable() {
        return false;
    }

    public boolean hasFocus() {
        return this._focus;
    }

    public void getFocus() {
        if (this.getWindow() != null) {
            this.getWindow().changeFocus(this);
        }
    }

    void setFocus(boolean value) {
        this._focus = value;
        if (this._focus) {
            this.focus();
        } else {
            this.unfocus();
        }
    }

    protected void focus() {
    }

    protected void unfocus() {
    }

    protected boolean handleInput(InputChar inputChar) {
        return false;
    }

    protected Vector getShortCutsList() {
        return null;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public boolean getVisible() {
        return this._visible;
    }

    public boolean isVisible() {
        WidgetContainer parent = this.getParent();
        if (parent != null && !parent.isVisible()) {
            return false;
        }
        Window w = this.getWindow();
        boolean result = this._visible && w != null && w.isVisible();
        return result;
    }

    protected CharColor getDefaultColors() {
        return __defaultColors;
    }

    public void setColors(CharColor colors) {
        this._colors = colors;
    }

    public CharColor getColors() {
        return this._colors == null ? this.getDefaultColors() : this._colors;
    }
}

