/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.IScrollable;

public class ScrollbarPainter {
    private IScrollable _widget = null;
    private Rectangle _borderRectangle = null;
    private ScrollbarData _currentScrollbarData = null;

    public ScrollbarPainter(IScrollable widget) {
        this._widget = widget;
    }

    public void paint() {
        this._currentScrollbarData = this.readData();
        this.drawHorizontalScrollbar();
        this.drawVerticalScrollbar();
    }

    public void refresh() {
        ScrollbarData oldScrollbarData = this._currentScrollbarData;
        this._currentScrollbarData = this.readData();
        if (oldScrollbarData.horizontalOffset != this._currentScrollbarData.horizontalOffset || oldScrollbarData.horizontalLength != this._currentScrollbarData.horizontalLength) {
            this.refreshHorizontalScrollbar(oldScrollbarData);
        }
        if (oldScrollbarData.horizontalOffset != this._currentScrollbarData.horizontalOffset || oldScrollbarData.horizontalLength != this._currentScrollbarData.horizontalLength) {
            this.refreshVerticalScrollbar(oldScrollbarData);
        }
    }

    private ScrollbarData readData() {
        ScrollbarData result = new ScrollbarData();
        this._borderRectangle = this._widget.getBorderRectangle();
        int horizontalLength = this._borderRectangle.getWidth() - 2;
        int verticalLength = this._borderRectangle.getHeight() - 2;
        if (this._widget.hasHorizontalScrollbar() && this._widget.getHorizontalScrollbarLength() > 0.0f) {
            result.horizontalOffset = Math.round((float)horizontalLength * this._widget.getHorizontalScrollbarOffset());
            result.horizontalLength = Math.round((float)horizontalLength * this._widget.getHorizontalScrollbarLength());
            int n = result.horizontalLength = result.horizontalLength == 0 ? 1 : result.horizontalLength;
            if (result.horizontalLength + result.horizontalOffset > horizontalLength) {
                result.horizontalOffset = horizontalLength - result.horizontalLength;
            }
            if (horizontalLength == result.horizontalLength) {
                result.horizontalLength = 0;
            }
        }
        if (this._widget.hasVerticalScrollbar() && this._widget.getVerticalScrollbarLength() > 0.0f) {
            result.verticalOffset = Math.round((float)verticalLength * this._widget.getVerticalScrollbarOffset());
            result.verticalLength = Math.round((float)verticalLength * this._widget.getVerticalScrollbarLength());
            int n = result.verticalLength = result.verticalLength == 0 ? 1 : result.verticalLength;
            if (result.verticalLength + result.verticalOffset > verticalLength) {
                result.verticalOffset = verticalLength - result.verticalLength;
            }
            if (verticalLength == result.verticalLength) {
                result.verticalLength = 0;
            }
        }
        return result;
    }

    private void drawHorizontalScrollbar() {
        int offset = this._currentScrollbarData.horizontalOffset;
        int length = this._currentScrollbarData.horizontalLength;
        if (this._widget.hasHorizontalScrollbar() && length > 0) {
            Toolkit.drawHorizontalThickLine(this._borderRectangle.getX() + 1 + offset, this._borderRectangle.getY() + this._borderRectangle.getHeight() - 1, this._borderRectangle.getX() + offset + length, this._widget.getScrollbarColors());
        }
    }

    private void drawVerticalScrollbar() {
        int offset = this._currentScrollbarData.verticalOffset;
        int length = this._currentScrollbarData.verticalLength;
        if (this._widget.hasVerticalScrollbar() && length > 0) {
            Toolkit.drawVerticalThickLine(this._borderRectangle.getX() + this._borderRectangle.getWidth() - 1, this._borderRectangle.getY() + 1 + offset, this._borderRectangle.getY() + offset + length, this._widget.getScrollbarColors());
        }
    }

    private void refreshVerticalScrollbar(ScrollbarData old) {
        if (this._widget.hasVerticalScrollbar()) {
            if (old.verticalLength > 0) {
                Toolkit.drawVerticalLine(this._borderRectangle.getX() + this._borderRectangle.getWidth() - 1, this._borderRectangle.getY() + 1 + old.verticalOffset, this._borderRectangle.getY() + old.verticalOffset + old.verticalLength, this._widget.getBorderColors());
            }
            this.drawVerticalScrollbar();
        }
    }

    private void refreshHorizontalScrollbar(ScrollbarData old) {
        if (this._widget.hasHorizontalScrollbar()) {
            if (old.horizontalLength > 0) {
                Toolkit.drawHorizontalLine(this._borderRectangle.getX() + 1 + old.horizontalOffset, this._borderRectangle.getY() + this._borderRectangle.getHeight() - 1, this._borderRectangle.getX() + old.horizontalOffset + old.horizontalLength, this._widget.getBorderColors());
            }
            this.drawHorizontalScrollbar();
        }
    }

    private class ScrollbarData {
        int horizontalOffset = 0;
        int horizontalLength = 0;
        int verticalOffset = 0;
        int verticalLength = 0;

        private ScrollbarData() {
        }

        public String toString() {
            return "hoffset=" + this.horizontalOffset + ",hlength=" + this.horizontalLength + ",voffset=" + this.verticalOffset + ",vlength=" + this.verticalLength;
        }
    }
}

