/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Vector;
import jcurses.event.ValueChangedEvent;
import jcurses.event.ValueChangedListener;
import jcurses.event.ValueChangedListenerManager;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.PopUpMenu;
import jcurses.widgets.Widget;

public class PopUpList
extends Widget {
    private int _selectedIndex = -1;
    Vector _items = new Vector();
    private ValueChangedListenerManager _listenerManager = new ValueChangedListenerManager();
    private static CharColor __popUpDefaultColors = new CharColor(7, 0);
    private static CharColor __focusedPopUpDefaultColors = new CharColor(4, 7, 1);
    private CharColor _focusedPopUpColors = this.getFocusedPopUpDefaultColors();
    private static InputChar __changeValueChar = new InputChar('\n');

    @Override
    public CharColor getDefaultColors() {
        return __popUpDefaultColors;
    }

    private CharColor getFocusedPopUpDefaultColors() {
        return __focusedPopUpDefaultColors;
    }

    public CharColor getFocusedPopUpColors() {
        return this._focusedPopUpColors;
    }

    public void setFocusedPopUpColors(CharColor colors) {
        this._focusedPopUpColors = colors;
    }

    public void add(String item) {
        this._items.add(item);
    }

    public void add(int pos, String item) {
        this._items.add(pos, item);
    }

    public void remove(String item) {
        this._items.remove(item);
    }

    public void remove(int pos) {
        this._items.remove(pos);
    }

    public void clear() {
        this._items.clear();
    }

    public int getSelectedIndex() {
        if (this._selectedIndex != -1) {
            return this._selectedIndex;
        }
        if (this._items.size() > 0) {
            return 0;
        }
        return -1;
    }

    public String getSelectedItem() {
        if (this.getSelectedIndex() >= 0) {
            return (String)this._items.elementAt(this.getSelectedIndex());
        }
        return null;
    }

    @Override
    protected Rectangle getPreferredSize() {
        return new Rectangle(2 + this.getMaxLength(), 1);
    }

    private int getMaxLength() {
        int result = 0;
        int i = 0;
        while (i < this._items.size()) {
            String item = (String)this._items.elementAt(i);
            if (item.length() > result) {
                result = item.length();
            }
            ++i;
        }
        return result;
    }

    private String getText() {
        String item;
        String result = null;
        int length = this.getSize().getWidth() - 2;
        String string = item = this.getSelectedItem() == null ? "" : this.getSelectedItem();
        if (item.length() > length) {
            result = item.substring(0, length);
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(item);
            int i = 0;
            while (i < length - item.length()) {
                buf.append(' ');
                ++i;
            }
            result = buf.toString();
        }
        return result;
    }

    @Override
    protected void doPaint() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        String text = "[" + this.getText() + "]";
        CharColor colors = this.hasFocus() ? this.getFocusedPopUpColors() : this.getColors();
        Toolkit.printString(text, rect, colors);
    }

    @Override
    protected boolean isFocusable() {
        return true;
    }

    @Override
    protected void doRepaint() {
        this.doPaint();
    }

    @Override
    protected boolean handleInput(InputChar ch) {
        if (ch.equals(__changeValueChar)) {
            if (this._items.size() > 2) {
                PopUpMenu menu = new PopUpMenu(this.getAbsoluteX(), this.getAbsoluteY(), null);
                int i = 0;
                while (i < this._items.size()) {
                    menu.add((String)this._items.elementAt(i));
                    ++i;
                }
                menu.show();
                if (menu.getSelectedIndex() != -1 && menu.getSelectedIndex() != this.getSelectedIndex()) {
                    this._selectedIndex = menu.getSelectedIndex();
                    this.paint();
                    this._listenerManager.handleEvent(new ValueChangedEvent(this));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected void focus() {
        this.paint();
    }

    @Override
    protected void unfocus() {
        this.paint();
    }

    public void addListener(ValueChangedListener listener) {
        this._listenerManager.addListener(listener);
    }

    public void removeListener(ValueChangedListener listener) {
        this._listenerManager.removeListener(listener);
    }
}

