/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Vector;
import jcurses.event.ItemEvent;
import jcurses.event.ItemListener;
import jcurses.event.ItemListenerManager;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Paging;
import jcurses.util.Rectangle;
import jcurses.widgets.IScrollable;
import jcurses.widgets.ScrollbarPainter;
import jcurses.widgets.Widget;

public class List
extends Widget
implements IScrollable {
    private int _visibleSize = -1;
    private boolean _multiple = false;
    private Vector _items = new Vector();
    private Vector _selected = new Vector();
    private int _startIndex = 0;
    private int _trackedIndex = 0;
    private int _startPos = 0;
    private boolean _selectable = true;
    private String _title = null;
    private ItemListenerManager _listenerManager = new ItemListenerManager();
    private static CharColor __listDefaultColors = new CharColor(7, 0);
    private ScrollbarPainter _scrollbars = null;
    private static CharColor __selectedItemDefaultColors = new CharColor(4, 7, 1);
    private CharColor _selectedItemColors = this.getSelectedItemDefaultColors();
    private static CharColor __titleDefaultColors = new CharColor(7, 1, 2);
    private CharColor _titleColors = this.getTitleDefaultColors();
    private static InputChar __changeStatusChar = new InputChar(' ');
    private static InputChar __callItemChar = new InputChar('\n');

    public List(int visibleSize, boolean multiple) {
        this._visibleSize = visibleSize;
        this._multiple = multiple;
        this._scrollbars = new ScrollbarPainter(this);
    }

    public List(int visibleSize) {
        this(visibleSize, false);
    }

    public List() {
        this(-1, false);
    }

    @Override
    public CharColor getDefaultColors() {
        return __listDefaultColors;
    }

    private CharColor getSelectedItemDefaultColors() {
        return __selectedItemDefaultColors;
    }

    public CharColor getSelectedItemColors() {
        return this._selectedItemColors;
    }

    public void setSelectedItemColors(CharColor colors) {
        this._selectedItemColors = colors;
    }

    private CharColor getTitleDefaultColors() {
        return __titleDefaultColors;
    }

    public CharColor getTitleColors() {
        return this._titleColors;
    }

    public void setTitleColors(CharColor colors) {
        this._titleColors = colors;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    private void drawTitle() {
        String text = null;
        if (this._title != null) {
            text = this._title.length() > this.getSize().getWidth() - 2 ? this._title.substring(0, this.getSize().getWidth() - 2) : this._title;
            Toolkit.printString(text, this.getAbsoluteX() + (this.getSize().getWidth() - text.length()) / 2, this.getAbsoluteY(), this.getTitleColors());
        }
    }

    public void add(int pos, String item) {
        this._items.add(pos, item);
        this._selected.add(pos, new Boolean(false));
        this.reset();
    }

    public void add(String item) {
        this.add(this._items.size(), item);
    }

    public int getItemsCount() {
        return this._items.size();
    }

    public String getItem(int index) {
        return (String)this._items.elementAt(index);
    }

    public void remove(int pos) {
        this._items.remove(pos);
        this._selected.remove(pos);
        this.reset();
    }

    public void remove(String item) {
        int index = this._items.indexOf(item);
        if (index != -1) {
            this._items.remove(index);
            this._selected.remove(index);
        }
    }

    private void dispatchEvent(int index, boolean value) {
        ItemEvent event = new ItemEvent(this, index, this._items.elementAt(index), value ? 0 : 1);
        this._listenerManager.handleEvent(event);
    }

    private void select(int index, boolean value) {
        if (this.isSelected(index) != value) {
            int selected = this.getSelectedIndex();
            this._selected.set(index, new Boolean(value));
            if (!this._multiple && value && selected != -1) {
                this.deselect(selected);
            }
        }
    }

    private void redrawItemBySelecting(int index) {
        if (index != this._trackedIndex || !this.hasFocus()) {
            this.redrawItem(index, this.getRectangle());
        }
    }

    public void select(int index) {
        this.select(index, true);
        if (this.isVisible()) {
            this.redrawItemBySelecting(index);
        }
        this.dispatchEvent(index, true);
    }

    public void deselect(int index) {
        this.select(index, false);
        if (this.isVisible()) {
            this.redrawItemBySelecting(index);
        }
        this.dispatchEvent(index, false);
    }

    public boolean isSelected(int pos) {
        return (Boolean)this._selected.elementAt(pos);
    }

    public Vector getItems() {
        return (Vector)this._items.clone();
    }

    public Vector getSelectedItems() {
        Vector result = new Vector();
        int i = 0;
        while (i < this._items.size()) {
            boolean selected = this.isSelected(i);
            if (selected) {
                result.add(this._items.elementAt(i));
            }
            ++i;
        }
        return result;
    }

    public int[] getSelectedIndexes() {
        int size = 0;
        int i = 0;
        while (i < this._items.size()) {
            boolean selected = this.isSelected(i);
            if (selected) {
                ++size;
            }
            ++i;
        }
        int[] result = new int[size];
        int currentIndex = 0;
        int i2 = 0;
        while (i2 < this._items.size()) {
            boolean selected = this.isSelected(i2);
            if (selected) {
                result[currentIndex] = i2;
                ++currentIndex;
            }
            ++i2;
        }
        return result;
    }

    public String getSelectedItem() {
        Vector results = this.getSelectedItems();
        String result = null;
        if (results.size() == 1) {
            result = (String)results.elementAt(0);
        }
        return result;
    }

    public int getSelectedIndex() {
        int[] results = this.getSelectedIndexes();
        int result = -1;
        if (results.length == 1) {
            result = results[0];
        }
        return result;
    }

    public void clear() {
        this._items.clear();
        this._selected.clear();
        this.reset();
    }

    @Override
    protected Rectangle getPreferredSize() {
        return new Rectangle(-1, this._visibleSize < 0 ? -1 : this._visibleSize + 2);
    }

    private int getVisibleSize() {
        return this.getSize().getHeight() - 2;
    }

    private int getMaximumStartIndex() {
        return this._items.size() < this.getVisibleSize() ? 0 : this._items.size() - this.getVisibleSize();
    }

    private boolean isVisible(int index) {
        if (this._items.size() == 0) {
            return false;
        }
        return index >= this._startIndex && index < this._startIndex + this.getVisibleSize();
    }

    private boolean findNextSelectableItem(int pos, int searchDirection, boolean onlySearchDirection, int stepping) {
        if (this.getItemsCount() == 0) {
            return false;
        }
        int page = this.getPageNumber(pos);
        int start = this.getPageStartIndex(page);
        int end = this.getPageEndIndex(page);
        boolean found = false;
        if (this.isSelectable(pos)) {
            found = true;
        } else {
            int searchPos = pos;
            while (searchPos <= end && searchPos >= start && !found) {
                found = this.isSelectable(searchPos += searchDirection);
            }
            if (!found && !onlySearchDirection) {
                searchPos = pos;
                while (searchPos <= end && searchPos >= start && !found) {
                    found = this.isSelectable(searchPos -= searchDirection);
                }
            }
            pos = searchPos;
        }
        if (found) {
            if (stepping == 0) {
                this._startIndex = start;
            } else if (stepping == -1) {
                if (!this.isVisible(pos)) {
                    this._startIndex = pos;
                }
            } else if (!this.isVisible(pos)) {
                this._startIndex = Math.max(0, pos - this.getVisibleSize() + 1);
            }
            this._trackedIndex = pos;
        }
        return found;
    }

    private boolean incrementTrack() {
        boolean found = false;
        if (this._trackedIndex < this.getItemsCount() - 1) {
            found = this.findNextSelectableItem(this._trackedIndex + 1, 1, true, 1);
        }
        return found;
    }

    private Paging getPaging() {
        return new Paging(this.getVisibleSize(), this.getItemsCount());
    }

    private int getPageNumber(int index) {
        return this.getPaging().getPageNumber(index);
    }

    private int getPageSize() {
        return this.getPaging().getPageSize();
    }

    private int getCurrentPageNumber() {
        return this.getPageNumber(this._trackedIndex);
    }

    int getPageStartIndex(int pageNumber) {
        return this.getPaging().getPageStartIndex(pageNumber);
    }

    int getPageEndIndex(int pageNumber) {
        return this.getPaging().getPageEndIndex(pageNumber);
    }

    int getCurrentPageOffset() {
        return this.getPaging().getPageOffset(this._trackedIndex);
    }

    private boolean incrementPage() {
        int nextPos = 0;
        nextPos = this.getCurrentPageNumber() < this.getPageSize() - 1 ? this.getPaging().getIndexByPageOffset(this.getCurrentPageNumber() + 1, this.getCurrentPageOffset()) : this.getItemsCount() - 1;
        return this.findNextSelectableItem(nextPos, 1, false, 0);
    }

    private boolean decrementPage() {
        int nextPos = 0;
        nextPos = this.getCurrentPageNumber() > 0 ? this.getPaging().getIndexByPageOffset(this.getCurrentPageNumber() - 1, this.getCurrentPageOffset()) : 0;
        return this.findNextSelectableItem(nextPos, -1, false, 0);
    }

    public int getTrackedItem() {
        return this._trackedIndex;
    }

    public void setTrackedItem(int pos) {
        if (pos < 0 || pos >= this.getItemsCount()) {
            throw new IllegalArgumentException("pos must be in the range: 0," + (this.getItemsCount() - 1));
        }
        int backupStartIndex = this._startIndex;
        int backupTrackedIndex = this._trackedIndex;
        if (this.setTrack(pos)) {
            this.redraw(backupStartIndex == this._startIndex, this._trackedIndex, backupTrackedIndex);
        }
    }

    protected boolean setTrack(int pos) {
        return this.findNextSelectableItem(pos, 1, false, 0);
    }

    private boolean decrementTrack() {
        boolean found = false;
        if (this._trackedIndex > 0) {
            found = this.findNextSelectableItem(this._trackedIndex - 1, -1, true, -1);
        }
        return found;
    }

    private void reset() {
        this._startIndex = 0;
        this._trackedIndex = 0;
        this._startPos = 0;
    }

    private int getMaxLength() {
        int result = 0;
        int i = 0;
        while (i < this._items.size()) {
            String item = (String)this._items.elementAt(i);
            if (item.length() > result) {
                result = item.length();
            }
            ++i;
        }
        return result;
    }

    private int getMaxStartPos() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        int width = rect.getWidth() - 2;
        int result = this.getMaxLength() - width;
        result = result < 0 ? 0 : result;
        return result;
    }

    private boolean incrementStartPos() {
        if (this._startPos < this.getMaxStartPos()) {
            ++this._startPos;
            return true;
        }
        return false;
    }

    private boolean decrementStartPos() {
        if (this._startPos > 0) {
            --this._startPos;
            return true;
        }
        return false;
    }

    public void setSelectable(boolean value) {
        this._selectable = value;
    }

    public boolean getSelectable() {
        return this._selectable;
    }

    protected boolean isSelectable(int i) {
        return true;
    }

    private void drawRectangle() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setWidth(rect.getWidth() - 2);
        rect.setHeight(rect.getHeight() - 2);
        rect.setLocation(this.getAbsoluteX() + 1, this.getAbsoluteY() + 1);
        Toolkit.drawRectangle(rect, this.getColors());
    }

    private void drawItems() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        int i = 0;
        while (i < this.getVisibleSize()) {
            int index = this._startIndex + i;
            if (index < this._items.size()) {
                this.printItem(index, rect);
            } else {
                Toolkit.drawRectangle(new Rectangle(rect.getX() + 1, rect.getY() + i + 1, rect.getWidth() - 2, 1), this.getColors());
            }
            ++i;
        }
        if (this._items.size() == 0) {
            this.drawFirstRowSelected();
        }
    }

    @Override
    protected void doPaint() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        Toolkit.drawBorder(rect, this.getColors());
        this.drawTitle();
        this._scrollbars.paint();
        this.drawRectangle();
        this.drawItems();
    }

    private void refresh() {
        this._scrollbars.refresh();
        this.drawRectangle();
        this.drawItems();
    }

    private void drawFirstRowSelected() {
        if (this.hasFocus()) {
            Toolkit.drawRectangle(this.getAbsoluteX() + 1, this.getAbsoluteY() + 1, this.getSize().getWidth() - 2, 1, this.getSelectedItemColors());
        }
    }

    private void redrawItem(int index, Rectangle rect) {
        int x = rect.getX() + 1;
        int y = rect.getY() + 1 + index - this._startIndex;
        int width = rect.getWidth() - 2;
        Rectangle itemRect = new Rectangle(x, y, width, 1);
        boolean toSelect = index == this._trackedIndex && this.hasFocus() || this.isSelected(index);
        CharColor colors = toSelect ? this.getSelectedItemColors() : this.getColors();
        Toolkit.changeColors(itemRect, colors);
    }

    private void redrawSelectedItems() {
        int i = 0;
        while (i < this.getVisibleSize()) {
            int index = this._startIndex + i;
            if (index < this._items.size()) {
                boolean toSelect;
                boolean bl = toSelect = index == this._trackedIndex || this.isSelected(index);
                if (toSelect) {
                    this.redrawItem(index, this.getRectangle());
                }
            }
            ++i;
        }
    }

    private void printItem(int index, Rectangle rect) {
        int x = rect.getX() + 1;
        int y = rect.getY() + 1 + index - this._startIndex;
        int width = rect.getWidth() - 2;
        boolean toSelect = index == this._trackedIndex && this.hasFocus() || this.isSelected(index);
        CharColor colors = toSelect ? this.getSelectedItemColors() : this.getColors();
        String item = this.getItemRepresentation((String)this._items.elementAt(index));
        if (item.length() < this._startPos + 1) {
            item = "";
        } else if (this._startPos != 0) {
            item = item.substring(this._startPos, item.length());
        }
        if (item.length() < width && toSelect) {
            StringBuffer itemBuffer = new StringBuffer();
            itemBuffer.append(item);
            int i = 0;
            while (i < width - item.length()) {
                itemBuffer.append(' ');
                ++i;
            }
            item = itemBuffer.toString();
        }
        Toolkit.printString(item, x, y, width, 1, colors);
    }

    protected String getItemRepresentation(String item) {
        return item;
    }

    @Override
    protected boolean isFocusable() {
        return true;
    }

    @Override
    protected void doRepaint() {
        this.doPaint();
    }

    protected InputChar getChangeStatusChar() {
        return __changeStatusChar;
    }

    private void callItem(int index) {
        ItemEvent event = new ItemEvent(this, index, this._items.elementAt(index), 2);
        this._listenerManager.handleEvent(event);
    }

    private void redraw(boolean flag, int trackedIndex, int backupTrackedIndex) {
        if (flag) {
            this.redrawItem(trackedIndex, this.getRectangle());
            this.redrawItem(backupTrackedIndex, this.getRectangle());
        } else {
            this.paint();
        }
    }

    @Override
    protected boolean handleInput(InputChar ch) {
        int backupStartIndex = this._startIndex;
        int backupTrackedIndex = this._trackedIndex;
        if (this._items.size() == 0) {
            return false;
        }
        if (ch.getCode() == InputChar.KEY_RIGHT) {
            if (this.incrementStartPos()) {
                this.refresh();
            }
            return true;
        }
        if (ch.getCode() == InputChar.KEY_LEFT) {
            if (this.decrementStartPos()) {
                this.refresh();
            }
            return true;
        }
        if (ch.getCode() == InputChar.KEY_UP) {
            if (this.decrementTrack()) {
                this.redraw(backupStartIndex == this._startIndex, this._trackedIndex, backupTrackedIndex);
            }
            return true;
        }
        if (ch.getCode() == InputChar.KEY_DOWN) {
            if (this.incrementTrack()) {
                this.redraw(backupStartIndex == this._startIndex, this._trackedIndex, backupTrackedIndex);
            }
            return true;
        }
        if (ch.getCode() == InputChar.KEY_HOME) {
            if (this.setTrack(0)) {
                this.redraw(backupStartIndex == this._startIndex, this._trackedIndex, backupTrackedIndex);
            }
            return true;
        }
        if (ch.getCode() == InputChar.KEY_END) {
            if (this.setTrack(this.getItemsCount() - 1)) {
                this.redraw(backupStartIndex == this._startIndex, this._trackedIndex, backupTrackedIndex);
            }
            return true;
        }
        if (ch.getCode() == InputChar.KEY_NPAGE) {
            if (this.incrementPage()) {
                this.redraw(backupStartIndex == this._startIndex, this._trackedIndex, backupTrackedIndex);
            }
            return true;
        }
        if (ch.getCode() == InputChar.KEY_PPAGE) {
            if (this.decrementPage()) {
                this.redraw(backupStartIndex == this._startIndex, this._trackedIndex, backupTrackedIndex);
            }
            return true;
        }
        if (ch.equals(__changeStatusChar) && this.getSelectable()) {
            if (this.isSelected(this._trackedIndex)) {
                this.deselect(this._trackedIndex);
            } else {
                this.select(this._trackedIndex);
            }
            return true;
        }
        if (ch.equals(__callItemChar)) {
            this.callItem(this._trackedIndex);
            return true;
        }
        return false;
    }

    @Override
    protected void focus() {
        this.redrawSelectedItems();
    }

    @Override
    protected void unfocus() {
        this.redrawSelectedItems();
    }

    public void addListener(ItemListener listener) {
        this._listenerManager.addListener(listener);
    }

    public void removeListener(ItemListener listener) {
        this._listenerManager.removeListener(listener);
    }

    @Override
    public boolean hasHorizontalScrollbar() {
        return true;
    }

    @Override
    public boolean hasVerticalScrollbar() {
        return true;
    }

    @Override
    public Rectangle getBorderRectangle() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        return rect;
    }

    private int getWidth() {
        return this.getSize().getWidth() - 2;
    }

    @Override
    public float getHorizontalScrollbarOffset() {
        if (this._items.size() == 0 || this.getMaxLength() <= this.getWidth()) {
            return 0.0f;
        }
        if (this.getMaxLength() > this.getWidth()) {
            return (float)this._startPos / (float)this.getMaxLength();
        }
        return 0.0f;
    }

    @Override
    public float getHorizontalScrollbarLength() {
        if (this._items.size() == 0 || this.getMaxLength() <= this.getWidth()) {
            return 0.0f;
        }
        if (this.getMaxLength() > this.getWidth()) {
            return (float)this.getWidth() / (float)this.getMaxLength();
        }
        return 0.0f;
    }

    @Override
    public float getVerticalScrollbarOffset() {
        if (this._items.size() == 0) {
            return 0.0f;
        }
        if (this._items.size() > this.getVisibleSize()) {
            return (float)this._startIndex / (float)this._items.size();
        }
        return 0.0f;
    }

    @Override
    public float getVerticalScrollbarLength() {
        if (this._items.size() == 0) {
            return 0.0f;
        }
        if (this._items.size() > this.getVisibleSize()) {
            return (float)this.getVisibleSize() / (float)this._items.size();
        }
        return 0.0f;
    }

    @Override
    public CharColor getBorderColors() {
        return this.getColors();
    }

    @Override
    public CharColor getScrollbarColors() {
        CharColor colors;
        colors.setBlackWhiteAttribute((colors = new CharColor(this.getColors().getForeground(), this.getColors().getBackground())).getBlackWhiteAttribute() == 1 ? (short)0 : 1);
        return colors;
    }
}

